/*
 * NameResolver.java:  a name resolver
 * for the Nomencurator, a Nomenclature Heuristic Model.
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: NameResolver.java,v 1.4 2002/11/12 03:17:07 nozomi Exp $
 * $Log: NameResolver.java,v $
 * Revision 1.4  2002/11/12 03:17:07  nozomi
 * add put/get methods
 *
 * Revision 1.3  2002/09/17 05:00:56  nozomi
 * improve resolve() method
 *
 * Revision 1.2  2002/09/10 07:14:51  nozomi
 * modify put() method
 *
 * Revision 1.1  2002/09/10 01:54:09  nozomi
 * a name resolver using Name as an indirect reference
 *
 */

package org.nomencurator;

import java.util.Hashtable;

/**
 * <CODE>NameResolver</CODE> provides a mechanism to resolve indirect reference
 * by <CODE>Name</CODE>.
 *
 * @version 	12 Nov 2002
 * @author 	Nozomi `James' Ytow
 */
public class NameResolver
    extends Hashtable
{ 

    public NameResolver()
    {
	super();
    }

    public NameResolver(int initialCapacity)
    {
	super(initialCapacity);
    }

    public NameResolver(int initialCapacity, float loadFactor)
    {
	super(initialCapacity, loadFactor);
    }

    public Object put(Nameable name)
    {
	return put(name.getName(), name);
    }

    public Object put(Object key, Object value)
    {
	if(!(value instanceof Name) ||
	   (!((Name)value).isNominal()))
	    return value;

	return super.put(key, value);
    }

    public Object get(Nameable name)
    {
	return get(name.getName());
    }

    public Object get(Object key)
    {
	if(key == null)
	    return null;
	Object o = super.get(key);
	if(o == null ||
	   !(o instanceof Name))
	    return o;

	return ((Name)o).getEntity();
    }

    public Name resolve(Name name)
    {
	if(name == null)
	    return name;
	return resolve(name.getName(), name);
    }

    public Name resolve(Object key, Name name)
    {
	Object value = get(key);
	if(value == null ||
	   value == name ||
	   !(value instanceof Name))
	    return null;

	Name unresolved = (Name)value;
	unresolved.setEntity(name);
	remove(key);
	if(name.isNominal()) {
	    put(key, name);
	}
	return unresolved;
    }
}



