/*
 * Nameable.java: an interface provaides nameing
 * for Java implementation of the Nomencurator, 
 * a Nomenclature Hierarchy-history Model.
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: Nameable.java,v 1.1 2002/08/29 19:46:38 nozomi Exp $
 * $Log: Nameable.java,v $
 * Revision 1.1  2002/08/29 19:46:38  nozomi
 * implements interface Nameable
 *
 */

package org.nomencurator;

/**
 * An interface dafine namein action
 *
 * @version 	29 Aug 2002
 * @author 	Nozomi `James' Ytow
 */
public interface Nameable
{
    /**
     * Gets name in <CODE>String</CODE>
     *
     * @return String representing a name
     */
    public String getName();

    /**
     * Gives a name as a <CODE>String</CODE>
     *
     * @param name String representing the name
     */
    public void setName(String name);

    /**
     * Gets a lexicon representing this object
     *
     * @return Object representing this object
     */
    //    public Object getLexicon();

    /**
     * Gives <CODE>lexicon</CODE> as the name
     *
     * @param lexicon Object representing a name
     */
    //    public void getLexicon(Object lexicon);

}

