/*
 * Nomencurator.java:  a Java implementation of Nomencurator class
 * for the Nomencurator, a Nomenclature Heuristic Model.
 *
 * Copyright (c) 1999, 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: Nomencurator.java,v 1.7 2002/11/20 05:22:24 nozomi Exp $
 * $Log: Nomencurator.java,v $
 * Revision 1.7  2002/11/20 05:22:24  nozomi
 * use org.nomencurator.util.ObjectPool
 *
 * Revision 1.6  2002/11/12 03:12:45  nozomi
 * use ObjectPool
 *
 * Revision 1.5  2002/04/16 03:53:37  nozomi
 * migration to NameUsage from NameRecord
 *
 * Revision 1.4  2002/04/08 01:52:57  nozomi
 * fix spell error
 *
 * Revision 1.3  2002/04/04 23:49:41  nozomi
 * Appearance supercedes Citation
 *
 * Revision 1.2  2002/04/01 08:16:14  nozomi
 * use java.util.Vector
 *
 * Revision 1.1.1.1  2002/01/16 12:33:33  ryo
 * initial import into CVS
 *	
 * Revision 1.1  1999/10/24 08:06:37  nozomi
 * Initial revision
 */

package org.nomencurator;

import java.io.Serializable;
import java.lang.String;
import java.util.Hashtable;
import java.util.Vector;

import org.nomencurator.Affiliation;
import org.nomencurator.Annotation;
import org.nomencurator.Author;
import org.nomencurator.Appearance;
import org.nomencurator.NameUsage;
import org.nomencurator.Publication;

import org.nomencurator.util.ObjectPool;

/**
 * <CODE>Nomencurator</CODE> provides pooled objects
 * with name resolver

 * @see <A HREF="http://www.nomencurator.org/">http://www.nomencurator.org</A>
 *
 * @version 	20 Nov 2002
 * @author 	Nozomi `James' Ytow
 */
public class Nomencurator
    extends Hashtable 
    implements Serializable { 

    protected static Nomencurator instance;

    protected ObjectPool pool;

    protected NameResolver resolver;

    public static Nomencurator getInstance()
    {
	if(instance == null)
	    instance = new Nomencurator();
	
	return instance;
    }

    protected Nomencurator()
    {
	this(65536);
    }

    protected Nomencurator(int size)
    {
	pool = new ObjectPool(size);
	resolver = new NameResolver();
    }

    public Nameable put(Nameable obj)
    {
	return (Nameable)pool.put(obj);
    }

    public Name put(Name obj)
    {
	if(obj.isNominal())
	    resolver.put(obj.getName(), obj);
	else
	    pool.put(obj);
	return resolve(obj);
    }

    public Nameable get(String name)
    {
	Nameable n = (Nameable)pool.get(name);
	if(n == null)
	    n = (Nameable)resolver.get(name);
	return n;
    }

    public Name resolve(Name obj)
    {
	return resolver.resolve(obj);
    }

    public Name putToResolver(Object key, Name obj)
    {
	if(!obj.isNominal() || resolver.get(key) != null)
	    return (NamedObject)resolver.resolve(obj);
	return (NamedObject)resolver.put(key, obj);
    }


    public NamedObject resolve(Object key, Name name)
    {
	return (NamedObject)resolver.resolve(key, name);
    }

    /*
    public NamedObject resolve(Name name)
    {
	return (NamedObject)resolver.resolve(name);
    }
    */

    public NamedObject putUnresolved(Nameable name)
    {
	return (NamedObject)resolver.put(name.getName(), name);
    }

    public NamedObject getUnresolved(Object key)
    {
	return (NamedObject)resolver.get(key);
    }


    /*
    Vector unHashed = null;

  static final int NOMENCURATOR = 0;
    //  static final int NAMERECORD   = 1;
  static final int NAMEUSAGE   = 1;
  static final int PUBLICATION  = 2;
  static final int APPEARANCE   = 3;
  static final int AUTHOR       = 4;
  static final int ANNOTATION   = 8;
  static final int AFFILIATION  = 16;
  static final int NRNODE       = 32;

  private void _Nomencurator(){
    unHashed = new Vector();
  }

  public Nomencurator(){
    super();
    _Nomencurator();
  }

  public Nomencurator(int initialCapacity) {
    super(initialCapacity);
    _Nomencurator();
  }

  public Nomencurator(int initialCapacity, float loadFactor) {
    super(initialCapacity, loadFactor);
    _Nomencurator();
  }

  public Object put(Object key, Object value){
    Object ret = null;
    if(key != null){
      ret = super.put(key, value);
      if(ret != null)
	unHashed.addElement(value);
    }
    return ret;
  }

  public Object put(NamedObject value){
    return super.put(value.persistentID(), value);
  }

  private int currentParsing = NOMENCURATOR;
  private NamedObject namedobject = null;
  private int nesting = 0;

  public NamedObject parseLine(String str){
    NamedObject ret = null;
    String line = str.trim();
    int length = line.length();
    int previousNest = nesting;
    for(int i = 0; i < length; i++){
      char ch = line.charAt(i);
      if(ch == '{')
	nesting++;
      if(ch == '}')
	nesting--;
    }
    if(nesting == 0 && previousNest != 0){
      ret = namedobject;
      namedobject = null;
      currentParsing = NOMENCURATOR;
      return ret;
    }

    if(line.length() == 0 || line.charAt(0) == '%' ||line.startsWith("persistentID")){
      return ret;
    }

    if(previousNest == 0){ //new object
      if(line.startsWith("NameUsage")){
	currentParsing = NAMEUSAGE;
	namedobject = new NameUsage();
      }
      else if(line.startsWith("Publication")){
	currentParsing = PUBLICATION;
	namedobject = new Publication();
      }
      else if(line.startsWith("Appearance")){
	currentParsing = APPEARANCE;
	namedobject = new Appearance();
      }
      else if(line.startsWith("Author")){
	currentParsing = AUTHOR;
	namedobject = new Author();
      }
      else if(line.startsWith("Annotation")){
	currentParsing = ANNOTATION;
	namedobject = new Annotation();
      }
      else if(line.startsWith("Affiliation")){
	currentParsing = AFFILIATION;
	namedobject = new Affiliation();
      }
    */
	/*
      else if(line.startsWith("NRnode")){
	currentParsing = NRNODE;
	namedobject = new NRnode();
      }
      */
    /*
    }

    else{
      namedobject.parseLine(line);
    }
    return ret;
  }
    */
}



