/*
 * AppletFrame.java:  a Frame to hold applet 
 *
 * Copyright (c) 2000, 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: AppletFrame.java,v 1.2 2002/08/01 04:19:07 nozomi Exp $
 * $Log: AppletFrame.java,v $
 * Revision 1.2  2002/08/01 04:19:07  nozomi
 * adapt to JDK 1.4
 *
 * Revision 1.1.1.1  2002/01/16 12:33:34  ryo
 * initial import into CVS
 */

package org.nomencurator.applet;

import java.awt.Container;
//import java.awt.Frame;
import java.awt.Image;

import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import java.net.URL;

import java.applet.Applet;
import java.applet.AudioClip;
//import org.nomencurator.applet.Applet;

import java.applet.AppletContext;
import java.applet.AppletStub;

import java.io.InputStream;
import java.io.IOException;

import java.util.Enumeration;
import java.util.Iterator;

import jp.kyasu.awt.Frame;

import org.nomencurator.awt.Button;

/**
 * The <code>ClosableApplet</code> class implements a pakcable applet as an extension
 * of java.applet.Applet.
 *
 * @see 	java.applet.Applet
 *
 * @version 	01 Aug 2002
 * @author 	Nozomi `James' Ytow
 */

public class AppletFrame
    extends org.nomencurator.awt.Frame
    implements WindowListener, AppletStub, AppletContext
{
    
    protected Applet applet;
    
    public AppletFrame()
    {
	this(null);
    }
    
    public AppletFrame(Applet applet) {
	super();
	addWindowListener(this);
	this.applet = applet;
	if(applet != null) {
	    setTitle(applet.getClass().getName());
	    this.add(applet);
	    if(applet instanceof ApplicationApplet) {
		((ApplicationApplet)applet).init(this);
	    }
	    else {
		applet.init();
	    }
	    applet.setStub(this);
	    show();
	    applet.start();
	}
    }
    
    public Applet getApplet() {
	return applet;
    }
    
    public void windowClosing(WindowEvent e) {
    }
    
    public void windowClosed(WindowEvent e) {
	Object eventSource = e.getSource();
	if(eventSource == this) {
	    System.exit(0);
	}
    }
    
    public void windowOpened(WindowEvent e) {
    }
    
    public void windowActivated(WindowEvent e) {
    }
    
    public void windowDeactivated(WindowEvent e) {
    }
    
    public void windowIconified(WindowEvent e) {
    }
    
    public void windowDeiconified(WindowEvent e) {
    }

    public boolean isActive() {
	return true;
    }

    public URL getDocumentBase() {
	return null;
    }

    public URL getCodeBase() {
	return null;
    }

    public String getParameter(String name) {
	return "";
    }

    public AppletContext getAppletContext() {
	return this;
    }

    public void appletResize(int width, int height) {
    }
	
    public AudioClip getAudioClip(URL url) {
	return null;
    }

    public Image getImage(URL url) {
	return null;
    }

    public Applet getApplet(String name) {
	return null;
    }

    public Enumeration getApplets() {
	return null;
    }

    public void showDocument(URL url) {
    }

    public void showDocument(URL url, String target) {
    }

    public void showStatus(String status) {
    }


    /**
     * Relates specified <CODE>stream</CODE> to the <CODE>key</CODE> of
     * this <CODE>AppletContext</CODE>.  Old value will be replaced
     * if this <CODE>AppletContext</CODE> holds a mapping of the <CODE>key</CODE>
     * previously.
     * <P>
     * Mapping between <CODE>stream</CODE> and <CODE>key</CODE> is
     * managed by code base, i.e. an <CODE>Applect</CODE> on a code base
     * cannot access to a stream created by another <CODE>Applect</CODE> on
     * another code base.
     *
     * @param key <CODE>String</CODE> representing key to be related to
     * <CODE>stream</CODE>
     * @param stream <CODE>InputStream</CODE> to be related to the <CODE>key</CODE>,
     * or null to delete the <CODE>key</CODE>.
     *
     * @exception IOException if stream size exceeds specified size limitation which is
     * implementation dependent
     *
     * @since JDK1.4
     */
    public void setStream(String key,
			  InputStream stream)
	throws IOException
    {
	;
    }


    /**
     * Returns the stream related to <CODE>key</CODE> in this <CODE>AppletContext</CODE>,
     * or null if stream of the <CODE>key</CODE> is not included in the target
     * <CODE>Applet</CODE>.
     * <P>
     * Mapping between <CODE>stream</CODE> and <CODE>key</CODE> is
     * managed by code base, i.e. an <CODE>Applect</CODE> on a code base
     * cannot access to a stream created by another <CODE>Applect</CODE> on
     * another code base.
     *
     * @param key <CODE>String</CODE> representing key to the stream
     *
     * @return stream to which the <CODE>key</CODE> is related to
     *
     * @since JDK1.4
     */
    public InputStream getStream(String key)
    {
	return null;
    }

    /**
     * Iterates all keys of streams in this <CODE>ApplectContext</CODE>.
     *
     * <P>
     * Mapping between <CODE>stream</CODE> and <CODE>key</CODE> is
     * managed by code base, i.e. an <CODE>Applect</CODE> on a code base
     * cannot access to a stream created by another <CODE>Applect</CODE> on
     * another code base.
     *
     * @return Iterator of all names of streams in this <CODE>ApplectContext</CODE>
     *
     * @since JDK1.4
     */
    public Iterator getStreamKeys()
    {
	return null;
    }

    static public void main(String args[]) {
	ApplicationApplet ae = new ApplicationApplet(); 
	Frame frame  = new Frame();
	ae.init(frame);
	frame.add(ae);
	frame.show();
	ae.start();
    }
    
}

