/*
 *
 * ApplicationApplet.java:  An Applet knows whether it works as
 * an Applet or application.
 *
 * Copyright (c) 2000 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: ApplicationApplet.java,v 1.1.1.1 2002/01/16 12:33:34 ryo Exp $
 *	$Log: ApplicationApplet.java,v $
 *	Revision 1.1.1.1  2002/01/16 12:33:34  ryo
 *	initial import into CVS
 *	
 *	
 *
 */

package org.nomencurator.applet;

import java.awt.Container;
import java.awt.Frame;

import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

//import java.applet.Applet;
import org.nomencurator.applet.Applet;

import org.nomencurator.awt.Button;

import org.nomencurator.awt.util.AWTtools;

/**
 * The <code>ClosableApplet</code> class implements a pakcable applet as an extension
 * of java.applet.Applet.
 *
 * @see 	java.applet.Applet
 *
 * @version 	09 Jan 2000
 * @author 	Nozomi `James' Ytow
 */

public class ApplicationApplet
    extends Applet
    implements WindowListener
{
    
    protected Frame frame;

    public ApplicationApplet()
    {
	super();
    }
    
    public void init()
    {
	init(null);
    }
    
    public void init(Frame frame)
    {
	super.init();
	this.frame = frame;
	if(this.frame != null) {
	    this.frame.addWindowListener(this);
	}
    }

    public Frame getFrame()
    {
	return AWTtools.getFrame(this);
    }

    public void windowClosing(WindowEvent e)
    {

    }
    
    public void windowClosed(WindowEvent e)
    {
	Object eventSource = e.getSource();
	if(eventSource == frame && frame != null) {
	    System.exit(0);
	}
    }
    
    public void windowOpened(WindowEvent e) {
    }
    
    public void windowActivated(WindowEvent e) {
    }
    
    public void windowDeactivated(WindowEvent e) {
    }
    
    public void windowIconified(WindowEvent e) {
    }
    
    public void windowDeiconified(WindowEvent e) {
    }
    
    static public void main(String args[]) 
    {
	ApplicationApplet ae = new ApplicationApplet(); 
	Frame frame  = new Frame();
	ae.init(frame);
	frame.add(ae);
	frame.show();
	ae.start();
    }
}
