/*
 *
 * ClosableApplet.java:  a packable applet 
 *
 * Copyright (c) 2000 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: ClosableApplet.java,v 1.1.1.1 2002/01/16 12:33:34 ryo Exp $
 *	$Log: ClosableApplet.java,v $
 *	Revision 1.1.1.1  2002/01/16 12:33:34  ryo
 *	initial import into CVS
 *	
 *	
 *
 */

package org.nomencurator.applet;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

//import org.nomencurator.applet.Applet;
import org.nomencurator.applet.ApplicationApplet;
import org.nomencurator.awt.Button;

/**
 * The <code>ClosableApplet</code> class implements a pakcable applet as an extension
 * of java.applet.Applet.
 *
 * @see 	java.applet.Applet
 *
 * @version 	09 Jan 2000
 * @author 	Nozomi `James' Ytow
 */

public class ClosableApplet
    //    extends Applet
    extends ApplicationApplet
    implements ActionListener {
    
    protected Button[] buttons;

    public ClosableApplet()
    {
	super();
    }

    public void init(Frame frame)
    {
	super.init(frame);
    }

    protected void createButtons()
    {
	createButtons(new Button[]{ new CloseButton() });
    }

    protected void createButtons(Button[] buttons)
    {
	this.buttons = buttons;
	//	addActionListenerTo(this.buttons);
    }

    protected void addActionListenerTo(Button[] buttons)
    {
	addButtonActionListener(this);
	for(int i = 0; i < buttons.length; i++){
	    //	    buttons[i].addActionListener(this);
	    if(buttons[i] instanceof CloseButton)
		((CloseButton)buttons[i]).setApplet(this);
	}
    }

    protected void addButtonActionListener(ActionListener listener)
    {
	for(int i = 0; i < buttons.length; i++) {
	    buttons[i].addActionListener(listener);
	}
    }

    protected void removeActionListenerFrom(Button[] buttons)
    {
	removeActionListener(this);
    }

    protected void removeActionListener(ActionListener listener)
    {
	for(int i = 0; i < buttons.length; i++) {
	    buttons[i].removeActionListener(listener);
	}
    }


    public void actionPerformed(ActionEvent e)
    {
	Object eventSource = e.getSource();
	for(int i = 0; i < buttons.length; i++){
	    if(eventSource == buttons[i]){
		buttons[i].run();
		return;
	    }
	}
    }
}

