/*
 *
 * ClosableFrame.java:  a Frame closable with the specified button.
 * Displaying the button on screen is users obligation.
 *
 * Copyright (c) 2000 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: ClosableFrame.java,v 1.1.1.1 2002/01/16 12:33:33 ryo Exp $
 *	$Log: ClosableFrame.java,v $
 *	Revision 1.1.1.1  2002/01/16 12:33:33  ryo
 *	initial import into CVS
 *	
 *	
 *
 */

package org.nomencurator.awt;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import jp.kyasu.awt.Frame;

import jp.kyasu.graphics.Text;
import jp.kyasu.graphics.Visualizable;
import jp.kyasu.graphics.VAbstractButton;

import org.nomencurator.awt.Button;
import org.nomencurator.awt.Closable;
import org.nomencurator.awt.CloseButton;

/**
 * The <code>ClosableFrame</code> class implements a closable <code>Frame</code>
 * which has a <code>Button</code> to close the <code>Frame</code>.
 * <p>
 *
 * @see 	jp.kyasu.awt.Frame
 * @see 	org.nomencurator.awt.Button
 *
 * @version 	
 * @author 	
 */

public class ClosableFrame extends Frame 
				   //    implements ActionListener, WindowListener {
    implements ActionListener, Closable {

    /*
      Command Buttons
    */
    protected Button[] buttons;

    boolean closableByWM;

    /**
     * Constructs a closable frame without title.
     */
    public ClosableFrame()
    {
	this("");
    }

    public ClosableFrame(String title)
    {
	this(title, null);
    }

    public ClosableFrame(String title, Button[] buttons)
    {
	super(title);
	addWindowListener(this);
	if(buttons == null ||
	   buttons.length == 0 )
	    buttons = createButtons();
	this.buttons = buttons;
	addActionListenerTo(this.buttons);
	closableByWM = true;
    }

    protected Button[] createButtons()
    {
	return new Button[]{ new CloseButton(this) };
    }

    protected void addActionListenerTo(Button[] buttons)
    {
	for(int i = 0; i < buttons.length; i++){
	    //    buttons[i].addActionListener(this);
	    if(buttons[i] instanceof CloseButton)
		((CloseButton)buttons[i]).setWindow(this);
	}
    }

    protected void removeActionListenerFrom(Button[] buttons)
    {
	for(int i = 0; i < buttons.length; i++){
	    buttons[i].removeActionListener(this);
	}
    }

    public void addCloseButton(Button button)
    {
	addCloseButton(button, buttons.length);
    }

    public void addCloseButton(Button button, int index)
    {
	Button[] newButtons = new Button[buttons.length + 1];
	int i = 0;
	for(; i < index; i++) {
	    newButtons[i] = buttons[i];
	}
	newButtons[i++] = button;
	
	for(int j = index; i < newButtons.length; i++, j++) {
	    newButtons[i] = buttons[j];
	}

	button.addActionListener(this);
	buttons = newButtons;
    }

    public void removeCloseButton(Button button)
    {
	int i = 0;
	for(; i < buttons.length && buttons[i] != button; i++) {
	    ;
	}
	if(i != buttons.length)
	    removeCloseButton(i);
    }

    public void removeCloseButton(int index)
    {
	Button[] newButtons = new Button[buttons.length - 1];
	int i = 0;
	for(; i < index; i++) {
	    newButtons[i] = buttons[i];
	}
	buttons[i].removeActionListener(this);
	for(int j = index + 1; i < newButtons.length; i++, j++) {
	    newButtons[i] = buttons[j];
	}
	buttons = newButtons;
    }


    public void setCloseButtons(Button[] buttons)
    {
	removeActionListenerFrom(this.buttons);
	this.buttons = buttons;
	addActionListenerTo(this.buttons);
    }

    public Button getCloseButton()
    {
	return getCloseButton(0);
    }

    public Button getCloseButton(int index)
    {
	return buttons[index];
    }

    public Button[] getCloseButtons()
    {
	return buttons;
    }

    public void actionPerformed(ActionEvent e)
    {
	Object eventSource = e.getSource();
	for(int i = 0; i < buttons.length; i++){
	    if(eventSource == buttons[i]){
		buttons[i].run();
		return;
	    }
	}
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void closableByWM(boolean closable)
    {
	closableByWM = closable;
    }

    public void setClosableByWM(boolean closable)
    {
	closableByWM(closable);
    }

    public boolean isClosableByWM()
    {
	return closableByWM;
    }

    public boolean getClosableByWM()
    {
	return isClosableByWM();
    }

    public void disableClosingByWM()
    {
	closableByWM(false);
    }

    public void enableClosingByWM()
    {
	closableByWM(true);
    }

}
