/*
 *
 * ClosableWindow.java:  a Window closable with the specified button.
 * Displaying the button on screen is users obligation.
 *
 * Copyright (c) 2000 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: ClosableWindow.java,v 1.1.1.1 2002/01/16 12:33:33 ryo Exp $
 *	$Log: ClosableWindow.java,v $
 *	Revision 1.1.1.1  2002/01/16 12:33:33  ryo
 *	initial import into CVS
 *	
 *	
 *
 */

package org.nomencurator.awt;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;

import jp.kyasu.awt.Button;
import jp.kyasu.awt.Frame;
import jp.kyasu.awt.Window;

import org.nomencurator.awt.Closable;

public class ClosableWindow extends Window 
    implements ActionListener, Closable {
    
    protected Button closeButton;
    protected String closeCommand;

    boolean closableByWM;

    public ClosableWindow(Frame frame, Button closeButton) {
	this(frame, closeButton, closeButton.getLabel());
    }

    public ClosableWindow(Frame frame, Button closeButton, String closeCommand) {
	super(frame);
	this.closeButton = closeButton;
	this.closeButton.addActionListener(this);
	this.closeCommand = closeCommand;
	addWindowListener(this);
	closableByWM = true;
    }

    public void setCloseCommand(String closeCommand) {
	this.closeCommand = closeCommand;
    }

    public String getCloseCommand() {
	return this.closeCommand;
    }

    public void setCloseButton(Button closeButton) {
	this.closeButton = closeButton;
	if(closeCommand != null){
	    if(this.closeButton != null)
		closeCommand = this.closeButton.getLabel();
	    else
		closeCommand = null;
	}
    }

    public Button getCloseButton() {
	return closeButton;
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
	if (e.getSource() == this.closeButton && command.equals(closeCommand)){
	    this.dispose();
	}
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void closableByWM(boolean closable)
    {
	closableByWM = closable;
    }

    public void setClosableByWM(boolean closable)
    {
	closableByWM(closable);
    }

    public boolean getClosableByWM()
    {
	return isClosableByWM();
    }

    public boolean isClosableByWM()
    {
	return closableByWM;
    }

    public void disableClosingByWM()
    {
	closableByWM(false);
    }

    public void enableClosingByWM()
    {
	closableByWM(true);
    }

}
