/*
 *
 * DefaultSingleSelectionModel.java:
 *  an impelemntation of SingleSelectionModel
 *
 * Copyright (c) 2001 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: DefaultSingleSelectionModel.java,v 1.2 2002/06/06 19:09:46 nozomi Exp $
 * $Log: DefaultSingleSelectionModel.java,v $
 * Revision 1.2  2002/06/06 19:09:46  nozomi
 * object addition pre-check
 *
 * Revision 1.1  2002/01/29 09:44:32  nozomi
 * initial import into CVS
 */

package org.nomencurator.awt;

import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Vector;

import org.nomencurator.awt.SingleSelectionModel;

import org.nomencurator.awt.event.ChangeEvent;
import org.nomencurator.awt.event.ChangeListener;

public class DefaultSingleSelectionModel
    implements SingleSelectionModel
{

    //Vector to store items
    protected Vector items;

    //Hashtable provides index table of items in the vector 
    protected Hashtable indices;

    //index of selected item
    protected int selectedIndex;

    protected transient ChangeEvent changeEvent;

    //protected EventListenerList listenerList;
    protected Vector changeListeners;

    //Constructor
    /**
     *
     * Constructs DefaultSingleSelectionModel
     *
     */
    public DefaultSingleSelectionModel()
    {
	items = new Vector();
	indices = new Hashtable();
	selectedIndex = UNSELECTED;
	
	changeListeners = new Vector();
    }

    // methods not covered by 
    // javax.swing.DefaultSingleSelectionModel

    public Object getSelectedObject()
    {
	return items.elementAt(selectedIndex);
    }

    public Object getObjectAt(int index)
    {
	return items.elementAt(index);
    }

    public int getIndexOf(Object object)
    {
	if(object == null)
	    return -1;
	Integer index = (Integer)(indices.get(object));
	if(null == index)
	    return -1;
	return index.intValue();
    }

    public void add(Object object)
    {
	addObjectAt(object, indices.size());
    }


    public void addObjectAt(Object object, int index)
    {
	if(object == null)
	    return;

	//	if(items.contains(object))
	//	    return;

	if(index == -1) 
	    index = items.size();

	items.insertElementAt(object, index);

	int size = items.size() - 1;
	for(int i = index; i < size; i++)
	    indices.put(items.elementAt(i), new Integer(i));
	    
    }

    public void remove(Object object)
    {
	Integer index = (Integer)(indices.get(object));
	if(null == index)
	    return;
	removeObjectAt(index.intValue());
    }

    public void removeObjectAt(int index)
    {
	int size = items.size() - 1;
	if(index < 0 || index > size)
	    return;

	items.removeElementAt(index);

	size--;
	for(int i = index; i < size; i++)
	    indices.put(items.elementAt(i), new Integer(i));
	    
    }


    //SingleSelectionModel methods
    /**
     *
     * Returns selected index
     *
     * @return selected index or -1 if nothing is selected
     *
     * @see setSelectedIndex(int)
     */
    public int getSelectedIndex()
    {
	return selectedIndex;
    }


    /**
     *
     * Sets selected index to <code>index</code> and notifies to all
     * listeners if model changed (i.e. <code>index</code> != 
     * current selected index).
     *
     * @param index an int specifying selection index
     *
     * @see getSelectedIndex()
     * @see addChangeListener(ChangeListener)
     */
    public void setSelectedIndex(int index)
    {
	if(index == selectedIndex)
	    return;
	selectedIndex = index;
	fireStateChanged();
    }

         
    /**
     *
     * Clears selection (sets selected index to -1)
     *
     */
    public void clearSelection()
    {
	setSelectedIndex(UNSELECTED);
    }


    /**
     *
     * Returns true if an item is selected in the model
     *
     * @return true if an item is selected
     */
    public boolean isSelected()
    {
	return !(selectedIndex == UNSELECTED);
    }



    /**
     *
     * Adds <code>listener</code> to the list of <code>ChangeListener</code>s
     *
     * @param listener a <code>ChangeLister</code> to be added
     */
    public void addChangeListener(ChangeListener listener)
    {
	changeListeners.addElement(listener);
    }


    /**
     *
     * Removes <code>listener</code> from the list of <code>ChangeListener</code>s
     *
     * @param listener a <code>ChangeLister</code> to be removed
     */
    public void removeChangeListener(ChangeListener listener)
    {
	changeListeners.removeElement(listener);
    }


    protected void fireStateChanged()
    {
	Enumeration enum = changeListeners.elements();
	while(enum.hasMoreElements()) {
	    if(changeEvent == null)
		changeEvent = new ChangeEvent(this);
	    ((ChangeListener)(enum.nextElement())).stateChanged(changeEvent);
	}
    }

    
    /**
     *
     * Returns an array of all listeners receiving specified <code>listenerType</code>
     *
     * @return all object will receive <code>listenerType</code> from this model
     *
     * @since 1.3
     */
    public EventListener[] getListeners(Class listenerType)
    {
	EventListener[] eventListeners
	    = new EventListener[changeListeners.size()];
	Enumeration enum = changeListeners.elements();
	int i = 0;
	while(enum.hasMoreElements()) {
	    eventListeners[i]
		= (EventListener)(enum.nextElement());
	}
	
	return eventListeners;
    }
}
