/*
 *
 * PackAdaptor.java:  an adaptor provides Pack interface
 * for TaxoNote based on Nomencurator data model
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: PackAdaptor.java,v 1.1 2002/01/29 09:44:32 nozomi Exp $
 *	$Log: PackAdaptor.java,v $
 *	Revision 1.1  2002/01/29 09:44:32  nozomi
 *	initial import into CVS
 *	
 *	
 *
 */

package org.nomencurator.awt;

import java.awt.Component;
import java.awt.Container;

/**
 * Adaptor class to pack a <code>Component</code>
 *
 * @version 	16 Jan 2002
 * @author 	Nozomi `James' Ytow
 */
public class PackAdaptor
{
    /**
     * Packs a <code>Component</code> implementing this interface
     */
    public static void pack(Component component)
    {
	Container parent = component.getParent();

	if (parent != null){
	    boolean packable;
	    try{
		packable = parent.isDisplayable();
	    }
	    catch(Throwable e){ //for Java 1.1 or previous
		packable = (null != parent.getPeer());
	    }
	    
	    if(packable){
		parent.addNotify();
		component.addNotify();
	    }
	}

	component.setSize(component.getPreferredSize());

	component.validate();
    }
}
