/*
 * RunnableComponent.java:  a Runnable Component
 * for the Nomencurator, a Nomenclature Heuristic Model.
 *
 * Copyright (c) 2000 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: RunnableComponent.java,v 1.1.1.1 2002/01/16 12:33:33 ryo Exp $
 *	$Log: RunnableComponent.java,v $
 *	Revision 1.1.1.1  2002/01/16 12:33:33  ryo
 *	initial import into CVS
 *	
 *	
 *
 */

package org.nomencurator.awt;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuComponent;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Toolkit;

import java.awt.dnd.DropTarget;

import java.awt.event.ComponentListener;
import java.awt.event.FocusListener;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

import java.awt.im.InputContext;
import java.awt.im.InputMethodRequests;

import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;

import java.beans.PropertyChangeListener;

import java.io.PrintStream;
import java.io.PrintWriter;

import java.util.Locale;

public interface RunnableComponent
    extends  Runnable
{
    public void add(PopupMenu popup);
    public void addComponentListener(ComponentListener l);
    public void addFocusListener(FocusListener l);
    //    public void addInputMethodListener(InputMethodListener l);
    public void addKeyListener(KeyListener l);
    public void addMouseListener(MouseListener l);
    public void addMouseMotionListener(MouseMotionListener l);
    public void addNotify();
    public void addPropertyChangeListener(PropertyChangeListener listener);
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener);
    public Rectangle bounds();
    public int checkImage(Image image, ImageObserver observer);
    public int checkImage(Image image, int width, int height, ImageObserver observer);
    public boolean contains(int x, int y);
    public boolean contains(Point p);
    public Image createImage(ImageProducer producer);
    public Image createImage(int width, int height);
    public void disable();
    public void dispatchEvent(AWTEvent e);
    public void doLayout();
    public void enable();
    public void enable(boolean b);
    //    public void enableInputMethods(boolean enable);
    public float getAlignmentX();
    public float getAlignmentY();
    public Color getBackground();
    public Rectangle getBounds();
    public Rectangle getBounds(Rectangle rv);
    public ColorModel getColorModel();
    public Component getComponentAt(int x, int y);
    public Component getComponentAt(Point p);
    public ComponentOrientation	getComponentOrientation();
    public Cursor getCursor();
    public DropTarget getDropTarget();
    public Font getFont();
    public FontMetrics getFontMetrics(Font font);
    public Color getForeground();
    public Graphics getGraphics();
    public int getHeight();
    public InputContext getInputContext();
    //    public InputMethodRequests getInputMethodRequests();
    public Locale getLocale();
    public Point getLocation();
    public Point getLocation(Point rv);
    public Point getLocationOnScreen();
    public Dimension getMaximumSize();
    public Dimension getMinimumSize();
    public String getName();
    public Container getParent();
    public Dimension getPreferredSize();
    public Dimension getSize();
    public Dimension getSize(Dimension rv);
    public Toolkit getToolkit();
    public Object getTreeLock();
    public int getWidth();
    public int getX();
    public int getY();
    public boolean hasFocus();
    public boolean imageUpdate(Image img, int flags, int x, int y, int w, int h);
    public void invalidate();
    public boolean isDisplayable();
    public boolean isDoubleBuffered();
    public boolean isEnabled();
    public boolean isFocusTraversable();
    public boolean isLightweight();
    public boolean isOpaque();
    public boolean isShowing();
    public boolean isValid();
    public boolean isVisible();
    public void list();
    public void list(PrintStream out);
    public void list(PrintStream out, int indent);
    public void list(PrintWriter out);
    public void list(PrintWriter out, int indent);
    public void paint(Graphics g);
    public void paintAll(Graphics g);
    public boolean prepareImage(Image image, ImageObserver observer);
    public boolean prepareImage(Image image, int width, int height, ImageObserver observer);
    public void print(Graphics g);
    public void printAll(Graphics g);
    public void remove(MenuComponent popup);
    public void removeComponentListener(ComponentListener l);
    public void removeFocusListener(FocusListener l);
    //    public void removeInputMethodListener(InputMethodListener l);
    public void removeKeyListener(KeyListener l);
    public void removeMouseListener(MouseListener l);
    public void removeMouseMotionListener(MouseMotionListener l);
    public void removeNotify();
    public void removePropertyChangeListener(PropertyChangeListener listener);
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener);
    public void repaint();
    public void repaint(int x, int y, int width, int height);
    public void repaint(long tm);
    public void repaint(long tm, int x, int y, int width, int height);
    public void requestFocus();
    public void setBackground(Color c);
    public void setBounds(int x, int y, int width, int height);
    public void setBounds(Rectangle r);
    public void setComponentOrientation(ComponentOrientation o);
    public void setCursor(Cursor cursor);
    public void setDropTarget(DropTarget dt);
    public void setEnabled(boolean b);
    public void setFont(Font f);
    public void setForeground(Color c);
    public void setLocale(Locale l);
    public void setLocation(int x, int y);
    public void setLocation(Point p);
    public void setName(String name);
    public void setSize(Dimension d);
    public void setSize(int width, int height);
    public void setVisible(boolean b);
    public String toString();
    public void transferFocus();
    public void update(Graphics g);
    public void validate();
}


