/*
 * SingleSelectionModel.java:
 *  interface compatible with javax.swing.SingleSelectionModel
 *
 * Copyright (c) 2001 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: SingleSelectionModel.java,v 1.1 2002/01/29 09:48:30 nozomi Exp $
 * $Log: SingleSelectionModel.java,v $
 * Revision 1.1  2002/01/29 09:48:30  nozomi
 * initial import into CVS
 *
 */

package org.nomencurator.awt;

import org.nomencurator.awt.event.ChangeListener;

public interface SingleSelectionModel
{

    final public int UNSELECTED = -1;
    /**
     *
     * Returns selected index
     *
     * @return selected index or -1 if nothing is selected
     *
     * @see setSelectedIndex(int)
     */
    public int getSelectedIndex();


    /**
     *
     * Sets selected index to <code>index</code> and notifies to all
     * listeners if model changed (i.e. <code>index</code> != 
     * current selected index).
     *
     * @param index an int specifying selection index
     *
     * @see getSelectedIndex()
     * @see addChangeListener(ChangeListener)
     */
    public void setSelectedIndex(int index);

         
    /**
     *
     * Clears selection (sets selected index to -1)
     *
     */
    public void clearSelection();


    /**
     *
     * Returns true if an item is selected in the model
     *
     * @return true if an item is selected
     */
    public boolean isSelected();



    /**
     *
     * Adds <code>listener</code> to the list of <code>ChangeListener</code>s
     *
     * @param listener a <code>ChangeLister</code> to be added
     */
    public void addChangeListener(ChangeListener listener);


    /**
     *
     * Removes <code>listener</code> from the list of <code>ChangeListener</code>s
     *
     * @param listener a <code>ChangeLister</code> to be removed
     */
    public void removeChangeListener(ChangeListener listener);
}
