/*
 * SplitPanel.java:  a SplitPanel can be packed
 * for TaxoNote based on Nomencurator data model
 *
 * Copyright (c) 2000, 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: SplitPanel.java,v 1.1 2002/01/29 09:49:30 nozomi Exp $
 * $Log: SplitPanel.java,v $
 * Revision 1.1  2002/01/29 09:49:30  nozomi
 * initial import into CVS
 *
 */

package org.nomencurator.awt;

import java.awt.Insets;
import java.awt.LayoutManager;

import org.nomencurator.awt.Packable;
import org.nomencurator.awt.PackAdaptor;

/**
 * <code>SplitPanel</code> can be packed
 *
 * @see 	jp.kyasu.awt.SplitPanel
 * @see 	org.nomencurator.awt.Packable
 *
 * @version 	19 Jan 2002
 * @author 	Nozomi `James' Ytow
 */
public class SplitPanel
    extends jp.kyasu.awt.SplitPanel
    implements Packable
{
    /**
     * Creates a new split panel with the specified orientation.
     *
     * @param orientation the split orientation.
     */
    public SplitPanel()
    {
	super(VERTICAL);
    }

    /**
     * Creates a new split panel with the specified orientation and gaps.
     *
     * @param orientation the split orientation.
     * @param gap         the gap between components.
     */
    public SplitPanel(int orientation, int gap)
    {
	super(orientation, gap);
    }

    /**
     * Creates a new split panel with the specified orientation and gaps.
     *
     * @param orientation the split orientation.
     * @param gap         the gap between components.
     * @param insets      the insets of the panel.
     */
    public SplitPanel(int orientation, int gap, Insets insets)
    {
	super(orientation, gap, insets);
    }


    /**
     * Packs this
     *
     * @see org.nomencurator.awt.Pack
     * @see org.nomencurator.awt.PackAdaptor
     */
    public void pack()
    {
	PackAdaptor.pack(this);
    }
}
