/*
 *
 * SummaryEditButton.java:  a RunnableButton to evoke a SummaryEditor
 * for the Nomencurator, a Nomenclature Heuristic Model.
 *
 * Copyright (c) 2000 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: SummaryButton.java,v 1.1.1.1 2002/01/16 12:33:33 ryo Exp $
 *	$Log: SummaryButton.java,v $
 *	Revision 1.1.1.1  2002/01/16 12:33:33  ryo
 *	initial import into CVS
 *	
 *	
 *
 */

package org.nomencurator.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import java.util.Hashtable;

import jp.kyasu.awt.Label;

import jp.kyasu.graphics.Text;
import jp.kyasu.graphics.VAbstractButton;
import jp.kyasu.graphics.VButton;
import jp.kyasu.graphics.Visualizable;
import jp.kyasu.graphics.VText;

import org.nomencurator.awt.Button;

import org.nomencurator.awt.SummaryEditor;

public abstract class SummaryButton
    extends Button
{

    protected SummaryEditor summaryEditor;

    /**
     * Constructs a button with empty label.
     */
    public SummaryButton()
    {
	this((SummaryEditor)null);
    }

    public SummaryButton(SummaryEditor summaryEditor)
    {
	super("");
	setSummaryEditor(summaryEditor);
    }

    /**
     * Constructs a button with the specified label.
     * @param label A string label for the button.
     */
    public SummaryButton(String label)
    {
	this(label, null);
    }

    public SummaryButton(String label, SummaryEditor summaryEditor)
    {
	super(label);
	setSummaryEditor(summaryEditor);
    }

    /**
     * Constructs a button with the specified text.
     * @param text A text label for the button.
     */
    public SummaryButton(Text text)
    {
	this(text, null);
    }

    public SummaryButton(Text text, SummaryEditor summaryEditor)
    {
	super(text);
	setSummaryEditor(summaryEditor);
    }

    /**
     * Constructs a button with the specified visual object.
     * @param visualizable A visual label for the button.
     */
    public SummaryButton(Visualizable visualizable)
    {
	this(visualizable, null);
    }

    public SummaryButton(Visualizable visualizable, SummaryEditor summaryEditor)
    {
	super(visualizable);
	setSummaryEditor(summaryEditor);
    }

    /**
     * Constructs a button with the specified visual button.
     * @param button A visual button for the button.
     */
    public SummaryButton(VAbstractButton button)
    {
	this(button, null);
    }

    public SummaryButton(VAbstractButton button, SummaryEditor summaryEditor)
    {
	super(button);
	setSummaryEditor(summaryEditor);
    }

    public void setSummaryEditor(SummaryEditor summaryEditor)
    {
	this.summaryEditor = summaryEditor;
    }

    public SummaryEditor getSummaryEditor()
    {
	return summaryEditor;
    }

}
