/*
 *
 * TableList.java:  a jp.kyasu.awt.TableList wrapper
 * for the Nomencurator, a Nomenclature Heuristic Model.
 *
 * Copyright (c) 2000 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: TableList.java,v 1.1.1.1 2002/01/16 12:33:33 ryo Exp $
 *	$Log: TableList.java,v $
 *	Revision 1.1.1.1  2002/01/16 12:33:33  ryo
 *	initial import into CVS
 *	
 *	
 *
 */

package org.nomencurator.awt;

import jp.kyasu.awt.Button;
import jp.kyasu.awt.TextListModel;

import jp.kyasu.graphics.RichTextStyle;
import jp.kyasu.graphics.Text;

public class TableList extends jp.kyasu.awt.TableList {
     
    public TableList(int raws, String[] titles)
    {
	super(raws, titles);
    }

    public TableList(int raws, String[] titles, int[] widths)
    {
	super(raws, titles, widths);
    } 
    public TableList(int raws, String[] titles , int[] alignments, 
		     int[] widths, RichTextStyle richTextStyle)
    {
	super(raws, titles, alignments, widths, richTextStyle);
    }

    public TableList(int raws, String[] titles, int[] widths, RichTextStyle richTextStyle)
    {
	super(raws, titles, widths, richTextStyle);
    }

    public TableList(String[] titles)
    {
	super(titles);
    } 

    public TableList(TextListModel textListModel, int raws, Button[] buttons)
    {
	super(textListModel, raws, buttons);
    } 

    public TableList(TextListModel textListModel, int raws, String[] titles)
    {
	super(textListModel, raws, titles);
    }

    public TableList(TextListModel textListModel, int raws, String[] titles, int[] alignments)
    {
	super(textListModel, raws, titles, alignments);
    }

    public void add(String[] contents) 
    {
	addItem(contents);
    }

    public void add(String[] contents, int index) 
    {
	addItem(contents, index);
    }

    public void add(Text[] contens) 
    {
	addItem(contens);
    }

    public void add(Text[] contens, int index)
    {
	addItem(contens, index);
    }
}
