/*
 * TextAreadInterface.java
 *
 * Copyright (c) 1997, 1998 Kazuki YASUMATSU.  All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee or royalty is hereby
 * granted, provided that both the above copyright notice and this
 * permission notice appear in all copies of the software and
 * documentation or portions thereof, including modifications, that you
 * make.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED. BY WAY OF EXAMPLE,
 * BUT NOT LIMITATION, COPYRIGHT HOLDERS MAKE NO REPRESENTATIONS OR
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR
 * THAT THE USE OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY
 * THIRD PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.
 * COPYRIGHT HOLDERS WILL BEAR NO LIABILITY FOR ANY USE OF THIS SOFTWARE
 * OR DOCUMENTATION.
 */

package org.nomencurator.awt;

import java.awt.Dimension;

import org.nomencurator.awt.TextComponentInterface;

public interface TextAreaInterface
    extends TextComponentInterface
{
    // ======== java.awt.TextArea APIs ========

    /**
     * Inserts the specified string at the specified position in this
     * text component.
     * @param str the string to insert.
     * @param pos the position at which to insert.
     * @see #setText(java.lang.String)
     * @see #replaceRange(java.lang.String, int, int)
     * @see #append(java.lang.String)
     */
    public void insert(String str, int pos);

    /**
     * @deprecated As of JDK version 1.1,
     * replaced by <code>insert(String, int)</code>.
     */
    public void insertText(String str, int pos);

    /**
     * Appends the given string to the text component's current text.
     * @param str the text to append.
     * @see #insert(java.lang.String, int)
     */
    public void append(String str);

    /**
     * @deprecated As of JDK version 1.1,
     * replaced by <code>append(String)</code>.
     */
    public void appendText(String str);

    /**
     * Replaces text between the indicated start and end positions
     * with the specified replacement text.
     * @param str   the string to use as the replacement.
     * @param start the start position.
     * @param end   the end position.
     * @see #insert(java.lang.String, int)
     */
    public void replaceRange(String str, int start, int end);

    /**
     * @deprecated As of JDK version 1.1,
     * replaced by <code>replaceRange(String, int, int)</code>.
     */
    public void replaceText(String str, int start, int end);

    /**
     * Returns the number of rows in the text component.
     * @return the number of rows in the text component.
     * @see #setRows(int)
     * @see #getColumns()
     */
    public int getRows();

    /**
     * Sets the number of rows for this text component.
     * @param rows the number of rows.
     * @see #getRows()
     * @see #setColumns(int)
     */
    public void setRows(int rows);

    /**
     * Returns the number of columns in this text component.
     * @return the number of columns in the text component.
     * @see #setColumns(int)
     * @see #getRows()
     */
    public int getColumns();

    /**
     * Sets the number of columns for this text component.
     * @param columns the number of columns.
     * @see #getColumns()
     * @see #setRows(int)
     */
    public void setColumns(int columns);

    /**
     * Returns an enumerated value that indicates which scroll bars
     * the text component uses.
     * <p>
     * @return an integer that indicates which scroll bars are used.
     * @see #SCROLLBARS_BOTH
     * @see #SCROLLBARS_VERTICAL_ONLY
     * @see #SCROLLBARS_HORIZONTAL_ONLY
     * @see #SCROLLBARS_NONE
     */
    public int getScrollbarVisibility();

    /**
     * Determines the preferred size of a text component with the specified
     * number of rows and columns.
     * @param rows    the number of rows.
     * @param columns the number of columns.
     * @return the preferred dimensions required to display the text component
     *         with the specified number of rows and columns.
     */
    public Dimension getPreferredSize(int rows, int columns);

    /**
     * @deprecated As of JDK version 1.1,
     * replaced by <code>getPreferredSize(int, int)</code>.
     */
    public Dimension preferredSize(int rows, int columns);

    /**
     * Returns the preferred size of this text component.
     * @return the preferred dimensions needed for this text component.
     */
   public Dimension getPreferredSize();

    /**
     * Returns the minimum size of a text component with the specified
     * number of rows and columns.
     * @param rows    the number of rows.
     * @param columns the number of columns.
     * @return the minimum dimensions required to display the text component
     *         with the specified number of rows and columns.
     */
    public Dimension getMinimumSize(int rows, int columns);

    /**
     * @deprecated As of JDK version 1.1,
     * replaced by <code>getMinimumSize(int, int)</code>.
     */
    public Dimension minimumSize(int rows, int columns);

    /**
     * Returns the minimum size of this text component.
     * @return the preferred dimensions needed for this text component.
     */
    public Dimension getMinimumSize();

}
