/*
 *
 * TextComponent.java:  a jp.kyasu.awt.TextComponent wrapper
 * for the Nomencurator, a Nomenclature Heuristic Model.
 * Constructors were copied from jp.kyasu.awt.TextComponent
 * by Kazuki YASUMATSU.
 *
 * Copyright (c) 2000 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: TextComponent.java,v 1.1.1.1 2002/01/16 12:33:33 ryo Exp $
 *	$Log: TextComponent.java,v $
 *	Revision 1.1.1.1  2002/01/16 12:33:33  ryo
 *	initial import into CVS
 *	
 *	
 *
 */
/*
 * TextComponent.java
 *
 * Copyright (c) 1997, 1998 Kazuki YASUMATSU.  All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee or royalty is hereby
 * granted, provided that both the above copyright notice and this
 * permission notice appear in all copies of the software and
 * documentation or portions thereof, including modifications, that you
 * make.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED. BY WAY OF EXAMPLE,
 * BUT NOT LIMITATION, COPYRIGHT HOLDERS MAKE NO REPRESENTATIONS OR
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR
 * THAT THE USE OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY
 * THIRD PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.
 * COPYRIGHT HOLDERS WILL BEAR NO LIABILITY FOR ANY USE OF THIS SOFTWARE
 * OR DOCUMENTATION.
 */

package org.nomencurator.awt;

import jp.kyasu.awt.DefaultTextEditModel;
import jp.kyasu.awt.TextEditModel;

import jp.kyasu.graphics.RichText;
import jp.kyasu.graphics.RichTextStyle;
import jp.kyasu.graphics.Text;
import jp.kyasu.graphics.V3DBorder;
import jp.kyasu.graphics.VBorder;

/**
 * The <code>TextComponent</code> is a wrappter of the <code>TextComponent</code> of KFC.
 * <p>
 * Adding to interfaces of <code>jp.kyasu.awt.TextComponent</code>, it provides the following
 * methods:
 * <ul>
 * <li><code>String getTeX()</code> to get TeX expression of a text.
 * <li><code>void setTeX(String)</code> to covnert given TeX expression to a <code>Text</code>.
 * <li><code>String getXML()</code> to get XML expression of a text.
 * <li><code>void setXML(String)</code> to convert given XML expression to a <code>Text</code>.
 * <li><code>String getHTML()</code> to get HTML expression of a text.
 * <li><code>void setHTML(String)</code> to convert given HTML expression to a <code>Text</code>.
 * </ul>
 * <p>
 *
 * @see 	jp.kyasu.awt.TextComponent
 *
 * @version 	
 * @author 	Nozomi `James' Ytow
 */
public class TextComponent extends jp.kyasu.awt.TextComponent
{
    /**
     * Constructs a new text component with the specified string.
     * @param string the initial string that the component presents.
     */
    public TextComponent(String string) {
	this(string, SCROLLBARS_VERTICAL_ONLY);
    }

    /**
     * Constructs a new text component with the specified string and scroll
     * bar visibility.
     * @param string     the initial string that the component presents.
     * @param scrollbars a constant that determines what scrollbars are
     *                   created to view the text component.
     */
    public TextComponent(String string, int scrollbars) {
	this(string, scrollbars,
	     ((scrollbars == SCROLLBARS_BOTH ||
	       scrollbars == SCROLLBARS_HORIZONTAL_ONLY) ?
		DEFAULT_HORIZONTAL_STYLE : DEFAULT_VERTICAL_STYLE));
    }

    /**
     * Constructs a new text component with the specified string, scroll bar
     * visibility, and rich text style.
     * @param string     the initial string that the component presents.
     * @param scrollbars a constant that determines what scrollbars are
     *                   created to view the text component.
     * @param rtStyle    the rich text style.
     */
    public TextComponent(String string, int scrollbars, RichTextStyle rtStyle) {
	this(new RichText(new Text((string == null ?
					"" : Text.getJavaString(string)),
			 	   rtStyle.getTextStyle()),
			 rtStyle),
	     scrollbars);
    }

    /**
     * Constructs a new text component with the specified rich text.
     * @param richText the initial rich text that the component presents.
     */
    public TextComponent(RichText richText) {
	this(richText, SCROLLBARS_VERTICAL_ONLY);
    }

    /**
     * Constructs a new text component with the specified rich text and
     * scroll bar visibility.
     * @param richText   the initial rich text that the component presents.
     * @param scrollbars a constant that determines what scrollbars are
     *                   created to view the text component.
     */
    public TextComponent(RichText richText, int scrollbars) {
	this(new DefaultTextEditModel(richText), scrollbars);
    }

    /**
     * Constructs a new text component with the specified model.
     * @param textEditModel the initial model of the MVC component.
     */
    public TextComponent(TextEditModel textEditModel) {
	this(textEditModel, SCROLLBARS_VERTICAL_ONLY);
    }

    /**
     * Constructs a new text component with the specified model and scroll
     * bar visibility.
     * @param textEditModel the initial model of the MVC component.
     * @param scrollbars    a constant that determines what scrollbars are
     *                      created to view the text component.
     */
    public TextComponent(TextEditModel textEditModel, int scrollbars) {
	this(textEditModel, scrollbars, new V3DBorder(false));
    }

    /**
     * Constructs a new text component with the specified model, scroll bar
     * visibility, and border visual.
     * @param textEditModel the initial model of the MVC component.
     * @param scrollbars    a constant that determines what scrollbars are
     *                      created to view the text component.
     * @param border        the border visual of the text component.
     */
    public TextComponent(TextEditModel textEditModel, int scrollbars,
			 VBorder border)
    {
	super(textEditModel, scrollbars, border);
    }

    /**
     * Constructs a text component.
     */
    protected TextComponent()
    {
	super();
    }

    String getTeX()
    {
	return "";
    }

    void setTex(String tex)
    {
    }

    String getXML()
    {
	return "";
    }

    void setXML(String xml)
    {
    }

    String getHTML()
    {
	return getXML();
    }

    void setHTML(String html)
    {
	setXML(html);
    }
}
