/*
 * TextComponentInterface.java:  interface of jawa.awt.TextComponent 
 * for the Nomencurator, a Nomenclature Heuristic Model.
 *
 * Copyright (c) 2000 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: TextComponentInterface.java,v 1.1.1.1 2002/01/16 12:33:33 ryo Exp $
 *	$Log: TextComponentInterface.java,v $
 *	Revision 1.1.1.1  2002/01/16 12:33:33  ryo
 *	initial import into CVS
 *	
 *	
 *
 */

package org.nomencurator.awt;

import java.awt.event.TextListener;

public interface TextComponentInterface
{
    // ======== java.awt.TextComponent APIs ========

    /**
     * Adds the specified text event listener to recieve text events from
     * this text component.
     * @param l the text event listener.
     */
    public void addTextListener(TextListener l);

    /**
     * Removes the specified text event listener so that it no longer
     * receives text events from this textcomponent
     * @param l the text event listener.
     */
    public void removeTextListener(TextListener l);

    /**
     * Sets the string that is presented by this text component to be the
     * specified string.
     * @param str the new string.
     * @see #getText()
     */
    public void setText(String str);

    /**
     * Returns the string that is presented by this text component.
     * @see #setText(java.lang.String)
     * @see #getText(java.lang.String)
     */
    public String getText();



    /**
     * Returns the selected string from the string that is presented by
     * this text component.
     * @return the selected string of this text component.
     * @see #select(int, int)
     */
    public String getSelectedText();

    /**
     * Indicates whether or not this text component is editable.
     * @return <code>true</code> if this text component is editable;
     *         <code>false</code> otherwise.
     * @see #setEditable(boolean)
     */
    public boolean isEditable();

    /**
     * Sets the flag that determines whether or not this text component is
     * editable.
     * @param b a flag indicating whether this text component should be user
     *          editable.
     * @see #isEditable()
     * @see #setEditable(boolean, boolean)
     */
    public void setEditable(boolean b);

    /**
     * Returns the start position of the selected text in this text component.
     * @return the start position of the selected text.
     * @see #setSelectionStart(int)
     * @see #getSelectionEnd()
     */
    public int getSelectionStart();

    /**
     * Sets the selection start for this text component to the specified
     * position.
     * @param selectionStart the start position of the selected text.
     * @see #getSelectionStart()
     * @see #setSelectionEnd(int)
     */
    public void setSelectionStart(int selectionStart);

    /**
     * Returns the end position of the selected text in this text component.
     * @return the end position of the selected text.
     * @see #setSelectionEnd(int)
     * @see #getSelectionStart()
     */
    public int getSelectionEnd();

    /**
     * Sets the selection end for this text component to the specified position.
     * @param selectionEnd the end position of the selected text.
     * @see #getSelectionEnd()
     * @see #setSelectionStart(int)
     */
    public void setSelectionEnd(int selectionEnd);

    /**
     * Selects the text between the specified start and end positions.
     * @param selectionStart the start position of the text to select.
     * @param selectionEnd the end position of the text to select.
     * @see #setSelectionStart(int)
     * @see #setSelectionEnd(int)
     * @see #selectAll()
     */
    public void select(int selectionStart, int selectionEnd);

    /**
     * Selects all the text in this text component.
     * @see #select(int, int)
     */
    public void selectAll();

    /**
     * Sets the position of the text insertion caret for this text component.
     * @param position the position of the text insertion caret.
     * @see #getCaretPosition()
     */
    public void setCaretPosition(int position);

    /**
     * Returns the position of the text insertion caret for this text component.
     * @return the position of the text insertion caret.
     * @see #setCaretPosition(int)
     */
    public int getCaretPosition();

    /**
     * Tests if the selection is caret, i.e., null selection.
     */
    public boolean selectionIsCaret();

}
