/*
 * TextFieldInterface.java
 *
 * Copyright (c) 1997, 1998 Kazuki YASUMATSU.  All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee or royalty is hereby
 * granted, provided that both the above copyright notice and this
 * permission notice appear in all copies of the software and
 * documentation or portions thereof, including modifications, that you
 * make.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED. BY WAY OF EXAMPLE,
 * BUT NOT LIMITATION, COPYRIGHT HOLDERS MAKE NO REPRESENTATIONS OR
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR
 * THAT THE USE OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY
 * THIRD PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.
 * COPYRIGHT HOLDERS WILL BEAR NO LIABILITY FOR ANY USE OF THIS SOFTWARE
 * OR DOCUMENTATION.
 */

package org.nomencurator.awt;

import java.awt.Dimension;

import org.nomencurator.awt.TextComponentInterface;

public interface TextFieldInterface 
    extends TextComponentInterface {

    // ======== java.awt.TextField APIs ========

    /**
     * Returns the character that is to be used for echoing.
     * @return the echo character for this text field.
     * @see #setEchoChar(char)
     * @see #echoCharIsSet()
     */
    public char getEchoChar();

    /**
     * Sets the echo character for this text field.
     * @param c the echo character for this text field.
     * @see #getEchoChar()
     * @see #echoCharIsSet()
     */
    public void setEchoChar(char c);

    /**
     * @deprecated As of JDK version 1.1,
     * replaced by <code>setEchoChar(char)</code>.
     */
    public void setEchoCharacter(char c);

    /**
     * Indicates whether or not this text field has a character set
     * for echoing.
     * @return <code>true</code> if this text field has a character set
     *         for echoing; <code>false</code> otherwise.
     * @see #getEchoChar()
     * @see #setEchoChar(char)
     */
    public boolean echoCharIsSet();

    /**
     * Returns the preferred size of this text field with the specified
     * number of columns.
     * @param columns the number of columns.
     * @return the preferred dimensions for displaying this text field.
     */
    public Dimension getPreferredSize(int columns);

    /**
     * @deprecated As of JDK version 1.1,
     * replaced by <code>getPreferredSize(int)</code>.
     */
    public Dimension preferredSize(int columns);

    /**
     * Returns the preferred size of this text field.
     * @return the preferred dimensions for displaying this text field.
     */
    public Dimension getPreferredSize();

    /**
     * Returns the minumum dimensions for a text field with the specified
     * number of columns.
     * @param columns the number of columns in this text field.
     */
    public Dimension getMinimumSize(int columns);

    /**
     * @deprecated As of JDK version 1.1,
     * replaced by <code>getMinimumSize(int)</code>.
     */
    public Dimension minimumSize(int columns);

    /**
     * Returns the minumum dimensions for this text field.
     * @return the minimum dimensions for displaying this text field.
     */
    public Dimension getMinimumSize();

    /**
     * Returns the number of columns in this text component.
     * @return the number of columns in the text component.
     * @see #setColumns(int)
     * @see #getRows()
     */
    public int getColumns();

    /**
     * Sets the number of columns for this text component.
     * @param columns the number of columns.
     * @see #getColumns()
     * @see #setRows(int)
     */
    public void setColumns(int columns);

}
