/**
 * NameUsageTreeNode.java
 *
 * @version 0.00, 2002/01/09
 * @author	Hcc-Network Hiroyuki Ohkawa
 * $Id: NameRecordTreeNode.java,v 1.1.1.1 2002/01/16 12:33:34 ryo Exp $
 * $Log: NameRecordTreeNode.java,v $
 * Revision 1.1.1.1  2002/01/16 12:33:34  ryo
 * initial import into CVS
 *
 */

package org.nomencurator.awt.model;

import java.util.Vector;

public class NameUsageTreeNode
{
    private String objectId = "";
    private String name = "";
    private String higher = "";
    private Vector /* String */ lower = new Vector();

	/**
	 * Constractor
	 */
    public NameUsageTreeNode() {
        super();
    }

	/**
	 * Constractor
	 * @param String object id
	 * @param String name
	 * @param String higher
	 * @param Vector<String> lower
	 */
    public NameUsageTreeNode(String objectId, String name, String higher, Vector lower) {
        this.objectId = objectId;
        this.name = name;
        this.higher = higher;
        this.lower = lower;
    }

	/**
	 * @return String object id
	 */
	public String getObjectId() {
	    return objectId;
    }

	/**
	 * @return String name
	 */
	public String getName() {
	    return name;
    }

	/**
	 * @return NameUsageTreeNode higher
	 */
	public String getHigher() {
	    return higher;
    }

	/**
	 * @return Vector<String> lower
	 */
	public Vector getLower() {
	    return lower;
    }

   	/**
	 * @param String object id
	 */
	public void setObjectId(String objectId) {
	    this.objectId = objectId;
    }

   	/**
	 * @param String object id
	 */
	public void setName(String name) {
	    this.name = name;
    }

   	/**
	 * @param String higher
	 */
	public void setHigher(String higher) {
	    this.higher = higher;
    }

   	/**
	 * @param Vector<String> lower
	 */
	public void setLower(Vector lower) {
	    this.lower = lower;
    }

   	/**
	 * @param String lower to add
	 */
	public void addLower(String lower) {
	    this.lower.addElement(lower);
    }

}
