/*
 * TreeController.java:  a TreeController for Tree user interface
 *
 * Copyright (c) 2001 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: TreeController.java,v 1.3 2002/03/10 06:55:53 nozomi Exp $
 * $Log: TreeController.java,v $
 * Revision 1.3  2002/03/10 06:55:53  nozomi
 * modify log format
 *
 * Revision 1.2  2002/03/08 23:08:40  nozomi
 * minor fix in comments
 *
 * Revision 1.1.1.1  2002/01/16 12:33:33  ryo
 * initial import into CVS
 */

package org.nomencurator.awt.tree;

import jp.kyasu.awt.text.TextListController;

import jp.kyasu.graphics.RichTextStyle;

import org.nomencurator.awt.tree.DefaultMutableTreeNode;
import org.nomencurator.awt.tree.TreeNode;

import org.nomencurator.awt.tree.event.TreeExpansionListener;
import org.nomencurator.awt.tree.event.TreeWillExpandListener;

import org.nomencurator.util.tree.DefaultTreeModel;
import org.nomencurator.util.tree.MutableTreeNode;
import org.nomencurator.util.tree.TreePath;

import org.nomencurator.util.tree.event.TreeModelEvent;
import org.nomencurator.util.tree.event.TreeModelListener;

/**
 * Since a tree can be represented by a indented list graphically,
 * a TreeMController can be implemented as a subclass of Listclontroller which
 * can be used as a controller in Tree widget class extending List class
 * of KFC.
 *
 * @version 	10 Mar 2002
 * @author 	Nozomi `James' Ytow
 */

public class TreeController
    extends TextListController
    implements TreeModelListener
{
    //Default status of inserted node, extended or shrinked
    protected boolean isExtendedAsDefault;

    //Constructors
    public TreeController(TreeView treeView)
    {
	super(treeView);
	isExtendedAsDefault = true;
    }

    /**
     */
    public void setExtendedDefault(boolean extendedAsDefault)
    {
	isExtendedAsDefault = extendedAsDefault;
    }

    /**
     */
    public boolean isExtendedAsDefault()
    {
	return isExtendedAsDefault;
    }

    /**
     * Ivoked when a node or a set of siblings was modified.
     * Neither location of the node in the tree nor array of its child nodes 
     * was not modified but other attributes were changed which may arrect
     * tree's representation.  For eample when file name was changed but 
     * its position in file system tree was not altered.
     * <p>
     * Value of childIndices and children will be null to tell change of root.
     * <p>
     * Use <code>TreeModelEvent#getPath()</code> to obtain parent node of
     * the modified node.  <code>TreeModelEvent#getChildIndices()</code> retruns
     * indices of modifies child nodes.
     */
    public void treeNodesChanged(TreeModelEvent event)
    {
    }

    /**
     * Ivoked after insertion of a node.
     * <p>
     * Use <code>TreeModelEvent#getPath()</code> to obtain parent node of
     * the modified node.  <code>TreeModelEvent#getChildIndices()</code> retruns
     * indices of modifies child nodes in ascending order.
    */

    public void treeNodesInserted(TreeModelEvent event)
    {
    }

    /**
     * Ivoked after removal of a node from a tree.
     * When a sbutree removed a tree, this method is ivoked only once for
     * the root node of the removed subtree but never each sibling nodes removed.
     * <p>
     * Use <code>TreeModelEvent#getPath()</code> to obtain parent node of
     * the modified node.  <code>TreeModelEvent#getChildIndices()</code> retruns
     * indices of modifies child nodes in ascending order.
    */
    public void treeNodesRemoved(TreeModelEvent event)
    {
    }

    /**
     * Ivoked when tree structure under a node modified drastically.
     * When the path length given by <code>TreeModelEvent#getPath()</code> is one
     * and the first element is not the current root node, the first element is 
     * the root of the new tree.
     * <p>
     * Use <code>TreeModelEvent#getPath()</code> to obtain parent node of
     * the modified node.  <code>TreeModelEvent#getChildIndices()</code> retruns
     * null.
     */
    public void treeStructureChanged(TreeModelEvent event)
    {
    }

    //Methods to support JTree
    /**
     *
     * Returns true if the tree is under editing.
     * Item under edition can be obtaind using  getSelectionPath.
     *
     * @return true if user is editing nodes
     *
     * @see getSelectionPath();
    */
    public boolean isEditing()
    {
	return false;
    }

    /**
     *
     * Terminates currend editin session.
     * DefaultTreeCellEditor object conservs all edtion on going on cells, which may
     * differ in other implementation.
     * It does nothing if the tree is not under edition.
     * <P>
     * Note:<BR>
     * Use <code>setInvokesStopCellEditing(boolean)</code> to save edition automatically 
     * when a user moved in the tree
     *
     * @return true if edition is on going and currently stopped, or false if
     * tree is not under edition
     */
    public boolean stopEditing()
    {
	return false;
    }


    /**
     *
     * Cancels current edit session.
     * It does nothing if tree is not under edition
     */
    public void cancelEditing()
    {
	;
    }


    /**
     *
     * Selects and starts edition of a node identified by <code>path</code>.
     * It fails if <code>CellEditor</code> does not allow edtion of specified
     * item.
     *
     * @param path a <code>TreePath</code> identifying a node
     */
    public void startEditingAtPath(TreePath path)
    {
	;
    }


    /**
     *
     * Returns path of the node under edition
     *
     * @return <code>TreePath</code> of the node under edition
     */
    public TreePath getEditingPath()
    {
	return null;
    }

    public void addTreeExpansionListener(TreeExpansionListener listener)
    {
	;
    }

    /**
     * 
     * Removes a <code>TreeExpansion</code> event listener
     *
     * @param listener a <code>TreeExpansionListener</code> to be removed
     */
    public void removeTreeExpansionListener(TreeExpansionListener listener)
    {
	;
    }

    /**
     *
     * Adds a <code>TreeWillExpand</code> event listener
     *
     * @param listener a <code>TreeWillExpand</code> which is to be notified
     * when a tree node is expanded or shrunken (negative expansion)
     */
    public void addTreeWillExpandListener(TreeWillExpandListener listener)
    {
	;
    }

    /**
     *
     * Removes a <code>TreeWillExpand</code> event listener
     *
     * @param listener a <code>TreeWillExpand</code> to be removed
     */
    public void removeTreeWillExpandListener(TreeWillExpandListener listener)
    {
	;
    }
}
