/*
 * TreeMouseAdaptor.java: A MouseAdaptor for Tree
 *
 * Copyright (c) 2001, 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee or royalty is hereby
 * granted, provided that both the above copyright notice and this
 * permission notice appear in all copies of the software and
 * documentation or portions thereof, including modifications, that you
 * make.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED. BY WAY OF EXAMPLE,
 * BUT NOT LIMITATION, COPYRIGHT HOLDERS MAKE NO REPRESENTATIONS OR
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR
 * THAT THE USE OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY
 * THIRD PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.
 * COPYRIGHT HOLDERS WILL BEAR NO LIABILITY FOR ANY USE OF THIS SOFTWARE
 * OR DOCUMENTATION.
 */
/*
 * $Id: TreeMouseAdaptor.java,v 1.1 2002/08/15 00:49:57 nozomi Exp $
 * $Log: TreeMouseAdaptor.java,v $
 * Revision 1.1  2002/08/15 00:49:57  nozomi
 * initial import to CVS repository
 *
 */

package org.nomencurator.awt.tree;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import org.nomencurator.awt.Tree;

import org.nomencurator.util.tree.TreePath;

/*
 * <CODE>TreeMouseAdaptor</CODE> is a <CODE>MouseAdaptor</CODE>
 * to manage expandng/shrinking of a <CODE>TreeNode</CODE>
 *
 * @version 	15 Aug 2002
 * @author 	Nozomi `James' Ytow
 */
public class TreeMouseAdaptor
    extends MouseAdapter
{
    /** <CODE>Tree</CODE> to be listen by this <CODE>Object</CODE>. */
    protected Tree tree;

    /** <CODE>TreeView</CODE> to be listen by this <CODE>Object</CODE>. */
    protected TreeView treeView;

    /**
     * Construct a <CODE>TreeMouseAdaptor</CODE> Object
     * Listening <CODE>tree</CODE>.
     *
     * @param tree <CODE>Tree</CODE> to be listen by this <CODE>Object</CODE>
     */
    public TreeMouseAdaptor(Tree tree)
    {
	super();
	setTree(tree);
    }

    /**
     * Construct a <CODE>TreeMouseAdaptor</CODE> Object
     * Listening <CODE>treeView</CODE>.
     *
     * @param treeView <CODE>TreeView</CODE> to be listen by this <CODE>Object</CODE>
     */
    public TreeMouseAdaptor(TreeView treeView)
    {
	super();
	setTreeView(treeView);
    }

    /**
     * Listens <CODE>treeView</CODE>.
     *
     * @param treeView <CODE>TreeView</CODE> to be listen by this <CODE>Object</CODE>
     */
    public synchronized void setTreeView(TreeView treeView)
    {
	if(treeView == this.treeView)
	    return;

	if(this.treeView != null)
	    this.treeView.removeMouseListener(this);

	this.treeView = treeView;

	if(this.treeView != null) {
	    if(tree != null) {
		tree.removeMouseListener(this);
		tree = null;
	    }
	    this.treeView.addMouseListener(this);
	}
    }

    /**
     * Listens <CODE>tree</CODE>.
     *
     * @param tree <CODE>TreeView</CODE> to be listen by this <CODE>Object</CODE>
     */
    public synchronized void setTree(Tree tree)
    {
	if(tree == this.tree)
	    return;

	if(this.tree != null)
	    this.tree.removeMouseListener(this);

	this.tree = tree;

	if(this.tree != null) {
	    if(treeView != null) {
		treeView.removeMouseListener(this);
		treeView = null;
	    }
	    this.tree.addMouseListener(this);
	}
    }

    /**
     * Invoked when mouse clicked
     *
     * @param event <CODE>MouseEvent</CODE> to be handled
     */
    public void mouseClicked(MouseEvent event)
    {
	if(event.getClickCount() != 2)
	    return;

	if(tree != null)
	    treeView = tree.getTreeView();

	TreePath path = 
	    treeView.getClosestPathForLocation(event.getX(), event.getY());
	if(path != null)
	    treeView.getTextTreeModel().doubleCliked(path);
	event.consume();

	if(tree != null)
	    treeView = null;
    } 

}
