/*
 *
 * TreeNode.java:  TreeNode to replace javax.swing.tree.TreeNode
 *
 * Copyright (c) 2001 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: TreeNode.java,v 1.2 2002/06/06 19:21:38 nozomi Exp $
 * $Log: TreeNode.java,v $
 * Revision 1.2  2002/06/06 19:21:38  nozomi
 * change method names from extension to expansion
 *
 * Revision 1.1.1.1  2002/01/16 12:33:33  ryo
 * initial import into CVS
 */

package org.nomencurator.awt.tree;

import org.nomencurator.util.tree.MutableTreeNode;

/**
 * <code>MutalbeTreeNode<code> interface
 * supporting expand/collapse state
 *
 * @version	06 June 2002
 * @author 	Nozomi `James' Ytow
 */
public interface TreeNode
    extends MutableTreeNode
//I'm not sure to extend MutableTreeNode or org.nomencurator.util.tree.TreeNode
{
    /**
     * Sets extended status to <code>show</code>.  If status is same to <code>show</code>
     * it does nothing, else it may call non-trivial functions specific to the 
     * implementation.
     *
     * @param show status to be set
     */
    public void setExpanded(boolean show);

    /**
     * Returns current extended status.
     *
     * @return current extended status in boolean
     */
    public boolean isExpanded(); 
    
}
