/*
 *
 * TreeExpansionEvent.java:  Selection event for Tree
 *
 * Copyright (c) 2001 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: TreeExpansionEvent.java,v 1.1.1.1 2002/01/16 12:33:34 ryo Exp $
 *	$Log: TreeExpansionEvent.java,v $
 *	Revision 1.1.1.1  2002/01/16 12:33:34  ryo
 *	initial import into CVS
 *	
 *	
 *
 */

package org.nomencurator.awt.tree.event;

import java.util.EventObject;

import org.nomencurator.util.tree.TreePath;

public class TreeExpansionEvent
    extends EventObject
{
    /**
     * <code>TreePath</code> to value which this event represents
     */

    protected TreePath path;


    //Construcotr
    /**
     *
     * Constructs a <code>TreeExpansionEvent</code> object
     *
     * @param source source of this event (typically <code>this</code>)
     * @param path <code>TreePath</code> object identifying newly expanded
     * node
     */
    public TreeExpansionEvent(Object source,
			      TreePath path)
    {
	super(source);
	this.path = path;
    }

    /**
     *
     * Returns path to the node that has been expanded or shrunken
     */
    public TreePath getPath()
    {
	return path;
    }
}
