/*
 *
 * AWTtools.java:  a tookit containing frequently used methods (FUM?)
 * for the Nomencurator, a Nomenclature Heuristic Model.
 *
 * Copyright (c) 2000 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: AWTtools.java,v 1.1.1.1 2002/01/16 12:33:33 ryo Exp $
 *	$Log: AWTtools.java,v $
 *	Revision 1.1.1.1  2002/01/16 12:33:33  ryo
 *	initial import into CVS
 *	
 *	
 *
 */

package org.nomencurator.awt.util;

import java.applet.Applet;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;

public class AWTtools extends Object
{

    public static Frame getFrame(Component component)
    {
	if(component != null) {
	    while(!(component instanceof Frame) 
		  && component != null) {
		component = component.getParent();
	    }
	}
	return (Frame)component;
    }

    public static Window getWindow(Component component)
    {

	if(component != null) {
	    while(!(component instanceof Window) 
		  && component != null) {
		component = component.getParent();
	    }
	}
	return (Window)component;
    }


    public static Applet getApplet(Component component)
    {
	if(component != null) {
	    while(!(component instanceof Applet) 
		  && component != null) {
		component = component.getParent();
	    }
	}
	return (Applet)component;
    }

    public static Component getDisplayBase(Component component)
    {
	Component displayBase = getApplet(component);
	if(displayBase == null) {
	    displayBase = getFrame(component);
	    
	    if(displayBase == null) {
		displayBase = getWindow(component);
	    }
	}
	return displayBase;
    }


    public static void show(Component component)
    {
	if(component == null)
	    return;
	/*
	Applet applet = getApplet(component);
	if(applet != null) {
	    applet.show();
	    return;
	}

	Frame frame = getFrame(component);
	if(frame != null) {
	    frame.show();
	    return;
	}

	Window window = getWindow(component);
	if(window != null) {
	    window.show();
	    return;
	}
	*/
	Component displayBase = getDisplayBase(component);
	if(displayBase != null)
	    component = displayBase;
	component.show();
    }

}
