/*
 * AbstractConnection.java: 
 *
 * Copyright (c) 2002 Ryo FUJIMOTO
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: AbstractConnection.java,v 1.6 2002/09/19 10:42:27 ryo Exp $
 * $Log: AbstractConnection.java,v $
 * Revision 1.6  2002/09/19 10:42:27  ryo
 * remove unused import line
 *
 * Revision 1.5  2002/08/01 04:20:30  nozomi
 * change comment style
 *
 * Revision 1.4  2002/07/16 07:07:29  ryo
 * move getSummaryTextArray() to ConnectionEditModel class
 *
 * Revision 1.3  2002/07/12 16:53:29  ryo
 * move member and accessor from *Connection to AbstractConnection
 *
 * Revision 1.2  2002/06/26 11:15:20  ryo
 * CRLF conversion
 *
 * Revision 1.1  2002/06/21 11:37:51  ryo
 * initial import into CVS
 *
 */

package org.nomencurator.broker;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import org.nomencurator.NamedObject;

public abstract class AbstractConnection
{
	
    /** connection name */
    protected String name;
    
    /** driver class name to access to the database */
    protected String driverName;
    
    /** URL string used for access to the database or a Nomencurator servlet */
    protected String url;
    
    /** user name used for access to the database */
    protected String username;
    
    /** password used for access to the database */
    protected String password;
    
    /** encoding of the database */
    protected String encoding;

    /** file system path */
    protected String path;

    /** validity of connection */
    protected boolean valid = false;

    /** validity of writing of connection */
    protected boolean writable = false;
	
    /**
     * Get connection name.
     * @return String connection name.
     */
    public String getName() {
	return name;
    }
    
    /**
     * Get connection type.
     * @return String type.
     */
    public abstract String getType();
    
    /**
     * Get driver class name used for access to a database.
     * @return String driver class name.
     */
    public String getDriverName() {
	return driverName;
    }
    
    /**
     * Get URL string used for access to a database or a Nomencurator servlet.
     * @return String URL string.
     */
    public String getUrl() {
	return url;
    }
    
    /**
     * Get user name used for access to a database.
     * @return String user name.
     */
    public String getUsername() {
	return username;
    }
    
    /**
     * Get password used for access to a database.
     * @return String password.
     */
    public String getPassword() {
	return password;
    }
    
    /**
     * Set connection name.
     * @param name connection name.
     */
    public void setName(String name) {
	this.name = name;
    }
    
    /**
     * Set driver class name used for access to a database.
     * @param driverName driver class name.
     */
    public void setDriverName(String driverName) {
	this.driverName = driverName;
    }
    
    /**
     * Set URL string used for access to a database or a Nomencurator servlet.
     * @param url URL string.
     */
    public void setUrl(String url) {
	this.url = url;
    }
    
    /**
     * Set user name used for access to a database.
     * @param username user name.
     */
    public void setUser(String username) {
	this.username = username;
    }
    
    /**
     * Set password used for access to a database.
     * @param password password.
     */
    public void setPassword(String password) {
	this.password = password;
    }
    
    /**
     * Set top directory for local database.
     * @param path the top directory for local database.
     */
    public void setPath(String path) {
	this.path = path;
    }
    
    /**
     * Get top directory for local database.
     * @return String the top directory for local database.
     */
    public String getPath() {
	return path;
    }
    
    /**
     * Set validity of connection.
     * @param b validity of connection
     */
    public void setValid(boolean b) {
	valid = b;
    }
    
    /**
     * Get validity of connection.
     * @return true if the connection is valid, false if not.
     */
    public boolean getValid() {
	return valid;
    }
    
    /**
     * Set validity of writing of connection.
     * @param b validity of writing of connection
     */
    public void setWritable(boolean b) {
	writable = b;
    }
    
    /**
     * Get validity of writing of connection.
     * @return true if the connection is writable, false if not.
     */
    public boolean getWritable() {
	return writable;
    }
    
    /**
     * connect to the database
     */
    public abstract Connection connect();
    
    /**
     * disconnect from the database
     */
    public abstract void disconnect();
    
    /**
     * search NameUsage records
     * @param  String name
     * @param  String author
     * @param  String year
     * @return  Vector<NameUsageListRow>
     */
    public abstract Vector searchNameUsage(String name, String author, String year);
    
    /**
     * get NamedObject for each *EditPanel
     * @param  String oid
     * @param  String target (Name, Appearance, Publication, Author)
     * @return  NamedObject
     */
    public abstract NamedObject getNamedObject(String oid);
    
    /**
     * save a NamedObject
     * @param NamedObject
     * @return int inserted row count
     */
    public int saveNamedObject(NamedObject o) {
	Vector v = new Vector();
	v.add(o);
	return saveNamedObject(v);
    }
    
    /**
     * save NamedObjects
     * @param Vector<NamedObject>
     * @return int inserted row count
     */
    public abstract int saveNamedObject(Vector v);
}
