/*
 * DatabaseMapper.java:  a mapping between Nomencurator structure and
 * backend database strucuture
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id:$
 * $Log:$
 */

package org.nomencurator.broker;

import java.util.Hashtable;

/**
 * An implementation of attribute name mapping between Nomencurator structure 
 * and backend DBMS
 *
 * @version 	31 July 2002
 * @author 	Nozomi `James' Ytow
 */

public class DatabaseMapper
{
    /** mapping between Author object and its expression in DBMS */
    protected Hashtable authorAttributes;
    
    /** mapping between Annotation object and its expression in DBMS */
    protected Hashtable annotationAttributes;
    
    /** mapping between Appearance object and its expression in DBMS */
    protected Hashtable appearanceAttributes;
    
    /** mapping between Name object and its expression in DBMS */
    protected Hashtable nameAttributes;

    /** mapping between NameUsage object and its expression in DBMS */
    protected Hashtable nameUsageAttributes;

    /** mapping between NameUsageNode object and its expression in DBMS */
    protected Hashtable nameUsageNodeAttributes;

    /** mapping between Publication object and its expression in DBMS */
    protected Hashtable publicationUsageAttributes;

    public DatabaseMapper()
    {
	this(new Hashtable(),
	     new Hashtable(),
	     new Hashtable(),
	     new Hashtable(),
	     new Hashtable(),
	     new Hashtable(),
	     new Hashtable());
    }

    public DatabaseMapper(Hashtable author,
			  Hashtable annotation,
			  Hashtable appearance,
			  Hashtable name,
			  Hashtable nameUsage,
			  Hashtable nameUsageNode,
			  Hashtable publication
			  )
    {
	authorAttributes = author;
	annotationAttributes = annotation;
	appearanceAttributes = appearance;
	nameAttributes = name;
	nameUsageAttributes = nameUsage;
	nameUsageNodeAttributes = nameUsageNode;
	publicationUsageAttributes = publication;
    }


    /** mapping between Author object and its expression in DBMS */
    public Hashtable getAuthorAttributes(){return null;}
    
    /** mapping between Annotation object and its expression in DBMS */
    public Hashtable getAnnotationAttributes(){return null;}
    
    /** mapping between Appearance object and its expression in DBMS */
    public Hashtable getAppearanceAttributes(){return null;}
    
    /** mapping between Name object and its expression in DBMS */
    public Hashtable getNameAttributes(){return null;}

    /** mapping between NameUsage object and its expression in DBMS */
    public Hashtable getNameUsageAttributes(){return null;}

    /** mapping between NameUsageNode object and its expression in DBMS */
    public Hashtable getNameUsageNodeAttributes(){return null;}

    /** mapping between Publication object and its expression in DBMS */
    public Hashtable getPublicationUsageAttributes(){return null;}

    /** mapping between Author object and its expression in DBMS */
    public void setAuthorAttributes(Hashtable attributes){;}
    
    /** mapping between Annotation object and its expression in DBMS */
    public void setAnnotationAttributes(Hashtable attributes){;}
    
    /** mapping between Appearance object and its expression in DBMS */
    public void setAppearanceAttributes(Hashtable attributes){;}
    
    /** mapping between Name object and its expression in DBMS */
    public void setNameAttributes(Hashtable attributes){;}

    /** mapping between NameUsage object and its expression in DBMS */
    public void setNameUsageAttributes(Hashtable attributes){;}

    /** mapping between NameUsageNode object and its expression in DBMS */
    public void setNameUsageNodeAttributes(Hashtable attributes){;}

    /** mapping between Publication object and its expression in DBMS */
    public void setPublicationUsageAttributes(Hashtable attributes){;}

    /** mapping between Author object and its expression in DBMS */
    public void clearAuthorAttributes(){;}
    
    /** mapping between Annotation object and its expression in DBMS */
    public void clearAnnotationAttributes(){;}
    
    /** mapping between Appearance object and its expression in DBMS */
    public void clearAppearanceAttributes(){;}
    
    /** mapping between Name object and its expression in DBMS */
    public void clearNameAttributes(){;}

    /** mapping between NameUsage object and its expression in DBMS */
    public void clearNameUsageAttributes(){;}

    /** mapping between NameUsageNode object and its expression in DBMS */
    public void clearNameUsageNodeAttributes(){;}

    /** mapping between Publication object and its expression in DBMS */
    public void clearPublicationUsageAttributes(){;}

    /** mapping between Author object and its expression in DBMS */
    public void putAuthorAttribute(String key, String value){;}
    
    /** mapping between Annotation object and its expression in DBMS */
    public void putAnnotationAttribute(String key, String value){;}
    
    /** mapping between Appearance object and its expression in DBMS */
    public void putAppearanceAttribute(String key, String value){;}
    
    /** mapping between Name object and its expression in DBMS */
    public void putNameAttribute(String key, String value){;}

    /** mapping between NameUsage object and its expression in DBMS */
    public void putNameUsageAttribute(String key, String value){;}

    /** mapping between NameUsageNode object and its expression in DBMS */
    public void putNameUsageNodeAttribute(String key, String value){;}

    /** mapping between Publication object and its expression in DBMS */
    public void putPublicationUsageAttribute(String key, String value){;}

    /** mapping between Author object and its expression in DBMS */
    public String gettAuthorAttribute(String key){return null;}
    
    /** mapping between Annotation object and its expression in DBMS */
    public String getAnnotationAttribute(String key){return null;}
    
    /** mapping between Appearance object and its expression in DBMS */
    public String getAppearanceAttribute(String key){return null;}
    
    /** mapping between Name object and its expression in DBMS */
    public String getNameAttribute(String key){return null;}

    /** mapping between NameUsage object and its expression in DBMS */
    public String getNameUsageAttribute(String key){return null;}

    /** mapping between NameUsageNode object and its expression in DBMS */
    public String getNameUsageNodeAttribute(String key){return null;}

    /** mapping between Publication object and its expression in DBMS */
    public String getPublicationUsageAttribute(String key){return null;}

    
}
