/*
 * HttpConnection.java: 
 *
 * Copyright (c) 2002 Ryo FUJIMOTO
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: HttpConnection.java,v 1.6 2002/07/12 16:53:29 ryo Exp $
 * $Log: HttpConnection.java,v $
 * Revision 1.6  2002/07/12 16:53:29  ryo
 * move member and accessor from *Connection to AbstractConnection
 *
 * Revision 1.5  2002/06/27 13:13:48  ryo
 * enable to transmit two or more NamedObject
 *
 * Revision 1.4  2002/06/26 11:23:41  ryo
 * CRLF conversion, and add some comments
 *
 * Revision 1.3  2002/06/21 15:01:44  ryo
 * implement searchNameUsage() and getNamedObject()
 *
 * Revision 1.2  2002/06/21 13:02:56  ryo
 * add copyright
 *
 */

package org.nomencurator.broker;

import java.sql.Connection;
import java.util.Vector;
import java.util.Enumeration;
import java.net.URLEncoder;
import java.net.URL;
import java.net.URLConnection;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.DataInputStream;

import org.nomencurator.NamedObject;
import org.nomencurator.controller.ParseXml;
import org.nomencurator.server.servlet.ServletCommandController;
import org.nomencurator.localdb.LocalDatabase;

public class HttpConnection extends AbstractConnection {

	/**
	 * XML request header.
	 */
	public static final String XML_REQUEST_HEADER = "<?xml version=\"1.0\"?>\n<request>\n";

	/**
	 * XML request footer.
	 */
	public static final String XML_REQUEST_FOOTER = "</request>\n";

	/**
	 * XML parser.
	 */
	protected ParseXml parse = new ParseXml();
	
	/**
	 * Constractor.
	 */
	public HttpConnection() {
	}
	
	/**
	 * Constractor.
	 */
	public HttpConnection(String url) {
		this.url = url;
	}

	/**
	 * Get connection type.
	 * @return String connection type
	 */
	public String getType() {
		return "HTTP";
	}

	/**
	 * Connect to a Nomencurator servlet.(do nothing)
	 * @return Connection return null.
	 * @see AbstractConnection#connect()
	 */
	public Connection connect() {
		return null;
	}

	/**
	 * Disconnect from a Nomencurator servlet.(do nothing)
	 * @see AbstractConnection#disconnect()
	 */
	public void disconnect() {
	}

	/**
	 * Search NameUsage objects.
	 * @param name name string of NameUsage object.
	 * @param author author string of Author object.
	 * @param year year of Publication object.
	 * @return Vector result record set.
	 * @see AbstractConnection#searchNameUsage(String, String, String)
	 */
	public Vector searchNameUsage(String name, String author, String year) {
		name   = URLEncoder.encode(name);
		author = URLEncoder.encode(author);
		year   = URLEncoder.encode(year);
		StringBuffer buf = new StringBuffer();
		buf.append(url);
		buf.append("?cid=" + ServletCommandController.COMMAND_SEARCH_NAMEUSAGE);
		buf.append("&name=" + name);
		buf.append("&author=" + author);
		buf.append("&year=" + year);
System.out.println(buf.toString());
		Vector result = parse.getNameUsageList(buf.toString());
		return result;
	}

	/**
	 * Get a NamedObject.
	 * @param oid object id of NamedObject.
	 * @return NamedObject NamedObject.
	 * @see AbstractConnection#getNamedObject(String)
	 */
	public NamedObject getNamedObject(String oid) {
		if (oid == null || oid.length() == 0)
			return null;
		oid = URLEncoder.encode(oid);
		StringBuffer buf = new StringBuffer();
		buf.append(url);
		buf.append("?cid=" + ServletCommandController.COMMAND_GET_NAMEDOBJECT);
		buf.append("&oid=" + oid);
System.out.println(buf.toString());
		NamedObject o = parse.getNamedObject(buf.toString());
		return o;
	}

	/**
	 * save NamedObjects
	 * @param Vector<NamedObject>
	 * @return int inserted row count
	 * @see AbstractConnection#saveNamedObject(Vector)
	 */
	public int saveNamedObject(Vector v) {

		// create send data.
		StringBuffer buf = new StringBuffer();
		buf.append("cid=" + ServletCommandController.COMMAND_SAVE_NAMEDOBJECT);
		buf.append("&data=");
		StringBuffer data = new StringBuffer();
		for (Enumeration e = v.elements(); e.hasMoreElements();) {
			NamedObject o = (NamedObject) e.nextElement();
			if (o != null)
				data.append(o.toXMLString());
		}
		buf.append(URLEncoder.encode(data.toString()));

		// send data.
		StringBuffer result = new StringBuffer();
		try {
			URL url = new URL(this.url);
			HttpURLConnection conn = (HttpURLConnection) url.openConnection();
			conn.setRequestMethod("POST");
			conn.setDoOutput(true);
			PrintStream out = new PrintStream(conn.getOutputStream());
			out.print(buf.toString());
			out.close();

			DataInputStream in = new DataInputStream(conn.getInputStream());
			String line;
			while ((line = in.readLine()) != null) {
				result.append(line);
			}
			in.close();
			conn.disconnect();
		} catch (IOException e) {
			e.printStackTrace();
			result = new StringBuffer();
			result.append(LocalDatabase.XML_RESPONSE_HEADER);
			result.append(LocalDatabase.XML_RESPONSE_FOOTER);
		}

		// parse.
		return parse.getRegisterResult(result.toString());
	}

}
