/*
 * LocaldbConnection.java: 
 *
 * Copyright (c) 2002 Ryo FUJIMOTO
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: LocaldbConnection.java,v 1.5 2002/07/16 07:07:53 ryo Exp $
 * $Log: LocaldbConnection.java,v $
 * Revision 1.5  2002/07/16 07:07:53  ryo
 * add constructor with no argument
 *
 * Revision 1.4  2002/07/12 16:53:29  ryo
 * move member and accessor from *Connection to AbstractConnection
 *
 * Revision 1.3  2002/06/26 11:15:20  ryo
 * CRLF conversion
 *
 * Revision 1.2  2002/06/21 13:02:56  ryo
 * add copyright
 *
 */

package org.nomencurator.broker;

import java.io.StringReader;
import java.sql.Connection;
import java.util.Vector;

import org.nomencurator.NamedObject;
import org.nomencurator.Preference;
import org.nomencurator.localdb.LocalDatabase;
import org.nomencurator.controller.ParseXml;
import org.nomencurator.controller.PreferenceManager;

import org.xml.sax.InputSource;

public class LocaldbConnection extends AbstractConnection {

	private LocalDatabase _localdb = null;
	private ParseXml _parseXml = new ParseXml();

	/**
	 * Constructor.
	 */
	public LocaldbConnection() {
		_localdb = new LocalDatabase();
	}

	/**
	 * Constructor.
	 * @param path local database path.
	 */
	public LocaldbConnection(String path) {
		_localdb = new LocalDatabase(path);
		this.path = path;
	}

	/**
	 * Get connection type.
	 * @return String connection type
	 */
	public String getType() {
		return "LOCAL";
	}

	/**
	 * @see AbstractConnection#connect()
	 */
	public Connection connect() {
		return null;
	}

	/**
	 * @see AbstractConnection#disconnect()
	 */
	public void disconnect() {
	}

	/**
	 * @see AbstractConnection#searchNameUsage(String, String, String)
	 */
	public Vector searchNameUsage(String name, String author, String year) {
		return _parseXml.getNameUsageList(new InputSource(new StringReader(_localdb.search(name, author, year))));
	}

	/**
	 * @see AbstractConnection#getNamedObject(String)
	 */
	public NamedObject getNamedObject(String oid) {
	    if (oid == null || oid.length() == 0)
		return null;
	    String xml = _localdb.getObjectData(oid);
	    NamedObject namedObject = _parseXml.getNamedObject(new InputSource(new StringReader(xml)));		
	    return namedObject;
	}
	
	/**
	 * Set top directory for local database.
	 * @param path the top directory for local database.
	 */
	public void setPath(String path) {
		super.setPath(path);
		_localdb.setTopDirectory(path);
	}
	
	/**
	 * Get top directory for local database.
	 * @return String the top directory for local database.
	 */
	public String getPath() {
		return super.getPath();
//		return _localdb.getTopDirectory();
	}

	/**
	 * save NamedObjects
	 * @param Vector<NamedObject>
	 * @return int inserted row count
	 * @see AbstractConnection#saveNamedObject(Vector)
	 */
	public int saveNamedObject(Vector v) {
		return _localdb.addObjectData(v);
	}
	
}
