/*
 * NameUsageBroker.java: 
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id:$
 * $Log:$
 */

package org.nomencurator.controller;

import java.util.Vector;

import org.nomencurator.NameUsage;
import org.nomencurator.NamedObject;

import org.nomencurator.awt.tree.TextTreeModel;

/**
 * An <code>NameUsage</code> broaker interface to get/put
 * <code>NameUsage</code> to/from target <code>Object</code>s
 * even as a hierarchy.
 *
 * @see org.nomencurator.controller.NamedObjectBroker
 * @see org.nomencurator.NameUsage
 *
 * @version 	02 Apr 2002
 * @author 	Nozomi `James' Ytow
 */
public interface NameUsageBroker
    extends NamedObjectBroker
{
    /**
     * Returns <code>Vector</code> containing <code>NameUsage</code>
     * having <code>name</code>, <code>user</code> and <code>year</code>
     *
     * @param NameUsage
     * @param String name
     * @param String author
     * @param String year
     * @return Vector<NameUsageListRow> name record list
     */
    public Vector getNameUsageList(String name, String author, String year);
    
    /**
     * get tree model from a Name record
     * @param String oid
     * @param int higher count
     * @param int lower count
     */
    public TextTreeModel getTreeModel(String oid, int higher, int lower);
    
    /**
     * get NamedObjects list from the object id for an *EditPanel
     * @param NamedObject 
     * @return NamedObject NamedObject List for *EditPanel
     */
    public NamedObject getNamedObjectForEditPanel(NamedObject o);
    
    /**
     * get NamedObjects list for the tree and all EditPanel
     * @param NamedObject 
     * @param int higher
     * @param int lower 
     * @return NameUsage
     */
    public NameUsage getNameUsageTree(NameUsage nameUsage, int higher, int lower);
    
}
