/*
 * ParseNomXml.java: 
 *
 * Copyright (c) 2002 Hiroyuki Okawa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: ParseNomXml.java,v 1.34 2002/09/17 05:06:15 nozomi Exp $
 * $Log: ParseNomXml.java,v $
 * Revision 1.34  2002/09/17 05:06:15  nozomi
 * use XML-based constructor of NamedObject subclasses
 *
 * Revision 1.33  2002/09/05 05:17:22  nozomi
 * support pseudo HTML
 *
 * Revision 1.32  2002/09/01 10:50:41  nozomi
 * change method name from set/setName to set/getUsedName
 *
 * Revision 1.31  2002/08/31 17:51:37  nozomi
 * translate comments and modify coding style
 *
 * Revision 1.30  2002/08/27 08:12:27  ryo
 * add the processing for adding type
 *
 * Revision 1.29  2002/08/26 09:24:23  t.okada
 * add publisher and place to publication
 *
 * Revision 1.28  2002/08/23 02:37:45  t.okada
 * bugfix in case locale is null is corrected.
 *
 * Revision 1.27  2002/08/23 02:24:47  t.okada
 * bug in case locale is null is corrected.
 *
 * Revision 1.26  2002/08/22 13:28:16  t.okada
 * It corrects for a locale colum addition.
 *
 * Revision 1.25  2002/08/20 13:13:14  t.okada
 * addition notes column and lines column
 *
 * Revision 1.24  2002/07/18 14:39:52  t.okada
 * note item is added to nameusage
 *
 * Revision 1.23  2002/07/08 07:43:58  ryo
 * modify link table because unused link table removed
 *
 * Revision 1.22  2002/06/28 12:54:40  ryo
 * fix misspelling
 *
 * Revision 1.21  2002/06/07 14:08:38  ryo
 * change the processing in consideration of the order of author list
 *
 * Revision 1.20  2002/05/15 06:34:55  ryo
 * change tag name of NameUsage's lower
 *
 * Revision 1.19  2002/05/14 03:16:47  t.okada
 * change XML tag name recorder to appearance
 *
 * Revision 1.18  2002/05/08 10:54:58  ryo
 * fix bug in parseAuthor() and parsePublication()
 *
 * Revision 1.17  2002/04/16 03:53:37  nozomi
 * migration to NameUsage from NameRecord
 *
 * Revision 1.16  2002/04/10 07:47:58  nozomi
 * persistentID is misused in ParseNomXml and NameRecordEditPanel, but they'll be fixed later
 *
 * Revision 1.15  2002/04/08 01:53:58  nozomi
 * remove Citation class from import list
 *
 * Revision 1.14  2002/03/29 08:03:04  okawa
 * linkFlag
 *
 * Revision 1.13  2002/03/28 06:28:35  okawa
 * add copyright
 *
 * Revision 1.12  2002/03/25 13:50:36  okawa
 * modify bug
 *
 * Revision 1.11  2002/03/25 11:35:24  okawa
 * modify tags of Affiliation
 *
 * Revision 1.10  2002/03/11 11:26:48  okawa
 * no message
 *
 * Revision 1.9  2002/03/10 00:50:10  okawa
 * modify publication linkage bug
 *
 * Revision 1.8  2002/03/07 16:39:41  okawa
 * add publication in appearance
 *
 * Revision 1.7  2002/02/27 09:54:26  okawa
 * add parse annotation
 *
 * Revision 1.6  2002/02/26 03:02:19  okawa
 * modify tag character of getNamedObject()
 *
 * Revision 1.5  2002/02/22 10:56:57  okawa
 * add Publication search function
 *
 * Revision 1.4  2002/02/21 01:56:47  okawa
 * add register function
 *
 * Revision 1.3  2002/02/14 08:35:11  okawa
 * modify packaging probrem
 *
 * Revision 1.2  2002/02/07 06:22:47  okawa
 * add another parse function
 *
 * Revision 1.1.1.1  2002/01/16 12:33:33  ryo
 * initial import into CVS
 *
 */

package org.nomencurator.controller;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.text.ParsePosition;

import java.util.Date;
import java.util.Locale;
import java.util.Vector;

import org.nomencurator.NamedObject;
import org.nomencurator.NameUsage;
import org.nomencurator.Appearance;
import org.nomencurator.Annotation;
import org.nomencurator.Publication;
import org.nomencurator.Author;
import org.nomencurator.Affiliation;

import org.nomencurator.awt.model.NameUsageTreeNode;

import org.nomencurator.editor.NameUsageListRow;

import org.nomencurator.controller.linktable.LinkRecord;
import org.nomencurator.controller.linktable.NameUsageHigher;
import org.nomencurator.controller.linktable.NameUsageAuthority;
import org.nomencurator.controller.linktable.NameUsageRecorder;
import org.nomencurator.controller.linktable.AppearanceAnnotation;
import org.nomencurator.controller.linktable.AppearanceNameUsage;
import org.nomencurator.controller.linktable.AnnotationFrom;
import org.nomencurator.controller.linktable.AnnotationTo;
import org.nomencurator.controller.linktable.AuthorAffiliation;
import org.nomencurator.controller.linktable.PublicationAuthor;
import org.nomencurator.controller.linktable.PublicationAppearance;

import org.nomencurator.editor.model.LocaleListModel;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

import org.xml.sax.Parser;
import org.xml.sax.helpers.ParserFactory;


/**
 * XML parser for Nomencurator data structure
 */
class ParseNomXml {

    /** Root node of DOM tree */
    org.w3c.dom.Node rootNode_;

    /**
     * Flag for linked object operation.
     * If true, this creates linked object for 1 to 1 relationship.
     * If false, this does not create linked record but set as a
     * propary of NamedObject.
     * Default value is true.
     */
    private boolean linkFlag = true;
    
    /**
      * Constructor
      * @param org.w3c.dom.Document doc
      */
    public ParseNomXml(org.w3c.dom.Document doc)
    {
	rootNode_ = doc.getDocumentElement ();
    }

    /**
     * Constructor
     * @param org.w3c.dom.Node rootnode
     */
    public ParseNomXml(org.w3c.dom.Node rootnode)
    {
        this(rootnode, true);
    }

    /**
     * Constructor
     * @param org.w3c.dom.Node rootnode
     * @param boolean create link record flag
     */
    public ParseNomXml(org.w3c.dom.Node rootnode, boolean linkFlag)
    {
	rootNode_ = rootnode;
	this.linkFlag = linkFlag;
    }

    /**
     * get NameUsage List
     * @return Vector<NameUsageListRow>
     */
    public Vector getNameUsageList()
    {
        Vector v = new Vector();
        NameUsageListRow row;
        NodeList childList = rootNode_.getChildNodes();
        int childCount = childList.getLength();

        for (int i = 0; i < childCount; i++) {
            Node c = childList.item(i);

            if(c.getNodeType() == Node.ELEMENT_NODE) {
		Element f = (Element)c;
		
		if(f.getTagName().equals("item")) {
		    row = getNameUsage(f);
		    if(row != null)
			v.addElement(row);
                }
            }
        }
        return v;
    }

    /**
     * get NameUsage List Row data
     * @param  Element f
     * @return NameUsageListRow
     */
    private NameUsageListRow getNameUsage(Element f)
    {
	NameUsageListRow row = new NameUsageListRow();

	NodeList subChildList = f.getChildNodes();
	int subChildCount = subChildList.getLength();
	
	for (int j = 0; j < subChildCount; j++) {
	    Node child = subChildList.item(j);
	    if(child.getNodeType () == Node.ELEMENT_NODE) {
		Element ele = (Element)child;
		String tagName = ele.getTagName();
		
		if     (tagName.equals ("oid"))    row.setObjectId(getString(ele));
		else if(tagName.equals ("name"))   row.setName(getString(ele));
		else if(tagName.equals ("author")) row.setAuthor(getString(ele));
		else if(tagName.equals ("year"))   row.setYear(getString(ele));
		else{}
	    }
	}
	return row;
    }
    
    /**
     * get Tree Model
     * @return Vector<NameUsageTreeNode>
     */
    public Vector getTreeModel()
    {
        Vector v = new Vector();
        NameUsageTreeNode node;
        NodeList childList = rootNode_.getChildNodes();
        int childCount = childList.getLength();

        for (int i = 0; i < childCount; i++) {
            Node c = childList.item(i);
	    
            if(c.getNodeType() == Node.ELEMENT_NODE) {
		Element f = (Element)c;
		if(f.getTagName().equals("nameusage")) {
		    node = getTreeNode(f);
		    if(node != null)
			v.addElement(node);
                }
            }
        }
        return v;
    }

    /**
     * get NameUsage List Row data
     * @param  Element f
     * @return NameUsageTreeNode
     */
    private NameUsageTreeNode getTreeNode(Element f)
    {
	NameUsageTreeNode node = new NameUsageTreeNode();
	
	NodeList subChildList = f.getChildNodes();
	int subChildCount = subChildList.getLength();
	for (int j = 0; j < subChildCount; j++) {
	    Node child = subChildList.item(j);
	    if(child.getNodeType () == Node.ELEMENT_NODE) {
		Element ele = (Element)child;
		String tagName = ele.getTagName();
		if     (tagName.equals ("oid"))    node.setObjectId(getString(ele));
		else if(tagName.equals ("name"))   node.setName(getString(ele));
		else if(tagName.equals ("higher")) node.setHigher(getString(ele));
		else if(tagName.equals ("lowerTaxon"))   node.addLower(getString(ele));
		else{}
	    }
	}
	return node;
    }

    /**
     * get NameUsage object
     * @return NameUsage
     */
    public NameUsage getNameUsage()
    {
        NameUsage nameUsage = null;
        NodeList childList = rootNode_.getChildNodes();
        int childCount = childList.getLength();
	
        for (int i = 0; i < childCount; i++) {
            Node c = childList.item(i);
	    
            if(c.getNodeType() == Node.ELEMENT_NODE) {
		Element f = (Element)c;
		
		if(f.getTagName().equals("NameUsage")) {
		    //nameUsage = parseNameUsage(f);
		    nameUsage = new NameUsage(f);
		    break;
                }
            }
        }
        return nameUsage;
    }

    /**
     * parse NameUsage data
     * @param  Element f
     * @return NameUsage
     */
    /*
    private NameUsage parseNameUsage(Element f)
    {
	NameUsage nameUsage = new NameUsage();

	NodeList subChildList = f.getChildNodes();
	int subChildCount = subChildList.getLength();

	for (int j = 0; j < subChildCount; j++) {
	    Node child = subChildList.item(j);
	    if(child.getNodeType () == Node.ELEMENT_NODE) {
		Element ele = (Element)child;
		String tagName = ele.getTagName();
		
		if     (tagName.equals ("oid"))       nameUsage.setPersistentID(getString(ele));
		else if(tagName.equals ("rank"))      nameUsage.setRank(getString(ele));
		else if(tagName.equals ("name"))      nameUsage.setUsedName(getString(ele));
		else if(tagName.equals ("authority")) {
		    if(linkFlag) {
			LinkRecord rec = new LinkRecord(nameUsage.persistentID(), getString(ele));
			NameUsageAuthority.getInstance().addLinkRecord(rec);
		    } else {
			nameUsage.parseLine("authority{" + getString(ele) + "}");
		    }
		}
		else if(tagName.equals("note")) nameUsage.setNote(getString(ele));
		else if(tagName.equals("locale")) {
		    String localeID = getString(ele);
		    Locale locale;
		    if(localeID == null || localeID.length() <= 2) {
			locale = new Locale(" ", "");
		    } else {
			String lang = localeID.substring(0, localeID.indexOf("_"));
			String coun = localeID.substring(localeID.indexOf("_") + 1) ;
			locale = new Locale(lang, coun);
		    }
		    nameUsage.setLocale(locale);
		}
		else if(tagName.equals ("appearance")) {
		    if(linkFlag) {
			LinkRecord rec = new LinkRecord(nameUsage.persistentID(), getString(ele));
			NameUsageRecorder.getInstance().addLinkRecord(rec);
		    } else {
			nameUsage.parseLine("appearance{" + getString(ele) + "}");
                    }
		}
		else if(tagName.equals ("higher")) {
		    if(linkFlag) {
			LinkRecord rec = new LinkRecord(nameUsage.persistentID(), getString(ele));
			NameUsageHigher.getInstance().addLinkRecord(rec);
		    } else {
			nameUsage.parseLine("higher{" + getString(ele) + "}");
		    }
		}
		else if(tagName.equals ("lowerTaxon")) {
		    if(linkFlag) {
			LinkRecord rec = new LinkRecord(getString(ele), nameUsage.persistentID());
			NameUsageHigher.getInstance().addLinkRecord(rec);
		    } else {
			nameUsage.parseLine("lower{" + getString(ele) + "}");
		    }
		}
		else if(tagName.equals ("type"))      nameUsage.parseLine("type{" + getString(ele) + "}");
		else if(tagName.equals ("annotation")) {
		    if(linkFlag) {
			LinkRecord rec = new LinkRecord(getString(ele), nameUsage.persistentID());
			AnnotationFrom.getInstance().addLinkRecord(rec);
		    } else {
			nameUsage.parseLine("annotation{" + getString(ele) + "}");
		    }
		}
		else{}
            }
        }
	return nameUsage;
    }
    */

    /**
     * get NamedObject
     * @return NamedObject
     */
    public NamedObject getNamedObject()
    {
        NamedObject o = null;
        NodeList childList = rootNode_.getChildNodes();
        int childCount = childList.getLength();

        for (int i = 0; i < childCount; i++) {
            Node c = childList.item(i);

            if(c.getNodeType() == Node.ELEMENT_NODE) {
		Element f = (Element)c;
		
		if(f.getTagName().equals("NameUsage")) {
		    //o = parseNameUsage(f);
		    o = new NameUsage(f);
		    break;
		} else if(f.getTagName().equals("Appearance")) {
		    //o = parseAppearance(f);
		    o = new Appearance(f);
		    break;
		} else if(f.getTagName().equals("Annotation")) {
		    //o = parseAnnotation(f);
		    o = new Annotation(f);
		    break;
		} else if(f.getTagName().equals("Publication")) {
		    //		    o = parsePublication(f);
		    o = new Publication(f);
		    break;
		} else if(f.getTagName().equals("Author")) {
		    //o = parseAuthor(f);
		    o = new Author(f);
		    break;
		} else if(f.getTagName().equals("Affiliation")) {
		    //o = parseAffiliation(f);
		    o = new Affiliation(f);
		    break;
                }
            }
        }
        return o;
    }
    
    /**
     * get NamedObject List
     * @return Vector<NamedObject>
     */
    public Vector getNamedObjectList()
    {
        Vector v = new Vector();
        NamedObject o = null;
        NodeList childList = rootNode_.getChildNodes();
        int childCount = childList.getLength();

        for (int i = 0; i < childCount; i++) {
            Node c = childList.item(i);

            if(c.getNodeType() == Node.ELEMENT_NODE) {
		Element f = (Element)c;

		if(f.getTagName().equals("NameUsage")) {
		    //o = parseNameUsage(f);
		    o = new NameUsage(f);
		}
		else if(f.getTagName().equals("Appearance")) {
		    //o = parseAppearance(f);
		    o = new Appearance(f);
		}
		else if(f.getTagName().equals("Annotation")) {
		    //o = parseAnnotation(f);
		    o = new Annotation(f);
		}
		else if(f.getTagName().equals("Publication")) {
		    //		    o = parsePublication(f);
		    o = new Publication(f);
		}
		else if(f.getTagName().equals("Author")) {
		    //		    o = parseAuthor(f);
		    o = new Author(f);
		}
		else if(f.getTagName().equals("Affiliation")) {
		    //o = parseAffiliation(f);
		    o = new Affiliation(f);
                }
		if(o != null)
		    v.addElement(o);
		o = null;
            }
        }
        return v;
    }
    
    /**
     * get Appearance
     * @return Appearance
     */
    public Appearance getAppearance()
    {
        Appearance appearance = null;
        NodeList childList = rootNode_.getChildNodes();
        int childCount = childList.getLength();
	
        for (int i = 0; i < childCount; i++) {
            Node c = childList.item(i);
	    
            if(c.getNodeType() == Node.ELEMENT_NODE) {
		Element f = (Element)c;

		if(f.getTagName().equals("Appearance")) {
		    //appearance = parseAppearance(f);
		    appearance = new Appearance(f);
		    break;
                }
            }
        }
        return appearance;
    }

    /**
     * parse Appearance data
     * @param  Element f
     * @return Appearance
     */
    /*
    private Appearance parseAppearance(Element f)
    {
	Appearance appearance = new Appearance();
	
	NodeList subChildList = f.getChildNodes();
	int subChildCount = subChildList.getLength();

	for (int j = 0; j < subChildCount; j++) {
	    Node child = subChildList.item(j);
	    if(child.getNodeType () == Node.ELEMENT_NODE) {
		Element ele = (Element)child;
		String tagName = ele.getTagName();

		if     (tagName.equals ("oid"))        appearance.setPersistentID(getString(ele));
		else if(tagName.equals ("page"))       appearance.parseLine("page{" + getString(ele) + "}");
		else if(tagName.equals ("lines")) appearance.parseLine("lines{" + getString(ele) + "}");
		//		else if(tagName.equals ("appearance")) appearance.parseLine("appearance{" + getString(ele) + "}");
		else if(tagName.equals ("appearance")) {
		    appearance.setAppearance(getString(ele));
		}
		else if(tagName.equals ("publication")) {
		    LinkRecord rec = new LinkRecord(getString(ele), appearance.persistentID());
		    PublicationAppearance.getInstance().addLinkRecord(rec);
		}
		else if(tagName.equals ("annotation")) {
		    LinkRecord rec = new LinkRecord(appearance.persistentID(), getString(ele));
		    AppearanceAnnotation.getInstance().addLinkRecord(rec);
		}
		else if(tagName.equals ("nameusage")) {
		    LinkRecord rec = new LinkRecord(appearance.persistentID(), getString(ele));
		    AppearanceNameUsage.getInstance().addLinkRecord(rec);
		}
		else{}
            }
        }
	return appearance;
    }
    */
    
    /**
     * get Annotation
     * @return Annotation
     */
    public Annotation getAnnotation() 
    {
        Annotation annotation = null;
        NodeList childList = rootNode_.getChildNodes();
        int childCount = childList.getLength();
	
        for (int i = 0; i < childCount; i++) {
            Node c = childList.item(i);
	    
            if(c.getNodeType() == Node.ELEMENT_NODE) {
		Element f = (Element)c;

		if(f.getTagName().equals("Annotation")) {
		    //annotation = parseAnnotation(f);
		    annotation = new Annotation(f);
		    break;
                }
            }
        }
        return annotation;
    }
    
    /**
     * parse Annotation data
     * @param  Element f
     * @return Annotation
     */
    /*
    private Annotation parseAnnotation(Element f)
    {
	Annotation annotation = new Annotation();
	
	NodeList subChildList = f.getChildNodes();
	int subChildCount = subChildList.getLength();

	for (int j = 0; j < subChildCount; j++) {
	    Node child = subChildList.item(j);
	    if(child.getNodeType () == Node.ELEMENT_NODE) {
		Element ele = (Element)child;
		String tagName = ele.getTagName();

		if     (tagName.equals ("oid"))        annotation.setPersistentID(getString(ele));
		else if(tagName.equals ("linktype"))   annotation.parseLine("reason{" + getString(ele) + "}");
		else if(tagName.equals ("appearance")) {
		    LinkRecord rec = new LinkRecord(getString(ele), annotation.persistentID());
		    AppearanceAnnotation.getInstance().addLinkRecord(rec);
		}
		else if(tagName.equals ("from")) {
		    LinkRecord rec = new LinkRecord(annotation.persistentID(), getString(ele));
		    AnnotationFrom.getInstance().addLinkRecord(rec);
		}
		else if(tagName.equals ("to")) {
		    LinkRecord rec = new LinkRecord(annotation.persistentID(), getString(ele));
		    AnnotationTo.getInstance().addLinkRecord(rec);
		}
		else{}
            }
        }
	return annotation;
    }
    */

    /**
     * get Publication
     * @return Publication
     */
    public Publication getPublication()
    {
        Publication publication = null;
        NodeList childList = rootNode_.getChildNodes();
        int childCount = childList.getLength();

        for (int i = 0; i < childCount; i++) {
            Node c = childList.item(i);

            if(c.getNodeType() == Node.ELEMENT_NODE) {
		Element f = (Element)c;
		
		//if(f.getTagName().equals("publication")) {
		if(f.getTagName().equals("Publication")) {
		    //		    publication = parsePublication(f);
		    publication = new Publication(f);
		    break;
                }
            }
        }
        return publication;
    }
    
    /**
     * parse Publication data
     * @param  Element f
     * @return Publication
     */
    /*
    private Publication parsePublication(Element f)
    {
	Publication publication = new Publication();
	
	NodeList subChildList = f.getChildNodes();
	int subChildCount = subChildList.getLength();

	for (int j = 0; j < subChildCount; j++) {
	    Node child = subChildList.item(j);
	    if(child.getNodeType () == Node.ELEMENT_NODE) {
		Element ele = (Element)child;
		String tagName = ele.getTagName();
		String id = ele.getAttribute("id");

		if     (tagName.equals ("oid"))          publication.setPersistentID(getString(ele));
		else if(tagName.equals ("authors"))      publication.parseLine("authors{" + getString(ele) + "}");
		else if(tagName.equals ("affiliations")) publication.parseLine("affiliations{" + getString(ele) + "}");
		else if(tagName.equals ("author")) {
		    LinkRecord rec = new LinkRecord(publication.persistentID(), getString(ele), id);
		    PublicationAuthor.getInstance().addLinkRecord(rec);
		}
		else if(tagName.equals ("citationTitle"))        publication.parseLine("citationTitle{" + getString(ele) + "}");
		else if(tagName.equals ("contentsTitle"))        publication.parseLine("contentsTitle{" + getString(ele) + "}");
		else if(tagName.equals ("isxn"))         publication.parseLine("ISXN{" + getString(ele) + "}");
		else if(tagName.equals ("year"))         publication.parseLine("year{" + getString(ele) + "}");
		else if(tagName.equals ("volume"))       publication.parseLine("volume{" + getString(ele) + "}");
		else if(tagName.equals ("number"))       publication.parseLine("number{" + getString(ele) + "}");
		else if(tagName.equals ("startpage"))    publication.parseLine("from{" + getString(ele) + "}");
		else if(tagName.equals ("lastpage"))     publication.parseLine("to{" + getString(ele) + "}");
		else if(tagName.equals ("notes"))     publication.parseLine("notes{" + getString(ele) + "}");
		else if(tagName.equals ("publisher"))     publication.parseLine("publisher{" + getString(ele) + "}");
		else if(tagName.equals ("place"))     publication.parseLine("place{" + getString(ele) + "}");
		else if(tagName.equals ("appearance")) {
		    LinkRecord rec = new LinkRecord(publication.persistentID(), getString(ele));
		    PublicationAppearance.getInstance().addLinkRecord(rec);
		}
		else{}
            }
        }
	return publication;
    }
    */
    
    /**
     * get Author
     * @return Author
     */
    public Author getAuthor()
    {
        Author author = null;
        NodeList childList = rootNode_.getChildNodes();
        int childCount = childList.getLength();
	
        for (int i = 0; i < childCount; i++) {
            Node c = childList.item(i);
	    
            if(c.getNodeType() == Node.ELEMENT_NODE) {
		Element f = (Element)c;
		
		if(f.getTagName().equals("Author")) {
		    author = new Author(f);
		    break;
                }
            }
        }
        return author;
    }
    
    /**
     * parse Author data
     * @param  Element f
     * @return Author
     */
    /*
    private Author parseAuthor(Element f)
    {
	Author author = new Author();
	
	NodeList subChildList = f.getChildNodes();
	int subChildCount = subChildList.getLength();

	for (int j = 0; j < subChildCount; j++) {
	    Node child = subChildList.item(j);
	    if(child.getNodeType () == Node.ELEMENT_NODE) {
		Element ele = (Element)child;
		String tagName = ele.getTagName();

		if     (tagName.equals ("oid"))          author.setPersistentID(getString(ele));
		else if(tagName.equals ("surname"))      author.setSurname(getString(ele));
		else if(tagName.equals ("firstName"))    author.setFirstName(getString(ele));
		else if(tagName.equals ("middleName"))   author.setMiddleName(getString(ele));
		else if(tagName.equals ("faudality"))      author.setFaudality(getString(ele));
		else if(tagName.equals ("title"))        author.setTitle(getString(ele));
		else if(tagName.equals ("epithet"))      author.setEpithet(getString(ele));
		else if(tagName.equals ("birth"))        author.setBirthDate(getDate(getString(ele)));
		else if(tagName.equals ("death"))        author.setDeathDate(getDate(getString(ele)));
		else if(tagName.equals ("publication")) {
		    LinkRecord rec = new LinkRecord(getString(ele), author.persistentID());
		    PublicationAuthor.getInstance().addLinkRecord(rec);
		}
		else if(tagName.equals ("affiliation")) {
		    LinkRecord rec = new LinkRecord(author.persistentID(), getString(ele));
		    AuthorAffiliation.getInstance().addLinkRecord(rec);
		}
		else{}
            }
        }
	return author;
    }
    */
    
    /**
     * parse Affiliation data
     * @param  Element f
     * @return Affiliation
     */
    /*
    private Affiliation parseAffiliation(Element f)
    {
	Affiliation affiliation = new Affiliation();
	
	NodeList subChildList = f.getChildNodes();
	int subChildCount = subChildList.getLength();
	for (int j = 0; j < subChildCount; j++) {
	    Node child = subChildList.item(j);
	    if(child.getNodeType () == Node.ELEMENT_NODE) {
		Element ele = (Element)child;
		String tagName = ele.getTagName();
		if     (tagName.equals ("oid"))         affiliation.setPersistentID(getString(ele));
		else if(tagName.equals ("institution")) {
		    LinkRecord rec = new LinkRecord(affiliation.persistentID(), getString(ele));
		    // TBD
		    // AffiliationInstitution.getInstance().addLinkRecord(rec);
		}
		else if(tagName.equals ("from")) affiliation.setFrom(java.sql.Date.valueOf(getString(ele)));
		else if(tagName.equals ("until"))   affiliation.setUntil(java.sql.Date.valueOf(getString(ele)));
		else{}
            }
        }
	return affiliation;
    }
*/
    
    /**
     * get Resister Result
     * @return int
     */
    public int getRegisterResult()
    {
        int result = 0;
        NodeList childList = rootNode_.getChildNodes();
        int childCount = childList.getLength();
	
        for (int i = 0; i < childCount; i++) {
            Node c = childList.item(i);
	    
            if(c.getNodeType() == Node.ELEMENT_NODE) {
		Element f = (Element)c;
		
		if(f.getTagName().equals("result")) {
		    result = parseRegisterResult(f);
		    break;
                }
            }
        }
	return result;
    }
    
    /**
     * parse Resiter Result data
     * @param  Element f
     * @return int
     */
    private int parseRegisterResult(Element f)
    {
	int resultCount = 0;
	
	NodeList subChildList = f.getChildNodes();
	int subChildCount = subChildList.getLength();

	for (int j = 0; j < subChildCount; j++) {
	    Node child = subChildList.item(j);
	    if(child.getNodeType () == Node.ELEMENT_NODE) {
		Element ele = (Element)child;
		String tagName = ele.getTagName();

		if (tagName.equals ("count")) resultCount = Integer.parseInt(getString(ele));
		else{}
            }
        }
	return resultCount;
    }
    
    /**
     * get String Data
     * @param  Element f
     * @return String
     */
    private String getString(Element f)
    {
	Node node = f.getFirstChild();
	if(node == null)
	    return "";
	if(node instanceof Text) {
	    Text text = (Text)node;
	    if(text.getData() == null)
		return "";
	    else
		return text.getData().trim();
        }
	return getPseudoHTML(f);
    }

    private String getPseudoHTML(Element e)
    {
	StringBuffer html = new StringBuffer();
	if(e.hasChildNodes()) {
	    NodeList nodes = e.getChildNodes();
	    int children = nodes.getLength();
	    for(int i = 0; i < children; i++)
		parsePseudoHTML(nodes.item(i), html);
	}
	return html.toString();
    }

    private void parsePseudoHTML(Node e, StringBuffer html)
    {
	String nodeName = e.getNodeName();
	boolean toAppendTag = !(e instanceof Text);
	boolean isBR = nodeName.equals("BR");
	if(toAppendTag & !isBR){
	    html.append('<');
	    html.append(nodeName);
	    html.append('>');
	}
	if(!e.hasChildNodes() && !isBR) {
	    html.append(e.getNodeValue());
	}
	else {
	    NodeList nodes = e.getChildNodes();
	    int children = nodes.getLength();
	    for(int i = 0; i < children; i++)
		parsePseudoHTML(nodes.item(i), html);
	}
	if(toAppendTag){
	    if(isBR){
		html.append("<BR>");
	    }
	    else {
		html.append("</");
		html.append(nodeName);
		html.append(">\n");
	    }
	}
    }

    /**
     * get Date Data
     * @param  Element f
     * @return Date
     */
    private Date getDate(String s)
    {
	/*
	DateFormat f = new SimpleDateFormat();
	reutrn f.parse(s, new ParsePosition(0));
	*/

	return new SimpleDateFormat().parse(s, new ParsePosition(0));
    }

}

