/*
 * PreferenceManager.java: 
 *
 * Copyright (c) 2002 Hiroyuki Okawa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: PreferenceManager.java,v 1.5 2002/08/13 02:34:10 ryo Exp $
 * $Log: PreferenceManager.java,v $
 * Revision 1.5  2002/08/13 02:34:10  ryo
 * add save/load preference function
 *
 * Revision 1.4  2002/07/03 12:07:01  ryo
 * create preference file when not found
 *
 * Revision 1.3  2002/06/21 11:34:28  ryo
 * modify save and load function
 *
 * Revision 1.2  2002/03/28 06:28:35  okawa
 * add copyright
 *
 * Revision 1.1  2002/02/01 10:06:12  okawa
 * initial import into CVS
 *
 */

package org.nomencurator.controller;

import java.io.File;
import java.io.IOException;
import java.io.FileNotFoundException;

import java.util.Vector;
import java.util.Enumeration;

import org.nomencurator.Preference;

public class PreferenceManager
{
    private static Preference preference = null;

    static public final String F_LOGIN_PREFERENCE = System.getProperty("user.name") +".pre";

	/**
	 * Constructor
	 */
    private PreferenceManager() {
    }

	/**
	 * get Preference instance
	 * @return Preference  the instance of the user prefrence
	 */
	public static Preference getInstance() {
	    if(preference == null) {
	        // create preference instance with the default value
	        preference = new Preference();
	    }
	    return preference;
    }

	/**
	 * load Preference from the file
	 * @param File preference file object
	 */
	public static void loadPreference(File file) {
		if (preference == null)
			preference = new Preference();
		try {
			preference.readXML(file);
		} catch (FileNotFoundException e) {
			savePreference(file);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
    
	/**
	 * load Preference
	 */
	public static void loadPreference() {
		loadPreference(new File(F_LOGIN_PREFERENCE));
	}

	/**
	 * save Preference to the file
	 * @param File preference file object
	 */
	public static void savePreference(File file) {
		try {
			preference.writeXML(file);
		} catch (IOException e) {
			e.printStackTrace();
		}
    }

	/**
	 * save Preference
	 */
	public static void savePreference() {
		savePreference(new File(F_LOGIN_PREFERENCE));
	}

}
