/*
 * AbstractConnectionSettingPanel.java : 
 *
 * Copyright (c) 2002 Ryo FUJIMOTO
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: AbstractConnectionSettingPanel.java,v 1.4 2002/08/30 04:49:11 ryo Exp $
 * $Log: AbstractConnectionSettingPanel.java,v $
 * Revision 1.4  2002/08/30 04:49:11  ryo
 * comment out debug message
 *
 * Revision 1.3  2002/08/01 08:05:34  ryo
 * rename to "enable" from "valid"
 *
 * Revision 1.2  2002/07/16 07:08:24  ryo
 * change argument type of constructor from AbstractConnection to ConnectionEditModel and fix NullPointerException bug
 *
 * Revision 1.1  2002/07/12 16:56:18  ryo
 * initial import into CVS, add connection setting logic
 *
 */

package org.nomencurator.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;

import java.util.Vector;

import jp.kyasu.awt.Label;
import jp.kyasu.awt.TextField;
import jp.kyasu.awt.Checkbox;
import jp.kyasu.editor.DocumentEditor;
import jp.kyasu.editor.Editor;
import jp.kyasu.graphics.TextStyle;
import jp.kyasu.graphics.VTitledPaneBorder;

import org.nomencurator.editor.model.ConnectionEditModel;

public abstract class AbstractConnectionSettingPanel extends Panel {

	/** Default width of <code>TextField</code>s */
	protected static int defaultTextFieldSize = 48;

    /** <code>AbstractConnection</code> represented this model */
	protected ConnectionEditModel model;
	
	/** <code>Panel</code> represents validity of writing of connection */
	protected Panel settingPanel;

    /** <code>TextField</code> represents name of the connection */
	protected TextField nameTextField;

    /** <code>TextField</code> represents driver class name of the connection */
	protected TextField driverClassNameTextField;

    /** <code>TextField</code> represents url of the connection */
	protected TextField urlTextField;

    /** <code>TextField</code> represents user name of the connection */
	protected TextField usernameTextField;

    /** <code>TextField</code> represents password of the connection */
	protected TextField passwordTextField;

    /** <code>TextField</code> represents path of the connection */
	protected TextField pathTextField;

    /** <code>Checkbox</code> represents validity of connection of the connection */
	protected Checkbox validCheckbox;
	
    /** <code>Checkbox</code> represents validity of writing of connection of the connection */
	protected Checkbox writableCheckbox;

	/** Title of name component */
	protected static String nameTitle = "name :";

	/** Title of driver class name component */
	protected static String driverClassNameTitle = "driver :";

	/** Title of url component */
	protected static String urlTitle = "url :";

	/** Title of user name component */
	protected static String usernameTitle = "username :";

	/** Title of password component */
	protected static String passwordTitle = "password :";

	/** Title of path component */
	protected static String pathTitle = "path :";

	/** Title of validity of connection component */
	protected static String validTitle = "enable";

	/** Title of validity of writing of connection component */
	protected static String writableTitle = "writable";

	/**
	 * Constractor.
	 */
	protected AbstractConnectionSettingPanel(ConnectionEditModel m) {
		setModel(m);
	}

	/**
	 * Creates connection container <code>Panel</code> and layout 
	 * <code>Component</code>s representing the connection information 
	 */
	protected void createSettingPanel() {
		if (settingPanel != null)
			remove(settingPanel);
		settingPanel = new Panel();
		createSettingComponents();
		layoutSettingComponents();
		add(settingPanel);
	}

	/**
	 * Creates <code>Component</code>s representing the connection information
	 */
	protected void createSettingComponents() {
		createNameTextField();
		createDriverClassNameTextField();
		createUrlTextField();
		createUsernameTextField();
		createPasswordTextField();
		createPathTextField();
		createValidCheckbox();
		createWritableCheckbox();
	}

	/**
	 * Layouts <code>Component</code>s representing the connection information
	 */
	protected abstract void layoutSettingComponents();

    /**
     * Creates <code>Component</code> representing name of the connection
     */
	protected void createNameTextField() {
		nameTextField = new TextField(
			(model == null) ? "" : model.getName(),
			defaultTextFieldSize);
	}
	
    /**
     * Creates <code>Component</code> representing driver class name of the connection
     */
	protected void createDriverClassNameTextField() {
		driverClassNameTextField = new TextField(
			(model == null) ? "" : model.getDriverName(),
			defaultTextFieldSize);
	}

    /**
     * Creates <code>Component</code> representing url of the connection
     */
	protected void createUrlTextField() {
		urlTextField = new TextField(
			(model == null) ? "" : model.getUrl(),
			defaultTextFieldSize);
	}

    /**
     * Creates <code>Component</code> representing user name of the connection
     */
	protected void createUsernameTextField() {
		usernameTextField = new TextField(
			(model == null) ? "" : model.getUsername(),
			defaultTextFieldSize);
	}
	
    /**
     * Creates <code>Component</code> representing password of the connection
     */
	protected void createPasswordTextField() {
		passwordTextField = new TextField(
			(model == null) ? "" : model.getPassword(),
			defaultTextFieldSize);
	}
	
    /**
     * Creates <code>Component</code> representing path of the connection
     */
	protected void createPathTextField() {
		pathTextField = new TextField(
			(model == null) ? "" : model.getPath(),
			defaultTextFieldSize);
	}
	
    /**
     * Creates <code>Component</code> representing validity of the connection
     */
	protected void createValidCheckbox() {
		validCheckbox = new Checkbox();
		validCheckbox.setState((model == null) ? true : model.getValid());
	}
	
    /**
     * Creates <code>Component</code> representing validity of writing of the connection
     */
	protected void createWritableCheckbox() {
		writableCheckbox = new Checkbox();
		writableCheckbox.setState((model == null) ? false : model.getWritable());
	}

    /**
     * Layouts <code>Component</code> representing name of the connection
     */
	protected void layoutNameTextField() {
		settingPanel.add(new Label(nameTitle), nameTextField);
	}

    /**
     * Layouts <code>Component</code> representing driver class name of the connection
     */
	protected void layoutDriverClassNameTextField() {
		settingPanel.add(new Label(driverClassNameTitle), driverClassNameTextField);
	}

    /**
     * Layouts <code>Component</code> representing url of the connection
     */
	protected void layoutUrlTextField() {
		settingPanel.add(new Label(urlTitle), urlTextField);
	}

    /**
     * Layouts <code>Component</code> representing user name of the connection
     */
	protected void layoutUsernameTextField() {
		settingPanel.add(new Label(usernameTitle), usernameTextField);
	}

    /**
     * Layouts <code>Component</code> representing password of the connection
     */
	protected void layoutPasswordTextField() {
		settingPanel.add(new Label(passwordTitle), passwordTextField);
	}

    /**
     * Layouts <code>Component</code> representing path of the connection
     */
	protected void layoutPathTextField() {
		settingPanel.add(new Label(pathTitle), pathTextField);
	}

    /**
     * Layouts <code>Component</code> representing validity of the connection
     */
	protected void layoutValidCheckbox() {
		settingPanel.add(validCheckbox, new Label(validTitle));
	}

    /**
     * Layouts <code>Component</code> representing validity of writing of the connection
     */
	protected void layoutWritableCheckbox() {
		settingPanel.add(writableCheckbox, new Label(writableTitle));
	}

	/**
	 * Get model.
	 * @return model
	 */
	protected ConnectionEditModel getModel() {
		if (model == null)
			model = new ConnectionEditModel();
		model.setName(nameTextField.getText());
		model.setDriverName(driverClassNameTextField.getText());
		model.setUrl(urlTextField.getText());
		model.setUsername(usernameTextField.getText());
		model.setPassword(passwordTextField.getText());
		model.setPath(pathTextField.getText());
		model.setValid(validCheckbox.getState());
		model.setWritable(writableCheckbox.getState());
		return model;
	}

	/**
	 * Set model.
	 * @param AbstractConnection model
	 */
	protected void setModel(ConnectionEditModel m) {
		model = m;
		createSettingPanel();
	}

}
