/*
 * AnnotationEditDialog.java:  a Dialg to edit an Annotation
 * for TaxoNote based on Nomencurator data model
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 *
 * $Id: AnnotationEditDialog.java,v 1.7 2002/10/10 20:19:21 nozomi Exp $
 * $Log: AnnotationEditDialog.java,v $
 * Revision 1.7  2002/10/10 20:19:21  nozomi
 * support selection of NameUsageEditPanel by double click
 *
 * Revision 1.6  2002/09/17 08:50:48  nozomi
 * re-organise initialisation
 *
 * Revision 1.5  2002/09/07 04:01:52  nozomi
 * automatic put to unsaved pool
 *
 * Revision 1.4  2002/09/07 03:09:27  nozomi
 * use modified flag
 *
 * Revision 1.3  2002/09/06 02:05:16  nozomi
 * call setAttributes() when OK button pressed
 *
 * Revision 1.2  2002/09/05 05:18:02  nozomi
 * use setSize()
 *
 * Revision 1.1  2002/09/05 02:31:31  nozomi
 * initial import into CVS repository
 *
 */

package org.nomencurator.editor;

import java.awt.Frame;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

import jp.kyasu.graphics.Text;

import jp.kyasu.awt.Button;


import org.nomencurator.Annotation;
import org.nomencurator.NamedObject;

import org.nomencurator.awt.Dialog;

import org.nomencurator.editor.model.NamedObjectEditModel;
import org.nomencurator.editor.model.ObjectEditModel;
import org.nomencurator.editor.model.AnnotationEditModel;


/**
 * <code>Dialog</code> to edit an <code>Annotation</code>
 *
 * @see org.nomencurator.editor.model.AnnotationEditModel
 * @see org.nomencurator.editor.AnnotationEditPanel
 * @see org.nomencurator.Annotation
 *
 * @version 	10 Oct 2002
 * @author 	Nozomi `James' Ytow
 */
public class AnnotationEditDialog
    extends Dialog
    implements /*AnnotationEditor,*/ ActionListener
{
    protected AnnotationEditPanel editPanel;

    protected Button okButton;
    protected Button cancelButton;

    protected boolean isOK;
    
    public AnnotationEditDialog(Frame frame)
    {
	this(new Annotation(), frame);
    }

    public AnnotationEditDialog(Annotation annotation, Frame frame)
    {
	this(new AnnotationEditModel(annotation), frame);
    }

    public AnnotationEditDialog(AnnotationEditModel model, Frame frame)
    {
	this(model, frame, "Annotation", true);
    }

    public AnnotationEditDialog(AnnotationEditModel model, Frame frame, String title, boolean modal)
    {
	super(frame, title, modal);
	editPanel.setModel(model);
	editPanel.setOwnerFrame(frame);
	isOK = false;
	setSize(getPreferredSize());
    }

    protected void createButtons()
    {
	okButton = new Button("Ok");
	okButton.addActionListener(this);
	cancelButton = new Button("Cancel");
	cancelButton.addActionListener(this);
    }

    protected void createPanels()
    {
	south = new Panel();
	editPanel = new AnnotationEditPanel();
	center = editPanel;
    }

    protected void addComponents()
    {
	south.add(okButton);
	south.add(cancelButton);
    }

    public void actionPerformed(ActionEvent e)
    {
	Object source = e.getSource();
	if(source == okButton) {
	    isOK = true;
	    if(editPanel.isModified())
		editPanel.saveAttributes();
	    dispose();
	}
	else if(source == cancelButton) {
	    isOK = false;
	    dispose();
	}
    }

    /**
     * Invoked when a component gained focus
     * @see java.awt.event.FocusListener
     */
    public void focusGained(FocusEvent event)
    {
	//	editPanel.focusGained(event);
    }

    /**
     * Invoked when a component lost focus
     * @see java.awt.event.FocusListener
     */
    public void focusLost(FocusEvent event)
    {
	//	editPanel.focusLost(event);
    }

    /**
     * Returns true if this editor allows modification of
     * accompanying model.
     * It is part of <code>ObjectEditor</code> interface.
     *
     * @return true if this editor allows modification of
     * accompanying model, or false if not
     *
     * @see org.nomencurator.editor.ObjectEditor.isEditable()
     */
    public boolean isEditable()
    {
	return editPanel.isEditable();
    }

    /**
     * Sets this editor editable according to given parameter <code>editable</code>.
     * It is part of <code>ObjectEditor</code> interface.
     *
     * @param editable true to allow modification of
     * accompanying model by this edior, or false to disable
     *
     * @see org.nomencurator.editor.ObjectEditor.setEditable()
     */
    public void setEditable(boolean editable)
    {
	editPanel.setEditable(editable);
    }

    /**
     * Returns <code>ObjectEditModel</code> under edition
     * by this editor.
     * It is part of <code>ObjectEditor</code> interface.
     *
     * @return ObjectEditModel under edition
     *
     * @see org.nomencurator.editor.ObjectEditor.getModel()
     */
    public ObjectEditModel getModel()
    {
	return editPanel.getModel();
    }


    /**
     * Sets given <code>model</code> to be edited by this editor
     * It is part of <code>ObjectEditor</code> interface.
     *
     * @param model <code>ObjectEditModel</code> to be edited
     *
     * @see org.nomencurator.editor.ObjectEditor.setModel()
     */
    public synchronized void setModel(ObjectEditModel model)
    {
	editPanel.setModel(model);
    }

    /**
     * Adds a <code>listener</code> as <code>ForcusListener</code>
     * to this.
     *
     * @param listener <code>FocusListener</code> to be added
     */
    public synchronized void addFocusdListener(FocusListener listener)
    {
	editPanel.addFocusListener(listener);
    }

    /**
     * Removes a <code>listener</code> as <code>ForcusListener</code>
     * to this.
     *
     * @param listener <code>FocusListener</code> to be removed
     */
    public void removeFocusdListener(FocusListener listener)
    {
	editPanel.removeFocusListener(listener);
    }

    /**
     * Gets <code>NamedObjectEditModel</code> accompanying with this editor
     *
     * @return NamedObjectEditModel accompanying with this editor
     */
    public NamedObjectEditModel getNamedObjectEditModel()
    {
	return editPanel.getNamedObjectEditModel();
    }

    /**
     * A utility method to set <code>namedObject</code> as
     * target of edition by accompanying <code>NamedObjectEditModel</code>
     *
     * @param namedObject to be set as target <code>NamedObject</code>
     */
    public NamedObject getNamedObject()
    {
	return editPanel.getNamedObject();
    }

    /**
     * A utility method to set <code>namedObject</code> as
     * target of edition by accompanying <code>NamedObjectEditModel</code>
     *
     * @param namedObject to be set as target <code>NamedObject</code>
     */
    public void setNamedObject(NamedObject namedObject)
    {
	editPanel.setObject(namedObject);
    }


    /**
     * A utility method to load attributes of <code>Object</code>
     * to the model
     *
     * @see ObjectEditModel.loadAttributes()
     */
    public void loadAttributes()
    {
	editPanel.loadAttributes();
    }

    /**
     * A utility method to save attributes to <code>Object</code>
     * from the model
     *
     * @see ObjectEditModel.saveAttributes()
     */
    public void saveAttributes()
    {
	editPanel.saveAttributes();
    }

    /**
     * Returns <code>String</code> summarizes editor's contens 
     */
    public String getSummary()
    {
	return editPanel.getSummary();
    }

    /**
     * Returns <code>String</code> summarizes editor's contens 
     */
    public String[] getSummaryArray()
    {
	return editPanel.getSummaryArray();
    }

    /**
     * Returns <code>String</code> summarizes editor's contens 
     */
    public Text getSummaryText()
    {
	return editPanel.getSummaryText();
    }

    /**
     * Returns <code>String</code> summarizes editor's contens 
     */
    public Text[] getSummaryTextArray()
    {
	return editPanel.getSummaryTextArray();
    }

    /**
     * Gets <code>AnnotationEditModel</code> accompanying with this editor
     *
     * @return AnnotationEditModel accompanying with this editor
     */
    public AnnotationEditModel getAnnotationEditModel()
    {
	return editPanel.getAnnotationEditModel();
    }


    /**
     * Sets given <code>model</code> as <code>AnnotationEditModel</code> 
     * accompanying with this editor, or do nothing if it is already there.
     *
     * @param model <code>AnnotationEditModel</code> to be set as model of this editor
     */
    public void setModel(AnnotationEditModel model)
    {
	editPanel.setModel(model);
    }

    /**
     * A utility method to get <code>Annotation</code> under edition
     *
     * @return Annotation under edition
     */
    public Annotation getAnnotation()
    {
	return editPanel.getAnnotation();
    }


    /**
     * A utility method to set <code>annotation</code> as
     * target of edition by accompanying <code>AnnotationEditModel</code>
     *
     * @param annotation to be set as target <code>Annotation</code>
     */
    public void setAnnotation(Annotation annotation)
    {
	editPanel.setAnnotation(annotation);
    }

    public boolean isOK()
    {
	return isOK;
    }

    /**
     * Sets a <CODE>NameUsageEditPanel</CODE> to display 
     * selected <CODE>NameUsageEditModel</CODE>
     *
     * @param panel <CODE>NameUsageEditPanel</CODE> to be used to
     * display selected <CODE>NameUsageEditModel</CODE>
     */
    public void setNameUsageEditPanel(NameUsageEditPanel panel)
    {
	editPanel.setNameUsageEditPanel(panel);
    }

}


