/*
 * AnnotationEditPanel.java:  a Panel of AnnotationEditor
 * for TaxoNote based on Nomencurator data model
 *
 * Copyright (c) 2001, 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: AnnotationEditPanel.java,v 1.14 2002/10/18 07:47:27 nozomi Exp $
 * $Log: AnnotationEditPanel.java,v $
 * Revision 1.14  2002/10/18 07:47:27  nozomi
 * remove debug infro printing line
 *
 * Revision 1.13  2002/10/16 07:08:26  nozomi
 * fix double click handling
 *
 * Revision 1.12  2002/10/10 20:19:21  nozomi
 * support selection of NameUsageEditPanel by double click
 *
 * Revision 1.11  2002/09/24 01:28:35  nozomi
 * use JDK1.2 methods if available
 *
 * Revision 1.10  2002/09/07 17:15:12  nozomi
 * fix bug in unsaved object putting methods
 *
 * Revision 1.9  2002/09/07 04:01:52  nozomi
 * automatic put to unsaved pool
 *
 * Revision 1.8  2002/09/07 03:09:27  nozomi
 * use modified flag
 *
 * Revision 1.7  2002/09/06 02:06:26  nozomi
 * support load/saveAttributes()
 *
 * Revision 1.6  2002/09/05 02:27:57  nozomi
 * override Button creation
 *
 * Revision 1.5  2002/07/02 08:24:15  nozomi
 * implements setEditor()
 *
 * Revision 1.4  2002/05/14 11:36:31  nozomi
 * add dummy updateView()
 *
 * Revision 1.3  2002/04/16 03:53:37  nozomi
 * migration to NameUsage from NameRecord
 *
 * Revision 1.2  2002/02/01 11:30:29  nozomi
 * Using org.nomencurator.editor.TableList
 *
 * Revision 1.1  2002/01/29 06:42:57  nozomi
 * initial import into CVS
 *
 */

package org.nomencurator.editor;

import java.util.Enumeration;
import java.util.Vector;

import java.awt.Frame;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import jp.kyasu.awt.Choice;
import jp.kyasu.awt.Label;

import jp.kyasu.editor.Editor;

import jp.kyasu.graphics.VTitledPaneBorder;

import org.nomencurator.Annotation;

import org.nomencurator.broker.NamedObjectBroker;

import org.nomencurator.editor.AnnotationEditor;

import org.nomencurator.editor.model.AnnotationEditModel;
import org.nomencurator.editor.model.NameUsageEditModel;
import org.nomencurator.editor.model.NameUsageListModel;
import org.nomencurator.editor.model.ObjectEditModel;

/**
 * <code>Panel</code> to view and modify an <code>Annotation</code>
 * accompanying to an <code>AnnotationEditModel</code>.
 *
 * @see org.nomencurator.editor.model.AnnotationEditModel
 * @see org.nomencurator.Annotation
 *
 * @version 	18 Oct 2002
 * @author 	Nozomi `James' Ytow
 */
public class AnnotationEditPanel
    extends NamedObjectEditPanel
    implements AnnotationEditor
{
    /** Default row number of nameUsageList */
    protected int defaultNameUsageListRows = 5;

    /** <code>AnnotationEditModel</code> used by this <code>Panel</code> */
    protected AnnotationEditModel model;

    /** <code>Choice</code> for kind of annotation */
    protected Choice annotationType;

    /** Title of annotation type <code>Choice</code> */
    protected static String annotationTypeTitle = "Annotation type:";

    /**
     * A <code>org.nomencurator.editor.Panel</code> to contain
     * annotatiohn type <code>Chooice</code>
     */
    protected org.nomencurator.editor.Panel annotationTypePanel;

    /** <code>TableList</code> representing annotators */
    protected TableList annotatorList;

    /** <code>BorderedPanel</code> containing annotator list */
    protected BorderedPanel annotatorListPanel;

    /** Title of <code>BorderedPanel</code> containing annotator list */
    protected static String annotatorListPanelTitle = "Referring from";

    /** <code>Vector</code> of annotator editors */
    protected Vector annotatorEditors;

    /** <code>TableList</code> representing annotators */
    protected TableList annotantList;

    /** <code>BorderedPanel</code> containing annotant list */
    protected BorderedPanel annotantListPanel;

    /** Title of <code>BorderedPanel</code> containing annotant list */
    protected static String annotantListPanelTitle = "Referring to";

    /** <code>Vector</code> of annotant editors */
    protected Vector annotantEditors;

    protected NameSearchDialog search;

    protected TableList nameList;
    
    protected Frame owner;

    protected NameUsageEditPanel nameUsageEditPanel;

    /**
     * Creates an <code>AnnotationEditPanel</code> with new <code>AnnotationEditModel</code>
     */
    public AnnotationEditPanel()
    {
	this(new AnnotationEditModel());
    }

    /**
     * Creates an <code>AnnotationEditPanel</code> associating with given <code>model</code>.
     *
     * @param model <code>AnnotationEditModel</code> to be edited by this model
     */
    public AnnotationEditPanel(AnnotationEditModel model)
    {
	this(model, true);
    }

    /**
     * Creates an <code>AnnotationEditPanel</code> associating with given <code>model</code>.
     *
     * @param model <code>AnnotationEditModel</code> to be edited by this model
     */
    public AnnotationEditPanel(AnnotationEditModel model, boolean editable)
    {
	this(model, editable, /*new AppearanceEditPanel(model.getAppearanceEditModel()),*/  null, null);

    }

    /**
     * Creates an <code>AnnotationEditPanel</code> associating with given <code>model</code>.
     *
     * @param model <code>AnnotationEditModel</code> to be edited by this model
     */
    public AnnotationEditPanel(AnnotationEditModel model, 
			      boolean editable,
			       //			      AppearanceEditPanel appearance, 
			      Vector annotators,
			      Vector annotants)
    {
	super(model, editable);
    }

    /**
     * Creates a <code>Panel</code> with its containing <code>Button</code>s 
     * to control the editor.
     *
     */
    protected void createButtonPanel()
    {
    }

    /**
     * Adds components to this <code>Panel</code>
     *
     */
    protected void addModelComponents()
    {
	add(annotatorListPanel);
	add(annotationTypePanel);
	add(annotantListPanel);
    }

    /**
     * Removes components from this <code>Panel</code>
     *
     */
    protected void removeModelComponents()
    {
	remove(annotantListPanel);
	remove(annotatorListPanel);
	remove(annotationTypePanel);
    }
    
    /**
     * Creates components corresponding to the model
     *
     */
    protected void createModelComponents()
    {
	model = getAnnotationEditModel();
	//	model.loadAttributes();
	createAnnotationTypePanel();
	createAnnotatorListPanel();
	createAnnotantListPanel();
    }

    /**
     * Creates citation components corresponding to the model
     *
     */
    protected void createAnnotationTypePanel()
    {
	//KFC's Choice
	annotationType = new Choice(model.getAnnotationType());
	/* Java AWT
	annotationType = new Choice();
	String[][] typelist = model.getAnnotationTypeList();
	for(int i = 0; i < typelist.length; i++)
	    annotationType.add(typelist[i][0]);
	*/
	annotationType.select(model.getAnnotationTypeString());
	annotationType.addItemListener(this);
	annotationTypePanel = new org.nomencurator.editor.Panel();
	annotationTypePanel.add(new Label(annotationTypeTitle), annotationType);
    }

    /**
     * Creates annotator components corresponding to the model
     *
     */
    protected void createAnnotatorListPanel()
    {
	NameUsageListModel annotatorListModel = 
	    (NameUsageListModel)model.getAnnotatorListModel();
	annotatorList = new TableList(annotatorListModel,
				      defaultNameUsageListRows,
				      annotatorListModel.getTitle());
	annotatorList.addMouseListener(this);
	annotatorListPanel = new BorderedPanel(new VTitledPaneBorder(annotatorListPanelTitle));
	annotatorListPanel.add(annotatorList);
    }

    /**
     * Creates annotant components corresponding to the model
     *
     */
    protected void createAnnotantListPanel()
    {
	NameUsageListModel annotantListModel = 
	    (NameUsageListModel)model.getAnnotantListModel();
	annotantList = new TableList(annotantListModel,
				      defaultNameUsageListRows,
				      annotantListModel.getTitle());
	annotantList.addMouseListener(this);
	annotantListPanel = new BorderedPanel(new VTitledPaneBorder(annotantListPanelTitle));
	annotantListPanel.add(annotantList);
    }

    /**
     * Sets <CODE>ed</CODE> as <CODE>Editor</CODE> of <CODE>TextComponent</CODE>s
     * to provide <CODE>Text</CODE> handling using GUI.
     *
     * @param ed <CODE>Editor</CODE> to be linked to <CODE>TextComponent</CODE>s
     * of this
     */
    public void setEditor(Editor ed)
    {
	if(focusedEditor == ed)
	    return;

	if(focusedEditor != null) {
	}

	focusedEditor = ed;

	if(focusedEditor != null) {
	}
    }

    /**
     * Gets <code>AnnotationEditModel</code> accompanying with this editor
     *
     * @return AnnotationEditModel accompanying with this editor
     */
    public AnnotationEditModel getAnnotationEditModel()
    {
	return (AnnotationEditModel)getModel();
    }

    /**
     * Sets given <code>model</code> as <code>AnnotationEditModel</code> 
     * accompanying with this editor, or do nothing if it is already there.
     *
     * @param model <code>AnnotationEditModel</code> to be set as model of this editor
     */
    /*
    public void setAnnotationEditModel(AnnotationEditModel model)
    {
	if(this.model == model)
	    return;
	super.setModel(model);
	this.model = model;
	//model.loadAttributes();
	annotationType.select(model.getAnnotationTypeString());
	annotatorList.setModel((NameUsageListModel)model.getAnnotatorListModel());
	annotantList.setModel((NameUsageListModel)model.getAnnotantListModel());
    }
    */

    /**
     * Setups components to use given <CODE>model</CODE>.
     * This method is called from setModel(ObjectEditModel)
     * internally.
     */
    protected void setComponents(ObjectEditModel objectEditModel)
    {
	model = (AnnotationEditModel)objectEditModel;
	annotationType.select(model.getAnnotationTypeString());
	annotatorList.setModel((NameUsageListModel)model.getAnnotatorListModel());
	annotantList.setModel((NameUsageListModel)model.getAnnotantListModel());
    }


    /**
     * Sets given <code>model</code> to be edited by this editor
     * It is part of <code>ObjectEditor</code> interface.
     *
     * @param model <code>ObjectEditModel</code> to be edited
     *
     * @see org.nomencurator.editor.ObjectEditor.setModel()
     */
    /*
    public synchronized void setModel(ObjectEditModel model)
    {
	if(this.model == model)
	    return;

	setAnnotationEditModel((AnnotationEditModel)model);
    }
    */

    /**
     * A utility method to get <code>Annotation</code> under edition
     *
     * @return Annotation under edition
     */
    public Annotation getAnnotation()
    {
	return (Annotation)getObject();
    }

    /**
     * A utility method to set <code>annotation</code> as
     * target of edition by accompanying <code>AnnotationEditModel</code>
     *
     * @param annotation to be set as target <code>Annotation</code>
     */
    public void setAnnotation(Annotation annotation)
    {
	setObject(annotation);
    }

    /**
     * Creates an empty <code>AnnotationEditModel</code>.
     */
    protected ObjectEditModel createObjectEditModel()
    {
	return new AnnotationEditModel();
    }

    /**
     * Clears contents
     */
    public void clear()
    {
    }

    /**
     * Returns clone of this object
     */
    public Object clone()
    {
	return new AnnotationEditPanel((AnnotationEditModel)model.clone(), editable);
    }

    public void updateView()
    {
    }

    public int getAnnotationTypeIndex()
    {
	return annotationType.getSelectedIndex();
    }

    public void mouseDoubleClicked(MouseEvent event)
    {
	Object source = event.getSource();

	if(source != annotatorList &&
	   source != annotantList) {
	    return;
	}

	nameList = (TableList)source;
	NameUsageEditModel nameModel =
	    (NameUsageEditModel) (nameList.getSelectedModel());
	if(nameModel != null &&
	   nameModel != nameList.getDummyModel()) {
	    if(nameUsageEditPanel != null)
		nameUsageEditPanel.setModel(nameModel);
	    return;
	}
	if(search == null) {
	    search = new NameSearchDialog(owner);
	}
	search.pack();
	search.show();

	if(search.isOK()) {
	    Vector names = search.getSelectedNameUsageEditModels();
	    if(names != null) {
		Enumeration e = names.elements();
		while(e.hasMoreElements()) {
		    NameUsageEditModel model = 
			(NameUsageEditModel)e.nextElement();
		    if(!nameList.contains(model)) {
			nameList.addModel(model);
			setModified(true);
		    }
		}
	    }
	}
	nameList = null;
	    
    }

    public void loadAttributes()
    {
	getModel().loadAttributes();
	if(annotationType != null)
	    annotationType.select(getAnnotationEditModel().getAnnotationTypeString());
    }


    public void saveAttributes()
    {
	getAnnotationEditModel().setAnnotationTypeString((String)annotationType.getSelectedItem());
	getModel().saveAttributes();
    /*
	annotation = getAnnotation();
	if(annotation == null)
	    annotation = new Annotation();
	annotation.setLinkType((String)annotationType.getSelectedItem());
	Enumeration e = annotatorList.getModels().elements();
	while(e.hasMoreElements()) {
	    annotation.addAnnotator(((NameUsageEditModel)e.netxtElement()).geeNameUsage());
	}
	e = annotantList.getModels().elements();
	while(e.hasMoreElements()) {
	    annotation.addAnnotant(((NameUsageEditModel)e.netxtElement()).geeNameUsage());
	}
    */
    }

    /*
    public void itemStateChanged(ItemEvent e)
    {
	setModified(true);
    }
    */

    public void setOwnerFrame(Frame frame) {
	owner = frame;
    }

    public void putUnsavedObject()
    {
	if(isModified()) {
	    NamedObjectBroker broker = NamedObjectBroker.getInstance();
	    Annotation a = getAnnotation();
	    broker.putUnsavedObject(a.getAppearance());
	    broker.putUnsavedObjects(a.getAnnotators());
	    broker.putUnsavedObjects(a.getAnnotatants());
	}
	super.putUnsavedObject();
    }

    /**
     * Sets a <CODE>NameUsageEditPanel</CODE> to display 
     * selected <CODE>NameUsageEditModel</CODE>
     *
     * @param panel <CODE>NameUsageEditPanel</CODE> to be used to
     * display selected <CODE>NameUsageEditModel</CODE>
     */
    public void setNameUsageEditPanel(NameUsageEditPanel p)
    {
	if(nameUsageEditPanel == p)
	    return;
	nameUsageEditPanel = p;
    }
}
