/*
 * AnnotationEditor.java:  an interface of AnnotationEditor
 * for TaxoNote based on Nomencurator data model
 *
 * Copyright (c) 2001 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: AnnotationEditor.java,v 1.2 2002/09/07 03:09:27 nozomi Exp $
 * $Log: AnnotationEditor.java,v $
 * Revision 1.2  2002/09/07 03:09:27  nozomi
 * use modified flag
 *
 * Revision 1.1  2002/01/29 06:48:21  nozomi
 * initial import into CVS
 *
 */

package org.nomencurator.editor;

import org.nomencurator.Annotation;

import org.nomencurator.editor.model.AnnotationEditModel;

/**
 * Interface for graphical component wrapping
 * <code>AnnotationEditModel</code>.
 *
 * @see org.nomencurator.editor.model.AnnotationEditModel
 * @see org.nomencurator.Annotation
 *
 * @version 	06 Jan 2002
 * @author 	Nozomi `James' Ytow
 */
public interface AnnotationEditor
    extends NamedObjectEditor
{
    /**
     * Gets <code>AnnotationEditModel</code> accompanying with this editor
     *
     * @return AnnotationEditModel accompanying with this editor
     */
    public AnnotationEditModel getAnnotationEditModel();

    /**
     * Sets given <code>model</code> as <code>AnnotationEditModel</code> 
     * accompanying with this editor, or do nothing if it is already there.
     *
     * @param model <code>AnnotationEditModel</code> to be set as model of this editor
     */
    //    public void setAnnotationEditModel(AnnotationEditModel model);

    /**
     * A utility method to get <code>Annotation</code> under edition
     *
     * @return Annotation under edition
     */
    public Annotation getAnnotation();

    /**
     * A utility method to set <code>annotation</code> as
     * target of edition by accompanying <code>AnnotationEditModel</code>
     *
     * @param annotation to be set as target <code>Annotation</code>
     */
    public void setAnnotation(Annotation annotation);
}
