/*
 * AppearanceEditPanel.java:  a Panel implementation of AppearanceEditor
 * for TaxoNote based on Nomencurator data model
 *
 * Copyright (c) 2001, 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: AppearanceEditPanel.java,v 1.42 2002/10/18 04:56:39 nozomi Exp $
 * $Log: AppearanceEditPanel.java,v $
 * Revision 1.42  2002/10/18 04:56:39  nozomi
 * use getDummyModel()
 *
 * Revision 1.41  2002/10/16 22:53:45  nozomi
 * fix newButtonClicked()
 *
 * Revision 1.40  2002/10/15 17:12:20  nozomi
 * tentative fix of null PublicationEditModel
 *
 * Revision 1.39  2002/10/10 20:32:11  nozomi
 * implement own setModel(ObjectEditModel) to propagate model setting to PublicationEditPanel
 *
 * Revision 1.38  2002/10/10 04:59:44  nozomi
 * create new tree on new action
 *
 * Revision 1.37  2002/10/10 04:54:38  nozomi
 * improve copy action
 *
 * Revision 1.36  2002/10/10 04:27:03  nozomi
 * support double-click switch to PublicationEditPanel
 *
 * Revision 1.35  2002/10/08 23:18:42  nozomi
 * fix NameUsage handling in newButtonClicked()
 *
 * Revision 1.34  2002/10/08 21:06:54  nozomi
 * remove unnecessary this designation prior to method name
 *
 * Revision 1.33  2002/10/08 21:05:46  nozomi
 * remove unnecessary this designation prior to method name
 *
 * Revision 1.32  2002/09/26 11:02:38  ryo
 * fix minor bug in createCitationPanel()
 *
 * Revision 1.31  2002/09/17 08:59:20  nozomi
 * minor re-fix of bug
 *
 * Revision 1.30  2002/09/17 08:57:28  nozomi
 * fix minor bug
 *
 * Revision 1.29  2002/09/17 08:46:39  nozomi
 * re-organise initialisation
 *
 * Revision 1.28  2002/09/09 16:48:56  nozomi
 * use summaryTextModel to display publication
 *
 * Revision 1.27  2002/09/07 17:15:12  nozomi
 * fix bug in unsaved object putting methods
 *
 * Revision 1.26  2002/09/07 03:09:27  nozomi
 * use modified flag
 *
 * Revision 1.25  2002/08/21 13:33:08  t.okada
 * When name of appearance is clicked, it corrects so that NameTree may be changed.
 *
 * Revision 1.24  2002/08/20 13:13:59  t.okada
 * add lines column
 *
 * Revision 1.23  2002/07/16 08:19:22  ryo
 * modify initial value of publicationField
 *
 * Revision 1.22  2002/06/23 13:38:42  nozomi
 * aware of FocusController
 *
 * Revision 1.21  2002/05/28 22:07:56  nozomi
 * rcursive creation of relating model
 *
 * Revision 1.20  2002/05/26 21:16:25  nozomi
 * show scrollbar of name list always
 *
 * Revision 1.19  2002/05/26 21:03:46  nozomi
 * modify double click handling
 *
 * Revision 1.18  2002/05/23 04:52:22  nozomi
 * simplify double click handling
 *
 * Revision 1.17  2002/05/17 19:09:32  ryo
 * add popup menu to nameUsageList
 *
 * Revision 1.16  2002/05/17 10:53:25  ryo
 * modify *ButtonClicked()
 *
 * Revision 1.15  2002/05/14 10:02:43  ryo
 * add updateView()
 *
 * Revision 1.14  2002/05/10 13:42:37  ryo
 * add the processing which should be performed when double clicking a list
 *
 * Revision 1.13  2002/05/10 12:10:28  t.okada
 * modify AppearanceEditPanel constructor
 *
 * Revision 1.12  2002/05/08 10:56:53  ryo
 * disable OK, Clear and Cancel button in *EditPanel
 *
 * Revision 1.11  2002/04/20 23:29:27  nozomi
 * improve mutual linkage between EditPanels
 *
 * Revision 1.10  2002/04/16 23:43:51  nozomi
 * apply ryo's modification on another branch
 *
 * Revision 1.9  2002/04/16 03:53:37  nozomi
 * migration to NameUsage from NameRecord
 *
 * Revision 1.8  2002/03/06 00:07:43  nozomi
 * has linakge to a PublicationEditPanel
 *
 * Revision 1.7  2002/03/03 23:48:53  nozomi
 * setModel() synchronized
 *
 * Revision 1.6  2002/02/27 23:55:04  nozomi
 * implements ItemListener
 *
 * Revision 1.5  2002/02/24 18:13:36  nozomi
 * re-implementation of setModel() to be used switching between models
 *
 * Revision 1.4  2002/02/19 06:21:30  nozomi
 * AcronymTextEditor accepts TextEditModel as contructor's paramter
 *
 * Revision 1.3  2002/02/14 01:51:20  okawa
 * modify getTitle() from static to instance method
 *
 * Revision 1.2  2002/02/07 20:59:13  nozomi
 * Use AnnotationListModel
 *
 * Revision 1.1  2002/01/29 06:44:28  nozomi
 * initial import into CVS
 *
 */

package org.nomencurator.editor;

import java.awt.AWTEventMulticaster;
import java.awt.GridBagConstraints;
import java.awt.ItemSelectable;
import java.awt.MenuItem;
import java.awt.PopupMenu;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import java.util.Date;
import java.util.Vector;

import jp.kyasu.awt.BorderedPanel;
import jp.kyasu.awt.Choice;
import jp.kyasu.awt.Frame;
import jp.kyasu.awt.Label;
import jp.kyasu.awt.TextArea;
import jp.kyasu.awt.TextEditModel;
import jp.kyasu.awt.TextField;

import jp.kyasu.editor.DocumentEditor;
import jp.kyasu.editor.Editor;

import jp.kyasu.graphics.VTitledPaneBorder;

import org.nomencurator.Appearance;
import org.nomencurator.Publication;

import org.nomencurator.broker.NamedObjectBroker;

import org.nomencurator.editor.List;
import org.nomencurator.editor.TableList;

import org.nomencurator.editor.model.AnnotationListModel;
import org.nomencurator.editor.model.AppearanceEditModel;
import org.nomencurator.editor.model.NameUsageEditModel;
import org.nomencurator.editor.model.NameUsageListModel;
import org.nomencurator.editor.model.TextListModel;
import org.nomencurator.editor.model.ObjectEditModel;
import org.nomencurator.editor.model.PublicationEditModel;
import org.nomencurator.editor.model.NameUsageNode;
import org.nomencurator.editor.model.NameTreeModel;

/**
 * <code>Panel</code> to modify a <code>Appearance</code> object via
 * <code>AppearanceEditModel</code>.
 *
 * @see org.nomencurator.Appearance
 * @see org.nomencurator.editor.AppearanceEditor
 * @see org.nomencurator.editor.model.AppearanceEditModel
 *
 * @version 	18 Oct 2002
 * @author 	Nozomi `James' Ytow
 */
public class AppearanceEditPanel
    extends NamedObjectEditPanel
    implements AppearanceEditor, ItemSelectable, ItemListener, ActionListener
{
    /** <CODE>AppearanceEditModel</CODE> used by this <CODE>Panel</CODE> */
    protected AppearanceEditModel model;

    /**
     * A <CODE>org.nomencurator.editor.BorderdPanel</CODE> to contain
     * citation editing components
     */
    protected org.nomencurator.editor.BorderedPanel citationPanel;

    /**
     * Title of citation <CODE>Panel</CODE>
     */ 
    protected static String citationPanelTitle = "Citation";

    /**
     * <CODE>TextField</CODE> to show <CODE>Publication</CODE> data
     */
    protected TextField publicationField;

    /**
     * Title of the <CODE>TextField</CODE> for publication
     */
    protected static String publicationFieldTitle = "in:";

    /**
     * <CODE>PublicationEditor</CODE> to edit contents of the <CODE>TextField</CODE> for publication 
     */
    protected PublicationEditPanel publicationEditPanel;

    /**
     * <CODE>TextField</CODE> holding page number
     */
    protected TextField page;

    /**
     * Title of the  <CODE>TextField</CODE> holding page number
     */
    protected static String pageTitle = "page:";

    /**
     * <CODE>TextField</CODE> holding lines number
     */
    protected TextField lines;

    /**
     * Title of the  <CODE>TextField</CODE> holding lines number
     */
    protected static String linesTitle = "lines:";

    /**
     * <CODE>DocumentEditor</CODE> holding apperance
     */
    //    protected DocumentEditor appearance;
    protected TextArea appearance;

    /**
     * Title of <CODE>DocumentEditor</CODE> holding apperance
     */
    protected static String apperarnceTitle = "as:";

    protected static int defaultPublicationFieldWidth = 40;
    protected static int defaultPageFieldWidth = 6;
    protected static int defualtApperanceRows = 5;

    /**
     * <CODE>BorderedPanel</CODE> containing NameUsage list
     */
    protected BorderedPanel nameUsageListPanel;

    /**
     * Title of NameUsage list <CODE>Panel</CODE>
     */
    protected static String nameUsageListPanelTitle = "Names";

    /**
     * NameUsage list
     */
    protected TableList nameUsageList;

    /**
     * Default row number of nameUsageList
     */
    protected int defaultNameUsageListRows = 5;

    /**
     * <CODE>BorderedPanel</CODE> containing Annotation list */
    protected BorderedPanel annotationListPanel;

    /**
     * Title of Annotation list <CODE>Panel</CODE>
     */
    protected static String annotationListPanelTitle= "Related names";

    /**
     * Annotation list
     */
    protected TableList annotationList;

    /**
     * Default row number of Annotation list
     */
    protected int defaultAnnotationListRows = 5;

    /**
     * <CODE>NameUsageEditPanel</CODE> linked to this 
     */
    protected NameUsageEditPanel nameUsageEditPanel;


    /**
     * Listeners of this <CODE>Component</CODE>
     */
    transient protected ItemListener itemListener;

    /**
     * <CODE>ItemEvent</CODE> to be passed to listeners
     */
    protected ItemEvent itemEvent;

	/**
	 * 
	 */
	protected MenuItem createNewTaxonMenuItem;

	/**
	 * 
	 */
    protected static String createNewTaxonTitle = "create new taxon";

    /**
     * Constracts an <CODE>AppearanceEditPanel</CODE> with new <CODE>Appearance</CODE>
     */
    public AppearanceEditPanel()
    {
	this(new Appearance());
    }

    /**
     * Constracts an <CODE>AppearanceEditPanel</CODE> to edit <CODE>appearance</CODE>
     *
     * @param apperance <CODE>Appearance</CODE> to be edited by this <CODE>Panel</CODE>
     */
    public AppearanceEditPanel(Appearance appearance)
    {
	this(new AppearanceEditModel(appearance));
    }
    
    /**
     * Constracts an <CODE>AppearanceEditPanel</CODE> to edit <CODE>model</CODE>
     *
     * @param model <CODE>AppearanceEditModel</CODE> to be used by this <CODE>Panel</CODE>
     */
    public AppearanceEditPanel(AppearanceEditModel model)
    {
	this(model, true);
    }
    
    /**
     * Constracts an <CODE>AppearanceEditPanel</CODE> for <CODE>model</CODE>
     * with <CODE>editble</CODE> status.  
     * The instance may modify <CODE>model</CODE>'s attributes when
     * <CODE>editable</CODE> is true.
     *
     * @param model <CODE>AppearanceEditModel</CODE> to be used by this <CODE>Panel</CODE>
     * @param editable true if this object is allowed to edit <CODE>model</CODE>
     */
    public AppearanceEditPanel(AppearanceEditModel model, boolean editable)
    {
    	
	//this(model, new PublicationEditPanel(model.getPublicationEditModel()), editable);
	this(model, null, editable);
    }

    /**
     * Constracts an <CODE>AppearanceEditPanel</CODE> for <CODE>model</CODE>
     * with <CODE>editble</CODE> status.  
     * The instance may modify <CODE>model</CODE>'s attributes when
     * <CODE>editable</CODE> is true.
     *
     * @param model <CODE>AppearanceEditModel</CODE> to be used by this <CODE>Panel</CODE>
     * @param editable true if this object is allowed to edit <CODE>model</CODE>
     */
    public AppearanceEditPanel(AppearanceEditModel model, 
			       PublicationEditPanel publicationEditPanel,
			       boolean editable)
    {
	super(model, editable);
	//	setPublicationEditPanel(publicationEditPanel);
    }
    
    /**
     * Adds components to this <CODE>Panel</CODE>
     *
     */
    protected void addModelComponents()
    {
	add(citationPanel);
	add(nameUsageListPanel);
	add(annotationListPanel);
    }

    /**
     * Removes components from this <CODE>Panel</CODE>
     *
     */
    protected void removeModelComponents()
    {
	remove(annotationListPanel);
	remove(nameUsageListPanel);
	remove(citationPanel);
    }

    /**
     * Creates components corresponding to the model
     *
     */
    protected void createModelComponents()
    {
	model = (AppearanceEditModel)getModel();
	createCitationPanel();
	createNameUsageListPanel();
	createAnnotationListPanel();
    }

    /**
     * Creates citation components corresponding to the model
     *
     */
    protected void createCitationPanel()
    {
	publicationField = new TextField(getAppearanceEditModel().getPublicationEditModel().getSummaryTextModel(), defaultPublicationFieldWidth);
	publicationField.addMouseListener(this);

	page = new TextField(model.getPageTextModel(), defaultPageFieldWidth);
	page.addTextListener(this);

	lines = new TextField(model.getLinesTextModel(), defaultPageFieldWidth);
	lines.addTextListener(this);

	appearance = new TextArea(model.getAppearanceTextModel(), defualtApperanceRows, defaultPublicationFieldWidth);

	appearance.addTextListener(this);

	citationPanel = new org.nomencurator.editor.BorderedPanel(new VTitledPaneBorder(citationPanelTitle)); 
	citationPanel.add(new Label(publicationFieldTitle), publicationField);
	citationPanel.add(new Label(pageTitle), page);
	citationPanel.add(new Label(linesTitle), lines);
	citationPanel.add(new Label(apperarnceTitle), appearance);
    }
    
    /**
     * Creates NameUsage components corresponding to the model
     *
     */
    protected void createNameUsageListPanel()
    {
	NameUsageListModel nameUsageListModel = (NameUsageListModel)model.getNameUsageList();
	nameUsageList = new TableList(nameUsageListModel,
				       defaultNameUsageListRows,
				       NameUsageListModel.getDefaultTitle());
	nameUsageList.addMouseListener(this);
	nameUsageList.setScrollbarDisplayPolicy(jp.kyasu.awt.ScrollPanel.SCROLLBARS_ALWAYS);
	createNewTaxonMenuItem = new MenuItem(createNewTaxonTitle);
	createNewTaxonMenuItem.addActionListener(this);
	PopupMenu pm = nameUsageList.getPopupMenu();
	pm.addSeparator();
	pm.add(createNewTaxonMenuItem);
	nameUsageList.setPopupMenu(pm);
	nameUsageListPanel = new BorderedPanel(new VTitledPaneBorder(nameUsageListPanelTitle));
	nameUsageListPanel.add(nameUsageList);
    }

    /**
     * Creates Annotation components corresponding to the model
     *
     */
    protected void createAnnotationListPanel()
    {
	AnnotationListModel annotationListModel = model.getAnnotationList();
	annotationList = new TableList(annotationListModel,
				       defaultAnnotationListRows,
				       annotationListModel.getTitle());
	annotationListPanel = new BorderedPanel(new VTitledPaneBorder(annotationListPanelTitle));
	annotationListPanel.add(annotationList);
    }

    /**
     * Sets <CODE>ed</CODE> as <CODE>Editor</CODE> of <CODE>TextComponent</CODE>s
     * to provide <CODE>Text</CODE> handling using GUI.
     *
     * @param ed <CODE>Editor</CODE> to be linked to <CODE>TextComponent</CODE>s
     * of this
     */
    public void setEditor(Editor ed)
    {
	if(focusedEditor == ed)
	    return;

	if(focusedEditor != null) {
	    //	    focusedEditor.unlisten(publicationField);
	    focusedEditor.unlisten(page);
	    focusedEditor.unlisten(appearance);
	}

	focusedEditor = ed;

	if(focusedEditor != null) {
	    //	    focusedEditor.listen(publicationField);
	    focusedEditor.listen(page);
	    focusedEditor.listen(appearance);
	}

    }

    /**
     * Returns <CODE>PublicationEditPanel</CODE>
     * linked to this <CODE>AppearanceEditpanel</CODE>
     * 
     * @return PublicationEditPanel linked to this <CODE>AppearanceEditpanel</CODE>
     */
    public PublicationEditPanel getPublicationEditPanel()
    {
	return publicationEditPanel;
    }

    /**
     * Sets <CODE>panel</CODE> as <CODE>PublicationEditPanel</CODE>
     * linked to this <CODE>AppearanceEditPanel</CODE>
     *
     * @param panel <CODE>PublicationEditPanel</CODE> to be linked to this <CODE>AppearanceEditPanel</CODE>
     *
     */
    public void setPublicationEditPanel(PublicationEditPanel panel) 
    {
	if(publicationEditPanel == panel)
	    return;

	if(publicationEditPanel != null)
	    publicationEditPanel.setAppearanceEditPanel(null);

	publicationEditPanel = panel;
	if(publicationEditPanel != null)
	    publicationEditPanel.setAppearanceEditPanel(this);
    }

    /**
     * Returns <CODE>AppearanceEditModel</CODE> in use
     */ 
    public AppearanceEditModel getAppearanceEditModel()
    {
	return model;
    }

    /**
     * Setups components to use given <CODE>model</CODE>.
     * This method is called from setModel(ObjectEditModel)
     * internally.
     */
    protected void setComponents(ObjectEditModel objectEditModel)
    {
	//?
	/*
	if(objectEditModel == null)
	    objectEditModel = new AppearanceEditModel();
	*/

	model = (AppearanceEditModel)objectEditModel;

	publicationField.setModel(model.getPublicationTextModel());
	page.setModel(model.getPageTextModel());
	lines.setModel(model.getLinesTextModel());
	appearance.setModel(model.getAppearanceTextModel());

	nameUsageList.setModel(model.getNameUsageList());

	annotationList.setModel(model.getAnnotationList());

	if(itemListener != null) {
	    if(itemEvent == null)
		itemEvent = 
		    new ItemEvent(this, 
				  ItemEvent.ITEM_STATE_CHANGED,
				  this,
				  ItemEvent.ITEM_STATE_CHANGED
				  );
	    itemListener.itemStateChanged(itemEvent);
	}
    }

    /**
     * Returns <CODE>Appearance</CODE> handled by this editor
     */
    public Appearance getAppearance()
    {
	return model.getAppearance();
    }

    /**
     * Sets <CODE>Appearance</CODE> to behandled by this editor
     *
     * @param appearance <CODE>Appearance</CODE> to behandled by this editor
     */
    public void setAppearance(Appearance appearance)
    {
	model.setAppearance(appearance);
    }

    /**
     * Creates an empty <CODE>AppearanceEditModel</CODE>.
     */
    protected ObjectEditModel createObjectEditModel()
    {
	if(publicationEditPanel == null) {
	    System.err.println("null panel");
	    return new AppearanceEditModel();
	}
	else {
	    System.err.println("non null panel");
	    return new AppearanceEditModel(publicationEditPanel.getPublicationEditModel());
	}
    }

    /**
     * Returns <CODE>NameUsageEditPanel</CODE> linked to this
     *
     * @return <CODE>NameUsageEditPanel</CODE> linked to this
     */
    public NameUsageEditPanel getNameUsageEditPanel()
    {
	return nameUsageEditPanel;
    }

    /**
     * Sets <CODE>panel</CODE> as <CODE>NameUsageEditPanel</CODE> linked to this
     *
     * @param panel <CODE>NameUsageEditPanel</CODE> to be linked
     */
    public void setNameUsageEditPanel(NameUsageEditPanel panel)
    {
	if(nameUsageEditPanel == panel)
	    return;

	if(nameUsageEditPanel != null)
	    nameUsageEditPanel.setAppearanceEditPanel(null);
	
	nameUsageEditPanel = panel;

	if(nameUsageEditPanel != null)
	    nameUsageEditPanel.setAppearanceEditPanel(this);
    }

    /**
     * Selects a <CODE>NameUsageEditModel</CODE>
     *
     * @param nameModel <CODE>NameUsageEditModel</CODE> to be selected
     */
    public void setNameUsageEditModel(NameUsageEditModel nameModel)
    {

    }
	    
    /**
     * Clears contents
     */
    public void clear()
    {
    }

    /**
     * Returns clone of this object
     */
    public Object clone()
    {
	return new AppearanceEditPanel((AppearanceEditModel)model.clone(), editable);
    }

    // <ItemSelecatable implementation>
    /**
     * Adds the specified item listener to receive item events from this list.
     *
     * @param l the item listener.
     */
    public synchronized void addItemListener(ItemListener l)
    {
	itemListener = AWTEventMulticaster.add(itemListener, l);
	enableEvents(0); // mark newEventsOnly
    }

    /**
     * Removes the specified item listener so that it no longer receives
     * item events from this list.
     * @param l the item listener.
     */
    public synchronized void removeItemListener(ItemListener l)
    {
	itemListener = AWTEventMulticaster.remove(itemListener, l);
    }

    /**
     * Returns the selected items on the list in an array of Objects.
     * @see java.awt.ItemSelectable
     */
    public Object[] getSelectedObjects()
    {
	return new Object[]{model};
    }

    // </ItemSelecatable implementation>

    // <ItemListener implementation>
    /**
     * Invoked when an item's state has been changed.
     * @see java.awt.event.ItemListener
     */
    public void itemStateChanged(ItemEvent e)
    {
	super.itemStateChanged(e);
	if(e.getSource() == nameUsageEditPanel) {
	    NameUsageEditModel nameModel = 
		nameUsageEditPanel.getNameUsageEditModel();
	    AppearanceEditModel appearanceModel = 
		nameModel.getAppearanceEditModel();
	    if(appearanceModel != model)
		setModel(appearanceModel);
	}
    }
    // </ItemListener implementation>

    /**
     * Invoked when the mouse has been clicked on the New button.
     */
    public void newButtonClicked()
    {
	super.newButtonClicked();
	AppearanceEditModel currentEditModel = (AppearanceEditModel)objectEditModel;
	AppearanceEditModel previousEditModel = (AppearanceEditModel)previousModel;
	currentEditModel.setPublicationEditModel(previousEditModel.getPublicationEditModel());
	currentEditModel.getPublicationEditModel().addAppearance(currentEditModel);
	updateView();
	if(nameUsageEditPanel != null) {
	    NameUsageEditModel nameModel = new NameUsageEditModel();
	    nameModel.setAppearanceEditModel(currentEditModel);
	    nameUsageEditPanel.setModel(nameModel);
	    NameUsageNode topNode = new NameUsageNode(nameModel);
	    TaxoNote taxoNote = getPublicationEditPanel().getTaxoNote();
	    taxoNote.createTreeNode(topNode, nameModel);
	    NameTreeModel nameTreeModel = new NameTreeModel(topNode);
	    taxoNote.hierarchy.setModel(nameTreeModel);		
	}
	
    }
    
    /**
     * Invoked when the mouse has been clicked on the Copy button.
     */
    public void copyButtonClicked()
    {
	super.copyButtonClicked();
	AppearanceEditModel currentEditModel = (AppearanceEditModel)objectEditModel;
	AppearanceEditModel previousEditModel = (AppearanceEditModel)previousModel;
	currentEditModel.setPublicationEditModel(previousEditModel.getPublicationEditModel());
	NameUsageEditModel nameModel = 
	    nameUsageEditPanel.getNameUsageEditModel();
	TextListModel list = previousEditModel.getNameUsageList();
	//	if(list.contains(nameModel))
	    list.removeModel(nameModel);
	list = currentEditModel.getNameUsageList();
	list.removeAllModels();
	list.addModel(nameModel);
    }
    
    public void mouseDoubleClicked(MouseEvent e) {
	Object source = e.getSource();
	if (source != nameUsageList &&
	    source != publicationField)
	    return;
	
	model.updateSummary();
	if (source == nameUsageList) {
	    selectNameUsage(isEditable() && 
			    (nameUsageList.getSelectedModel() == nameUsageList.getDummyModel() ||
			     e.getY() >=  nameUsageList.getLastBaseLine()));
	}
	else if(source == publicationField) {
	    getTabbedPane().setSelectedComponent(publicationEditPanel);
	}
    }
	
    public void updateView() {
	getAppearanceEditModel().getPublicationEditModel().updateSummary();
	//	    getAppearanceEditModel().updateList();
    }
    
    /**
     * 
     */
    public void actionPerformed(ActionEvent event) {
	Object source = event.getSource();
	if(source == createNewTaxonMenuItem) {
	    selectNameUsage(true);
	}
    }
    
    /**
     * 
     */
    protected void selectNameUsage() {
	selectNameUsage(false);
    }
    
    /**
     * 
     */
    public void selectNameUsage(boolean forceNewCreate)
    {
	NameUsageEditModel nameUsageEditModel =
	    (NameUsageEditModel) nameUsageList.getSelectedModel();
	NameUsageListModel nameUsageListModel = 
	    (NameUsageListModel) nameUsageList.getModel();
	
	if (nameUsageEditModel == nameUsageList.getDummyModel() ||
	    nameUsageEditModel == null)
	    forceNewCreate = true;
	
	if (forceNewCreate) {
	    // create new taxon.
	    nameUsageList.deselect(nameUsageList.getSelectedIndex());
	    
	    nameUsageEditModel
		= new NameUsageEditModel((AppearanceEditModel) getModel());
	    
	    ((AppearanceEditModel) getModel()).addNameUsageEditModel(nameUsageEditModel);
	    
	    if(nameUsageList.getRows() == nameUsageListModel.getItemCount() + 1) {
		nameUsageList.invalidate();
		nameUsageListModel.enableDummyModel(isEditable());
		nameUsageList.validate();
	    }
	}
	//		nameUsageEditModel.setAppearanceEditModel((AppearanceEditModel) getModel());
	nameUsageEditPanel.setModel(nameUsageEditModel);
	
	NameUsageEditModel nuModel = nameUsageEditModel;
	while(true) {
	    if(nuModel.getHigherModel() == null)
		break;
	    else
		nuModel = nuModel.getHigherModel();
	}
	
	TaxoNote taxoNote = getPublicationEditPanel().getTaxoNote();
	NameUsageNode topNode = new NameUsageNode(nuModel);
	taxoNote.createTreeNode(topNode, nuModel);
	NameTreeModel nameTreeModel = new NameTreeModel(topNode);
	taxoNote.hierarchy.setModel(nameTreeModel);		
	
	//		getTabbedPane().setSelectedIndex(TabbedPane.V_TABINDEX_NAME);
	getTabbedPane().setSelectedComponent(nameUsageEditPanel);
    }
    
    public void putUnsavedObject()
    {
	if(isModified()) {
	    NamedObjectBroker broker = NamedObjectBroker.getInstance();
	    Appearance a = getAppearance();
	    broker.putUnsavedObject(a.getPublication());
	    broker.putUnsavedObjects(a.getNameUsages());
	    broker.putUnsavedObjects(a.getAnnotations());
	}
	super.putUnsavedObject();
    }

    /**
     * Sets given <code>model</code> to be edited by this editor
     * It is part of <code>ObjectEditor</code> interface.
     *
     * @param model <code>ObjectEditModel</code> to be edited
     *
     * @see org.nomencurator.editor.ObjectEditor.setModel()
     */
    public void setModel(ObjectEditModel model)
    {
	super.setModel(model);

	if(publicationEditPanel == null)
	    return;

	PublicationEditModel pem = 
	    getAppearanceEditModel().getPublicationEditModel();
	if(pem == publicationEditPanel.getPublicationEditModel())
	    return;

	Publication p = null;

	if(pem == null) {
	    p = getAppearanceEditModel().getAppearance().getPublication();
	    pem = new PublicationEditModel(p);
	}
	else
	    p = pem.getPublication();

	if(p != 
	   publicationEditPanel.getPublicationEditModel().getNamedObject()/*.getEntity()*/)
	    publicationEditPanel.setModel(pem);
    }

}
