/*
 * AuthorEditor.java:  an interface of AuthorEditor
 * for TaxoNote based on Nomencurator data model
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: AuthorEditor.java,v 1.3 2002/02/24 20:02:36 nozomi Exp $
 * $Log: AuthorEditor.java,v $
 * Revision 1.3  2002/02/24 20:02:36  nozomi
 * modified to use setModel()
 *
 * Revision 1.2  2002/01/29 06:51:03  nozomi
 * Changed from class to interface
 *
 * Revision 1.1.1.1  2002/01/16 12:33:33  ryo
 * initial import into CVS
 */

package org.nomencurator.editor;

import org.nomencurator.Author;

import org.nomencurator.editor.model.AuthorEditModel;

/**
 * Interface for graphical component wrapping
 * <code>AuthorEditModel</code>.
 *
 * @see org.nomencurator.editor.model.AuthorEditModel
 * @see org.nomencurator.Author
 *
 * @version 	24 Feb 2002
 * @author 	Nozomi `James' Ytow
 */
public interface AuthorEditor
    extends NamedObjectEditor
{
    /**
     * Gets <code>AuthorEditModel</code> accompanying with this editor
     *
     * @return AuthorEditModel accompanying with this editor
     */
    public AuthorEditModel getAuthorEditModel();

    /**
     * A utility method to get <code>Author</code> under edition
     *
     * @return Author under edition
     */
    public Author getAuthor();

    /**
     * A utility method to set <code>author</code> as
     * target of edition by accompanying <code>AuthorEditModel</code>
     *
     * @param author to be set as target <code>Author</code>
     */
    public void setAuthor(Author author);
}
