/*
 * AuthorSearchView.java: 
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: AuthorSearchView.java,v 1.2 2002/09/09 16:48:13 nozomi Exp $
 * $Log: AuthorSearchView.java,v $
 * Revision 1.2  2002/09/09 16:48:13  nozomi
 * trial implementation of focus control
 *
 * Revision 1.1  2002/09/08 14:16:29  nozomi
 * support Author search
 *
 */

package org.nomencurator.editor;

import jp.kyasu.awt.Panel;
import jp.kyasu.awt.Button;
import jp.kyasu.awt.Label;
import jp.kyasu.awt.TextField;
import jp.kyasu.awt.TableList;
import jp.kyasu.awt.DefaultTextListModel;


import jp.kyasu.editor.Editor;

import jp.kyasu.util.Sorter;

import java.awt.BorderLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

import org.nomencurator.Author;
import org.nomencurator.Appearance;
import org.nomencurator.NameUsage;
import org.nomencurator.NamedObject;
import org.nomencurator.Publication;

import org.nomencurator.broker.NamedObjectBroker;

import org.nomencurator.editor.NameUsageSearchListModel;

import org.nomencurator.editor.model.AuthorEditModel;

import org.nomencurator.util.Comparer;

import java.util.Vector;
import java.util.Hashtable;
import java.util.Enumeration;

import org.nomencurator.controller.linktable.NameUsageRecorder;
import org.nomencurator.controller.linktable.AppearanceNameUsage;
import org.nomencurator.controller.linktable.PublicationAppearance;
import org.nomencurator.controller.linktable.PublicationAuthor;
import org.nomencurator.controller.linktable.LinkRecord;

public class AuthorSearchView
    extends Panel
    implements TextListener
{
    private TextField authorField;

    protected List result;
    protected Sorter sorter;
    protected Comparer comparer;

    /** <CODE>Editor</CODE> handling <CODE>TextComponent</CODE>s */
    protected Editor focusedEditor;

    /**
     * Constractor
     */
    public AuthorSearchView()
    {
	this(5);
    }

    public AuthorSearchView(int lines)
    {
	this(lines, List.SINGLE_SELECTION);
    }

    public AuthorSearchView(int lines, int model)
    {
        super(new BorderLayout());
        _init(lines, model);
	sorter = new Sorter(new Comparer());
	((Comparer)sorter.getComparer()).setNameUsageListRowCompareMode(comparer.BY_AUTHOR);
    }

    /**
     * Initialaize this panel
     */
    private void _init(int lines, int model)
    {

        authorField = new TextField(20);
        authorField.getModel().addTextListener(this);
	result = new List(new NameUsageSearchListModel(), lines);
	result.setSelectionMode(model);
	//	result.addActionListener(this);
	//	result.addItemListener(this);

	add(authorField, BorderLayout.NORTH);
	add(result, BorderLayout.CENTER);
    }
    
    public void textValueChanged(TextEvent e)
    {
	search(authorField.getText());
    }

    /**
     * @param ItemListener l
     */
    public void addItemListener(ItemListener l) {
        result.addItemListener(l);
    }
    
    /**
     * @param ItemListener l
     */
    public void removeItemListener(ItemListener l) {
        result.removeItemListener(l);
    }
    
    /**
     * @return List table
     */
    public List getList() {
        return result;
    }
    
    /**
     * Search NameUsage information
     */
    public void search(String author)
    {
	NameUsageSearchListModel model = 
	    (NameUsageSearchListModel)result.getModel();
        model.removeAll();
	if(author == null || author.length() == 0)
	    return;
        NamedObjectBroker broker = NamedObjectBroker.getInstance();
	Vector v = broker.getNameUsageList("", author, "");
	Vector unsaved = broker.getAuthorByName(author);
	if(v == null) {
	    if(unsaved == null)
		return;
	    v = new Vector();
	}
	int size = v.size();
	for(int i = 0; i < size; i++) {
	    NameUsageListRow row = (NameUsageListRow)(v.elementAt(i));
	    NameUsage n = (NameUsage)broker.getNamedObject(row.getObjectId());
	    if(n == null)
		continue;
	    Appearance app = (Appearance)broker.getNamedObject(NameUsageRecorder.getInstance().getTo(row.getObjectId()));
	    if(app == null)
		continue;
	    n.setAppearance(app);
	    app.addNameUsage(n);
	    Publication p = (Publication)broker.getNamedObject(PublicationAppearance.getInstance().getFrom(app.getName()));
	    if(p == null)
		continue;
	    p.addAppearance(app);
	    app.setPublication(p);
	    Vector pIDs = PublicationAuthor.getInstance().getToLinkRecords(p.getPersistentID());
	    if(pIDs == null)
		continue;
	    Enumeration e = pIDs.elements();
	    Author a = null;
	    while(e.hasMoreElements()) {
		String aID = ((LinkRecord)e.nextElement()).getTo();
		a = (Author)broker.getNamedObject(aID);
		if(author == null)
		    continue;
		row.setName(a.getFullSurname());
		row.setYear(a.getSurname());
		row.setAuthor(a.getFullname());
		row.setObjectId(a.getName());
	    }

	}
	if(unsaved != null && !unsaved.isEmpty()) {
	    Enumeration e = unsaved.elements();
	    while(e.hasMoreElements()) {
		Author a = (Author)e.nextElement();
		v.addElement(new NameUsageListRow(a.getName(),
						  a.getFullSurname(),
						  a.getFullname(),
						  a.getSurname()));
	    }
	}

        Object[] rawRowList = v.toArray();

	
	sorter.quicksort(rawRowList, 0, rawRowList.length - 1);


	Vector rowList = new Vector();
	int i = 0;
	int length = author.length();
	while(i < rawRowList.length && rowList.size() == 0) {
	    NameUsageListRow row = (NameUsageListRow)rawRowList[i];
	    if((author.equals(row.getAuthor().substring(0, length))) ||
	       (author.equals(row.getName().substring(0, length))) ||
	       (author.equals(row.getYear().substring(0, length))))
		rowList.addElement(row);
	    i++;
	}

	for( ; i < rawRowList.length; i++) {
	    NameUsageListRow row = (NameUsageListRow)rawRowList[i];
	    if((!row.getObjectId().equals(((NameUsageListRow)rowList.lastElement()).getObjectId())) &&
	       ((author.equals(row.getAuthor().substring(0, length))) ||
	       (author.equals(row.getName().substring(0, length))) ||
		(author.equals(row.getYear().substring(0, length)))))
		rowList.addElement(row);
	}


        if (rowList != null && rowList.size() > 0) {
	    String[][] items = new String[rowList.size()][1];
	    for (i = 0; i < rowList.size(); i++) {
		NameUsageListRow row = (NameUsageListRow)rowList.elementAt(i);
		items[i][0] = row.getAuthor();
		model.addOid(row.getObjectId());
	    }
	    model.replaceItems(0, model.getItemCount(), items);
	    result.invalidate();
	    getParent().validate();
        }
    }
    
    /**
     * Get selected objtect ID.
     * @return Object ID
     */
    public String getSelectedOid() {
	String oid = null;
	if (result.getItemCount() > 0) {
	    oid = ((NameUsageSearchListModel)result.getModel()).getOid(result.getSelectedIndex());
	}
	return oid;
    }
    
    /**
     * Sets <CODE>ed</CODE> as <CODE>Editor</CODE> of <CODE>TextComponent</CODE>s
     * to provide <CODE>Text</CODE> handling using GUI.
     *
     * @param ed <CODE>Editor</CODE> to be linked to <CODE>TextComponent</CODE>s
     * of this
     */
    public void setEditor(Editor ed) {
	if (focusedEditor == ed)
	    return;
	if (focusedEditor != null) {
	    focusedEditor.unlisten(authorField);
	}
	focusedEditor = ed;
	if (focusedEditor != null) {
	    focusedEditor.listen(authorField);
	}
    }

    public int getSelectedIndex()
    {
	return result.getSelectedIndex();
    }

    public int[] getSelectedIndexes()
    {
	return result.getSelectedIndexes();
    }

    public Author getAuthor(int index)
    {
	if(index < 0)
	    return null;
	return (Author)NamedObjectBroker.getInstance().getNamedObject(((NameUsageSearchListModel)result.getModel()).getOid(index));
    }

    public Author getSelectedAuthor()
    {
	return getAuthor(result.getSelectedIndex());
    }

    public Vector getSelectedAuthors()
    {
	int[] indices = result.getSelectedIndexes();
	int authorCount = indices.length;

	if(authorCount == 0)
	    return null;

	Vector authors = new Vector(authorCount);
	for(int i = 0; i < authorCount; i++)
	    authors.addElement(getAuthor(indices[i]));

	return authors;
    }

    public AuthorEditModel getAuthorEditModel(int index)
    {
	if(index < 0)
	    return null;

	Author a = getAuthor(index);
	if(a == null)
	    return null;

	NamedObjectBroker broker = NamedObjectBroker.getInstance();

	AuthorEditModel model = 
	    (AuthorEditModel)broker.getModel(a.getName());
	if(model == null) {
	    model = new AuthorEditModel(a);
	    broker.putModel(model);
	}
	return model;
    }

    public AuthorEditModel getSelectedAuthorEditModel()
    {
	return getAuthorEditModel(result.getSelectedIndex());
    }

    public Vector getSelectedAuthorEditModels()
    {
	int[] indices = result.getSelectedIndexes();
	int authorCount = indices.length;

	if(authorCount == 0)
	    return null;

	Vector authors = new Vector(authorCount);
	for(int i = 0; i < authorCount; i++)
	    authors.addElement(getAuthorEditModel(indices[i]));

	return authors;
    }

    public void requestFocus()
    {
	authorField.requestFocus();
    }
    
}
