/*
 * BookSectionEditPanel.java:  an article editor to be used
 * as superclass of PublicationEditor Panel
 * for TaxoNote based on Nomencurator data model
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: BookSectionEditPanel.java,v 1.4 2002/09/03 02:51:47 nozomi Exp $
 * $Log: BookSectionEditPanel.java,v $
 * Revision 1.4  2002/09/03 02:51:47  nozomi
 * use CardLayout to switch editors
 *
 * Revision 1.3  2002/02/24 23:36:19  nozomi
 * Remove unused codes
 *
 * Revision 1.2  2002/02/24 18:13:36  nozomi
 * re-implementation of setModel() to be used switching between models
 *
 * Revision 1.1  2002/02/19 19:27:39  nozomi
 * add BookSectionEditPanel
 *
 */

package org.nomencurator.editor;

import java.awt.GridBagConstraints;

import java.util.Vector;

import jp.kyasu.awt.Label;
import jp.kyasu.awt.List;
import jp.kyasu.awt.TextField;

import jp.kyasu.editor.DocumentEditor;

import jp.kyasu.graphics.TextStyle;
import jp.kyasu.graphics.VTitledPaneBorder;

import org.nomencurator.Publication;

import org.nomencurator.editor.NamedObjectEditPanel;

import org.nomencurator.editor.model.ObjectEditModel;
import org.nomencurator.editor.model.PublicationEditModel;

/**
 * <code>Panel</code> to represent a <code>PublicationEditModel</code>
 *
 * @see org.nomencurator.editor.model.PublicationEditModel
 * @see org.nomencurator.Publication
 *
 * @version 	03 Spe 2002
 * @author 	Nozomi `James' Ytow
 */
public class BookSectionEditPanel
    extends BookEditPanel
{
    /**
     * Title of <code>contentsField</code>
     */
    protected static String containerFieldTitle = "Title";

    /**
     * Title of <code>publisher</code>
     */
    protected static String secondaryAuthorsTitle = "Editors";

    /**
     * <code>BorderedPanel</code> holds book data
     */
    protected BorderedPanel containerPanel;

    /**
     * Title of <code>containerPanel</code>
     */
    protected static String containerPanelTitle = "In";

    /**
     * Creates <code>PublicationEditPanel</code> with specified
     * <code>model</code>, <code>editable</code>, <code>authorEditors</code>
     * <code>appearanceEditors</code>
     */
    public BookSectionEditPanel(PublicationEditModel model)
    {
	super(model, true, false, null, null);
    }

    /**
     * Creates <code>PublicationEditPanel</code> with specified
     * <code>model</code>, <code>editable</code>, <code>authorEditors</code>
     * <code>appearanceEditors</code>
     */
    public BookSectionEditPanel(AbstractPublicationEditPanel panel)
    {
	super(panel.getPublicationEditModel(),
	      panel.isEditable(),
	      panel.isSummaryVisible(),
	      null, null);
    }

    /**
     * Creates <code>PublicationEditPanel</code> with specified
     * <code>model</code>, <code>editable</code>, <code>authorEditors</code>
     * <code>appearanceEditors</code>
     */
    public BookSectionEditPanel(PublicationEditModel model,
			    boolean editable,
			    boolean showSummary,
			    Vector authorEditors,
			    Vector appearanceEditors)
    {
	super(model, editable, showSummary, authorEditors, appearanceEditors);
    }

    /**
     * Creates <code>Component</code>s representing citation information 
     */
    protected void createCitationComponents()
    {
	createAuthorComponents();
	createYearComponent();
	createContentsField();
	createPages();
	createSecondaryAuthorComponents();
	PublicationEditModel container =  model.getContainer();
	if(container == null) {
	    container = new PublicationEditModel();
	    model.setContainer(container);
	}
	createContainerField(container);
	createISXN(container);
	createPublisher(container);
	createPlace(container);
    }

    /**
     * Creates <code>Component</code>s representing container information 
     */
    protected void createContainerComponents()
    {
	createContainerComponents(model.getContainer());
    }

    /**
     * Layouts <code>Component</code>s representing contents title of the publication
     */
    protected void layoutContentsField()
    {
	citationPanel.add(new Label(contentsFieldTitle),
			  contentsField, GridBagConstraints.HORIZONTAL);
	//	layoutPages(pageTitle);
	/*
	pagePanel.add(firstPage);
	pagePanel.add(new Label("-"));
	pagePanel.add(lastPage);
	citationPanel.add(new Label(pageTitle), pagePanel);
	*/
    }

    /**
     * Layouts <code>Component</code>s representing citation information 
     */
    protected void layoutCitationComponents()
    {
	super.layoutCitationComponents();
	layoutBookField();
    }

    /**
     * Layouts <code>Component</code>s representing container title of the publication
     */
    protected void layoutBookField()
    {
	containerPanel =
	    new BorderedPanel(new VTitledPaneBorder(containerPanelTitle));
	containerPanel.add(new Label(secondaryAuthorsTitle), 
			   secondaryAuthors, GridBagConstraints.HORIZONTAL);
	containerPanel.add(new Label(containerFieldTitle), 
			   containerField, GridBagConstraints.HORIZONTAL);
	containerPanel.add(new Label(publisherTitle), 
			   publisher, GridBagConstraints.HORIZONTAL);
	containerPanel.add(new Label(placeTitle), 
			   place, GridBagConstraints.HORIZONTAL);
	containerPanel.add(new Label(isxnTitle), 
			   isxn, GridBagConstraints.HORIZONTAL);
	add(containerPanel);
    }

    /**
     * Layouts <code>Component</code> representing number of container
     */
    protected void layoutNumber()
    {
	//do nothig
    }

    /**
     * Layouts <code>Component</code>s pages
     */
    protected void layoutPages()
    {
	layoutPages(pageTitle);
    }
}
