/*
 * ChoiceDialog.java : 
 *
 * Copyright (c) 2002 Ryo FUJIMOTO
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: ChoiceDialog.java,v 1.1 2002/08/15 13:10:16 ryo Exp $
 * $Log: ChoiceDialog.java,v $
 * Revision 1.1  2002/08/15 13:10:16  ryo
 * initial import into CVS
 *
 */

package org.nomencurator.editor;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.BorderLayout;
import java.awt.Frame;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import jp.kyasu.awt.AWTResources;
import jp.kyasu.awt.Button;
import jp.kyasu.awt.Choice;
import jp.kyasu.awt.Dialog;
import jp.kyasu.awt.Label;
import jp.kyasu.awt.TextField;

public class ChoiceDialog
	extends Dialog
	implements ActionListener {

	protected Label textLabel;
	protected TextField textField;
	protected Panel textPanel;
	protected Button okButton;
	protected Button cancelButton;
	protected Panel buttonPanel;
	protected boolean isOK = false;

	public ChoiceDialog(Choice owner) {
//	public ChoiceDialog(Frame owner) {
		super(getFrame(owner), true);

		textLabel = new Label("enter new item");
		textField = new TextField(10);
		textPanel = new Panel(new FlowLayout(FlowLayout.CENTER));
		textPanel.add(textLabel);
		textPanel.add(textField);

		okButton =
			new Button(
				AWTResources.getResourceString("kfc.dialog.okLabel", "OK"));
		okButton.addActionListener(this);
		cancelButton =
			new Button(AWTResources.getResourceString("cancelLabel", "Cancel"));
		cancelButton.addActionListener(this);
		buttonPanel = new Panel(new FlowLayout(FlowLayout.CENTER));
		buttonPanel.add(okButton);
		buttonPanel.add(cancelButton);

		add(textPanel, BorderLayout.CENTER);
		add(buttonPanel, BorderLayout.SOUTH);
		pack();
	}

	public void show() {
		super.show();
		textField.requestFocus();
	}

	public static Frame getFrame(Component component) {
		while (!(component instanceof Frame))
			component = component.getParent();
		return (Frame) component;
	}

	/**
	 * Invoked when the button has been triggered by the controller.
	 */
	public void actionPerformed(ActionEvent e) {
		Object source = e.getSource();
		hide();
		if (source == okButton) {
			isOK = true;
		} else if (source == cancelButton) {
			isOK = false;
		}
	}

	public String getString() {
		return textField.getRichText().getText().toString();
	}
	
	public boolean isOK() {
		return isOK;
	}

//	public static void main(String[] args) {
//		final Frame f = new Frame();
//		ChoiceDialog d = new ChoiceDialog(f);
//		d.show();
//		System.out.println(d.getString());
//	}

}
