/*
 * ComparatorPane.java: A SplitPanl to compare hierarchies and
 * to show a hisoty of names
 * for TaxoNote, based on Nomencurator data model
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: ComparatorPanel.java,v 1.7 2002/10/09 14:47:38 nozomi Exp $
 * $Log: ComparatorPanel.java,v $
 * Revision 1.7  2002/10/09 14:47:38  nozomi
 * remove debugging message
 *
 * Revision 1.6  2002/09/06 19:33:51  nozomi
 * remove unused prnln
 *
 * Revision 1.5  2002/09/05 05:18:58  nozomi
 * modify GUI replace way as a quick-hack
 *
 * Revision 1.4  2002/09/03 16:52:16  nozomi
 * add close Button
 *
 * Revision 1.3  2002/09/02 16:09:14  nozomi
 * remove debugging codes
 *
 * Revision 1.2  2002/08/28 00:23:39  nozomi
 * use NameHistoryModel
 *
 * Revision 1.1  2002/08/14 07:49:04  nozomi
 * initial import to CVS repository
 *
 */

package org.nomencurator.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;

import java.util.Enumeration;
import java.util.Hashtable;

import jp.kyasu.awt.Button;
import jp.kyasu.awt.Label;
import jp.kyasu.awt.NativePanel;
import jp.kyasu.awt.Panel;
import jp.kyasu.awt.PopupPanel;
import jp.kyasu.awt.TextArea;
//import jp.kyasu.awt.TableList;
import jp.kyasu.awt.ScrollPanel;
import jp.kyasu.awt.SplitPanel;
import jp.kyasu.awt.TabbedPane;

import org.nomencurator.Appearance;
import org.nomencurator.Author;
import org.nomencurator.NameUsage;
import org.nomencurator.Publication;
import org.nomencurator.Rank;

import org.nomencurator.editor.model.NameHistoryModel;
import org.nomencurator.editor.model.NameTreeModel;
import org.nomencurator.editor.model.NameUsageEditModel;
import org.nomencurator.editor.model.NameUsageNode;

/**
 * A <code>jp.kyasu.awt.SplitPanel</code> to compare
 * hierarchies and to show history of names
 * based on subsetting of <code>NameUsage</code>s
 *
 * @version  	09 Oct 2002
 * @author 	Nozomi `James' Ytow
 */
public class ComparatorPanel
    //    extends SplitPanel
	    extends Panel
    implements ActionListener,
	       MouseMotionListener
{
    /** <CODE>Panel</CODE> to contain search components */
    protected SearchView searchPanel;

    /** <CODE>ScrollPanel</CODE> to contain hierarchies */
    protected ScrollPanel hierarchies;

    /** <CODE>SplitPane</CODE> to contain hierarchies */
    protected SplitPanel hierarchySplitPanel;

    /** <CODE>TabbedTable</CODE> to contain name history */
    protected TabbedTable history;

    protected SplitPanel comparisonPanel;

    protected Panel actionPanel;
    protected Button clearButton;
    protected Button closeButton;

    /** <CODE>TaxoNote</CODE> to show detail of selected view */
    TaxoNote taxoNote;

    protected NameHistoryModel model;

    public NativePanel p;

    protected boolean selected;

    /** Constructor */
    public ComparatorPanel()
    {
	//super(SplitPanel.VERTICAL);
	super(new BorderLayout());
	comparisonPanel = new SplitPanel(SplitPanel.VERTICAL);
	//comparisonPanel = this; //!
	taxoNote   = null;
	searchPanel = createSearchPanel();
	searchPanel.setComparator(this);
	hierarchies = createHierarchiesPanel();
	history     = createHistoryPane();
	history.addMouseMotionListener(this);

	comparisonPanel.add(searchPanel);
	comparisonPanel.add(hierarchies);
	comparisonPanel.add(history);
	model = new NameHistoryModel();

	clearButton = new Button("clear");
	clearButton.addActionListener(this);
	closeButton = new Button("close");
	closeButton.addActionListener(this);
	actionPanel = new Panel();
	actionPanel.add(clearButton);
	actionPanel.add(closeButton);

	add(comparisonPanel, BorderLayout.CENTER);
	add(actionPanel, BorderLayout.SOUTH);
	//add(actionPanel);

	//selected = false;
	selected = true;
    }

    protected SearchView createSearchPanel()
    {
	return new SearchView(5);
    }

    protected ScrollPanel createHierarchiesPanel()
    {
	ScrollPanel sp = 
	    new ScrollPanel(ScrollPanel.SCROLLBARS_HORIZONTAL_ONLY,
			    ScrollPanel.SCROLLBARS_AS_NEEDED);
	hierarchySplitPanel =
	    new SplitPanel(SplitPanel.HORIZONTAL);
	sp.add(hierarchySplitPanel);
	return sp;
    }

    protected TabbedTable createHistoryPane()
    {
	return new TabbedTable(TabbedPane.BOTTOM);
    }

    public ScrollPanel getHierarchies()
    {
	return hierarchies;
    }

    public SplitPanel getHierarchiesPanel()
    {
	return hierarchySplitPanel;
    }

    public TabbedTable getHistoryPane()
    {
	return history;
    }

    public void setTaxoNote(TaxoNote note)
    {
	if(taxoNote == note)
	    return;
	taxoNote = note;
    }

    public TaxoNote getTaxoNote()
    {
	return taxoNote;
    }


    public void addHierarchy(TreeTable hierarchy)
    {
	if(hierarchySplitPanel == null) {
	    hierarchies = createHierarchiesPanel();
	    comparisonPanel.add(hierarchies);
	    history     = createHistoryPane();
	    comparisonPanel.add(history);
	}
	Dimension size = null;
	if(isVisible() && history.getTabCount() > 0)
	    size = history.getComponentAt(0).getSize();

	NameTreeModel tree = hierarchy.getNameTreeModel();
	NameTreeModel view = model.getView(tree.getViewName());
	int index = -1;
	if(view != null)
	    index  = model.indexOf(view);
	model.add(tree);
	//	hierarchySplitPanel.invalidate();
	if(index == -1)
	    hierarchySplitPanel.add(hierarchy);
	else {
	    hierarchySplitPanel.remove(index);
	    hierarchy.setModel(model.getView(tree.getViewName()));
	    hierarchySplitPanel.add(hierarchy, index);
	}
	//	hierarchySplitPanel.validate();

	Hashtable histories = model.getHistoryTable();
	//	history.invalidate();
	history.removeAll();

	String title[] = model.getHistoryTitle();
	String[] rankNames = Rank.getRankNames();

	for(int i = 0; i < rankNames.length; i++) {
	    Object[][] historyTable = 
		(Object[][])histories.get(rankNames[i]);
	    if(historyTable == null)
		continue;

	    TableList table = new TableList(8, title);
	    table.setLowerSeparator(Color.gray);
	    table.getModel().replaceItems(0, 0, historyTable);
	    /*
	    if(size != null)
		table.setSize(size);
	    */
	    history.add(rankNames[i], table);
	    table = null;
	}
	history.invalidate();

	history.setSize(history.getPreferredSize());
	invalidate();
	getParent().validate();
    }

    public void removeHierarchy(TreeTable hierarchy)
    {
	hierarchySplitPanel.remove(hierarchy);
    }

    public void removeAll()
    {
	model.clear();
	/*
	hierarchySplitPanel.removeAll();
	history.removeAll();
	*/
	synchronized(this) {
	    comparisonPanel.remove(history);
	    history = null;
	    comparisonPanel.remove(hierarchies);
	    hierarchies = null;
	    hierarchySplitPanel = null;	    
	    invalidate();
	    getParent().validate();
	}
    }

    public void close()
    {
	Component c = this;
	while(!(c instanceof java.awt.Frame) &&
	      c.getParent() != null)
	    c = c.getParent();

	//	((java.awt.Frame)c).dispose();
	c.setVisible(false);
    }

    public void actionPerformed(ActionEvent e)
    {
	Object source = e.getSource();

	if(source == clearButton)
	    removeAll();
	else if(source == closeButton)
	    close();
    }

    public void setSelected(int x, int y)
    {
    }

    public void mouseDragged(MouseEvent event)
    {
	
    }

    public void mouseMoved(MouseEvent event)
    {
	if(selected)
	    showPopup(event.getX(), event.getY());
    }

    public void showPopup(int x, int y)
    {
	PopupPanel popup = new PopupPanel();
	popup.add(new Label("mousr@("+x+ ","+y+")"));
	popup.showPopup(this, x, y);
    }

    static public void main(String args[]) {
	jp.kyasu.awt.Frame f = new jp.kyasu.awt.Frame("Hierarchies/History viewer");
	ComparatorPanel p = new ComparatorPanel();
	createCryptoPhyceae(p);

	f.add(p);
	f.pack();
	f.setVisible(true);
    }

    static NameUsageNode createNode(String rank, 
				    String name, 
				    Publication publication)
    {
	return createNode(rank, name, publication, null);
    }
    
    static NameUsageNode createNode(String rank, 
				    String name, 
				    Publication publication,
				    NameUsageNode parent)
    {
	NameUsage nu = new NameUsage();
	nu.setRank(rank);
	nu.setUsedName(name);
	nu.setAppearance(new Appearance(publication));
	NameUsageNode node = new NameUsageNode(new NameUsageEditModel(nu));
	if(parent != null)
	    parent.add(node);
	return node;
    }

    static void createCryptoPhyceae(ComparatorPanel cp)
    {
	Author pasher = new Author();
	pasher.setSurname("Pascher");
	
	cp.addHierarchy(createPasher_1913(pasher));
	cp.addHierarchy(createPasher_1914(pasher));

	Author oltmanns = new Author();
	pasher.setSurname("Oltmanns");
	cp.addHierarchy(createOltmanns_1922(oltmanns));
    }

    static TreeTable createPasher_1913(Author pasher)
    {
	Publication pasher_1913 = new Publication();
	pasher_1913.setYear("1913");
	pasher_1913.addAuthor(pasher);
	pasher_1913.setAuthorNames(pasher.getSurname());
	
	NameUsageNode cryptophyceae_pasher_1913 = 
	    createNode("class", "Cryptophyceae", pasher_1913);
	NameUsageNode euryptomonodina_pascher_1913 = 
	    createNode("subclass", "Euryptomonodina", pasher_1913, cryptophyceae_pasher_1913);
	euryptomonodina_pascher_1913.getNameUsageEditModel().setAuthorityEditModel(euryptomonodina_pascher_1913.getNameUsageEditModel());
	NameUsageNode cryptomonadales_pasher_1913 = 
	    createNode("order", "Cryptomonadales", pasher_1913, euryptomonodina_pascher_1913);
	NameUsageNode cryptomonadaceae_pasher_1913 = 
	    createNode("family", "Cryptomonadaceae", pasher_1913, cryptomonadales_pasher_1913);
	NameUsageNode  cryptomonadeae_pasher_1913 = 
	    createNode("subfamily", "Cryptomonadeae", pasher_1913, cryptomonadaceae_pasher_1913);
	NameUsageNode  cryptochrysidae_pasher_1913 = 
	    createNode("subfamily", "Cryptochrysidae", pasher_1913, cryptomonadaceae_pasher_1913);
	cryptochrysidae_pasher_1913.getNameUsageEditModel().setAuthorityEditModel(cryptochrysidae_pasher_1913.getNameUsageEditModel());
	NameUsageNode nephroselmidaceae_pasher_1913 = 
	    createNode("family", "Nephroselmidaceae", pasher_1913, cryptomonadales_pasher_1913);
	nephroselmidaceae_pasher_1913.getNameUsageEditModel().setAuthorityEditModel(nephroselmidaceae_pasher_1913.getNameUsageEditModel());
	NameUsageNode phaeocapsina_pascher_1913 = 
	    createNode("subclass", "Phaeocapsina", pasher_1913, cryptophyceae_pasher_1913);
	phaeocapsina_pascher_1913.getNameUsageEditModel().setAuthorityEditModel(phaeocapsina_pascher_1913.getNameUsageEditModel());
	NameUsageNode phaeotamniaceae_pascher_1913 = 
	    createNode("order", "Phaeotamniaceae", pasher_1913, phaeocapsina_pascher_1913);
	phaeotamniaceae_pascher_1913.getNameUsageEditModel().setAuthorityEditModel(phaeotamniaceae_pascher_1913.getNameUsageEditModel());
	NameUsageNode phaeocapsaceae_pascher_1913 = 
	    createNode("order", "Phaeocapsaceae", pasher_1913, phaeocapsina_pascher_1913);
	phaeocapsaceae_pascher_1913.getNameUsageEditModel().setAuthorityEditModel(phaeocapsaceae_pascher_1913.getNameUsageEditModel());
	
	return new TreeTable(cryptophyceae_pasher_1913, 10, "Pascher 1913");
    }

    static TreeTable createPasher_1914(Author pasher)
    {
	Publication pasher_1914 = new Publication();
	pasher_1914.setYear("1914");
	pasher_1914.addAuthor(pasher);
	pasher_1914.setAuthorNames(pasher.getSurname());

	NameUsageNode cryptophyceae_pasher_1914 = 
	    createNode("class", "Cryptophyceae", pasher_1914);

	NameUsageNode cryptomonadales_pasher_1914 = 
	    createNode("order", "Cryptomonadales", pasher_1914, cryptophyceae_pasher_1914);

	NameUsageNode phaeocapsales_pasher_1914 = 
	    createNode("order", "Phaeocapsales", pasher_1914, cryptophyceae_pasher_1914);
	phaeocapsales_pasher_1914.getNameUsageEditModel().setAuthorityEditModel(phaeocapsales_pasher_1914.getNameUsageEditModel());
	NameUsageNode cryptococcales_pasher_1914 = 
	    createNode("order", "Cryptococcales", pasher_1914, cryptophyceae_pasher_1914);
	NameUsageNode cryptotrichales_pasher_1914 = 
	    createNode("order", "Cryptotrichales", pasher_1914, cryptophyceae_pasher_1914);

	return new TreeTable(cryptophyceae_pasher_1914, 10, "Pascher 1914");
    }

    static TreeTable createOltmanns_1922(Author oltmanns)
    {
	Publication oltmanns_1922 = new Publication();
	oltmanns_1922.setYear("1922");
	oltmanns_1922.addAuthor(oltmanns);
	oltmanns_1922.setAuthorNames(oltmanns.getSurname());

	NameUsageNode cryptomonadales_oltmanns_1922 = 
	    createNode("order", "Cryptomonadales", oltmanns_1922);
	NameUsageNode nephroselmidaceae_oltmanns_1922 = 
	    createNode("family", "Nephroselmidaceae", oltmanns_1922, cryptomonadales_oltmanns_1922);
	//	nephroselmidaceae_oltmanns_1922.getNameUsageEditModel().setAuthorityEditModel(nephroselmidaceae_pasher_1913.getNameUsageEditModel());
	NameUsageNode cryptochrysidaceae_oltmanns_1922 = 
	    createNode("family", "Cryptochrysidaceae", oltmanns_1922, cryptomonadales_oltmanns_1922);
	//	cryptochrysidaceae_oltmanns_1922.getNameUsageEditModel().setAuthorityEditModel(cryptochrysidaceae_pasher_1913.getNameUsageEditModel());
	NameUsageNode phaeocapsaceae_oltmanns_1922 = 
	    createNode("family", "Phaeocapsaceae", oltmanns_1922, cryptomonadales_oltmanns_1922);
	//	phaeocapsaceae_oltmanns_1922.getNameUsageEditModel().setAuthorityEditModel(phaeocapsaceae_pasher_1913.getNameUsageEditModel());
	NameUsageNode cryptomonadaceae_oltmanns_1922 = 
	    createNode("family", "Cryptomonadaceae", oltmanns_1922, cryptomonadales_oltmanns_1922);

	return new TreeTable(cryptomonadales_oltmanns_1922, 10, "Oltmanns 1922");
    }



/*


classification( ['West and Fritsch', 1932],
	[ order, 'Cryptomonadales', _, 
	  [ family, 'Nephroselmidaceae', ['Pascher', 1913], [],
	    family, 'Cryptochrysidaceae', ['(Pascher)', 1913], []
	  ],
	  order, 'Phaeocapsales', ['(Pascher)', 1914], [],
	  order, 'Cryptococcales', _, []
	], ['Novarino and Lucas', 1993]).


classification( ['Novarino and Lucas', 1993],
	[ class, 'Cryptophyceae', 
	  ['emend Cavalier-Smith 1989, emend Novarino and Lucas', 1993],
	  [ order, 'Goniomonadales', ['(Cavalier Smith 1989) Novarino and Lucas', 1993],
	    [ family, 'Goniomonadaceae', ['Hill', 1991],
	      [ genus, 'Goniomonas', ['Stein', 1878], []
	      ]
	    ],
	    order, 'Pyrenomonadales', ['Novarino and Lucas', 1993],
	    [ family, 'Pyrenomonadaceae', ['Novarino and Lucas', 1993],
	      [ genus, 'Pyrenomonas', ['Santore', 1984], [],
	        genus, 'Rhinomonas', ['Hill and Wetherbee', 1988], []
	      ]
	    ],
	    order, 'Cryptomonadales', ['Novarino and Lucas', 1993],
	    [ family, 'Cryptomonadaceae', ['sensu Butcher', 1967],
	      [ genus, 'Chilomonas', ['Ehrenberg', 1831], [],
		genus, 'Chroomonas', ['Hansgirg', 1885], [],
		genus, 'Cryptomonas', ['Ehrenberg', 1831], [],
		genus, 'Plagioselmis', ['Butcher', 1967], [],
		genus, 'Proteomonas', ['Hill and Wetherbee', 1986], []
	      ],
	      family, 'Hemiselmidaceae', ['Butcher', 1967],
	      [ genus, 'Hemiselmis', ['Parke', 1949],
		[ subgenus, 'Hemiselmis', ['Butcher', 1967], [],
		  subgenus, 'Plagiomonas', ['Butcher', 1967], []
		]
	      ]
	    ]
	  ]
	], ['Novarino and Lucas', 1993]).


classification( ['Novarino and Lucas', 1995],
	[ class, 'Cryptomonadea', 
	  ['emend Cavalier-Smith 1989, emend Novarino and Lucas', 1993],
	  [ order, 'Goniomonadida', 
	    ['(Cavalier-Smith 1989) Novarino and Lucas', 1993],
	    [ family, 'Goniomonadidae', ['Hill', 1991],
	      [ genus, 'Goniomonas', ['Stein', 1878], []
	      ]
	    ],
	    order, 'Pyrenomonadida', ['Novarino and Lucas', 1993],
	    [ family, 'Pyrenomonadidae', ['Novarino and Lucas', 1993],
	      [ genus, 'Pyrenomonas', ['Santore', 1984], [],
	        genus, 'Rhinomonas', ['Hill and Wetherbee', 1988], []
	      ]
	    ],
	    order, 'Cryptomonadida', ['Novarino and Lucas', 1993],
	    [ family, 'Cryptomonadidae', ['Stein', 1878],
	      [ genus, 'Chilomonas', ['Ehrenberg', 1831], [],
		genus, 'Chroomonas', ['Hansgirg', 1885], [],
		genus, 'Cryptomonas', ['Ehrenberg', 1831], [],
		genus, 'Plagioselmis', 
		['Butcher, 1967 emend Novarino, Lucas and Morrall', 1994], [],
		genus, 'Proteomonas', ['Hill and Wetherbee', 1986], []
	      ],
	      family, 'Hemiselmidae', ['Butcher', 1967],
	      [ genus, 'Hemiselmis', ['Parke', 1949],
		[ subgenus, 'Hemiselmis', ['Parke', 1949], [],
		  subgenus, 'Plagiomonas', ['Butcher', 1967], []
		]
	      ]
	    ]
	  ]
	], ['Novarino and Lucas', 1995]).

classification( ['Butcher', 1967],
	[ family, 'Hilleacea', ['Butcher', 1967],
	  [ genus, 'Hillea', ['Schiller', 1925],
	    [ species, 'Hillea marina', ['Butcher', 1962], [],
	      species, 'Hillea fusiformis', ['(Schiller)', 1913], [],
	      species, 'Hillea daucoides', ['(Conrad and Kufferath)', 1954], [],
	      species, 'Hillea caerulea', ['(Schiller)', 1925], [],
	      species, 'Hillea phaselos', ['(Conrad and Kufferath)', 1954], [],
	      species, 'Hillea cyanea', ['(Lackey)', 1932], [],
	      species, 'Hillea minuscula', ['(Conrad and Kufferath)', 1954], [],
	      species, 'Hillea fusulina', ['(Conrad and Kufferath)', 1954], [],
	      species, 'Hillea serpens', ['(Conrad and Kufferath)', 1954], [],
	      species, 'Hillea semilunaris', ['(Conrad and Kufferath)', 1954], [],
	      species, 'Hillea akrobeles', ['(Conrad and Kufferath)', 1954], []
	    ]
	  ],
	  family, 'Hemiselmidaceae', ['Butcher', 1967],
	  [ genus, 'Protochrysis', ['Pascher', 1911],
	    [ species, 'Protochrysis phaeophycearum', ['Pascher', 1911], [],
	      species, 'Protochrysis vinosa', ['Conrad', 1939], []
	    ],
	    genus, 'Hemiselmis', ['Parke', 1949],
	    [ subgenus, 'Hemiselmis', ['Butcher', 1967],
	      [ species, 'Hemiselmis rufescens', ['Parke', 1949], [],
		species, 'Hemiselmis amylifera', ['Butcher', 1967], [],
		species, 'Hemiselmis brunnescens', ['Butcher', 1967], [],
		species, 'Hemiselmis cyclopea', ['Butcher', 1967], [],
		species, 'Hemiselmis oculata', ['Butcher', 1967], []
	      ],
	      subgenus, 'Plagiomonas', ['Butcher', 1967],
	      [ species, 'Hemiselmis rotunda', ['Butcher', 1967], [],
		species, 'Hemiselmis simplex', ['Butcher', 1967], [],
		species, 'Hemiselmis anomela', ['Butcher', 1967], [],
		species, 'Hemiselmis virescens', ['Droop', 1955], []
	      ]
	    ]  
	  ],
	  family, 'Cryptomondaceae', _,
	  [ genus, 'Plagioselmis', ['Butcher', 1967],
	    [ species, 'Plagioselmis prolonga', ['Butcher', 1967], [],
	      species, 'Plagioselmis punctata', ['Butcher', 1967], []
	    ],
	    genus, 'Isoselmis', ['Butcher', 1967],
	    [ species, 'Isoselmis obconica', ['Butcher', 1967], []
	    ],
	    genus, 'Chroomonas', ['Hansgirg', 1885],
	    [ subgenus, 'Chroomonas', ['Butcher', 1967],
	      [ species, 'Chroomonas baltica', ['(Buttner)', 1911], [],
		species, 'Chroomonas vectensis', ['Carter', 1937], [],
	        species, 'Chroomonas extensa', ['Butcher', 1967], [],
	        species, 'Chroomonas monococca', ['Butcher', 1967], [],
	        species, 'Chroomonas virescens', ['(Butcher)', 1952], [],
	        species, 'Chroomonas diplococca', ['Butcher', 1967], [],
	        species, 'Chroomonas dispersa', ['Butcher', 1967], [],
	        species, 'Chroomonas plurococca', ['Butcher', 1967], [],
	        species, 'Chroomonas mesostigmatica', ['Butcher', 1967], [],
	        species, 'Chroomonas collegionis', ['Butcher', 1967], [],
	        species, 'Chroomonas placoidea', ['Butcher', 1967], []
	      ],
	      subgenus, 'Cryptochrysis', ['(Pascher)', 1911],
	      [ species, 'Chroomonas commutata', ['(Pascher)', 1911], [],
	        species, 'Chroomonas fulva', ['(Butcher)', 1952], [],
	        species, 'Chroomonas lateralis', ['(Butcher)', 1952], [],
	        species, 'Chroomonas fragarioides', ['Butcher', 1967], [],
	        species, 'Chroomonas nana', ['Butcher', 1967], [],
	        species, 'Chroomonas amphioxeia', ['(Conrad)', 1939], [],
	        species, 'Chroomonas esopus', ['(Conrad and Kufferath)', 1954], [],
	        species, 'Chroomonas pseudocaudata', ['(Conrad and Kufferath)', 1954], [],
	        species, 'Chroomonas heteromorpha', ['Butcher', 1967], [],
	        species, 'Chroomonas falcata', ['Butcher', 1967], [],
	        species, 'Chroomonas atrorosea', ['Butcher', 1967], [],
	        species, 'Chroomonas salina', ['(Wislouch)', 1924], 
		[ form, 'Chroomonas salina adolescens', ['Butcher', 1967], [],
		  form, 'Chroomonas salina oculus-bovis', ['Butcher', 1967], [],
		  form, 'Chroomonas salina refracta', ['Butcher', 1967], [],
		  form, 'Chroomonas salina eroticon', ['Butcher', 1967], [],
		  form, 'Chroomonas salina leucofera', ['Butcher', 1967], [],
		  form, 'Chroomonas salina granulata', ['Butcher', 1967], [],
		  form, 'Chroomonas salina carterae', ['Butcher', 1967], [],
		  form, 'Chroomonas salina salina', ['(Wislouch)', 1924], []
		]
	      ]
	    ],
	    genus, 'Cyanomonas', ['Oltmans', 1904],
	    [ species, 'Cyanomonas americana', ['(Davis)', 1894], []
	    ],
	    genus, 'Cryptomonas', ['Ehrenberg', 1831],
	    [ subgenus, 'Cryptomonas', ['Butcher', 1967],
	      [ species, 'Cryptomonas curvata', ['(Ehrenberg)', 1832], [],
		species, 'Cryptomonas ovata', ['Ehrenberg', 1832], [],
		species, 'Cryptomonas major', ['Butcher', 1967], [],
		species, 'Cryptomonas profunda', ['Butcher', 1967], [],
		species, 'Cryptomonas acuta', ['Butcher', 1952], [],
		species, 'Cryptomonas prora', ['Conrad and Kufferath', 1954], [],
		species, 'Cryptomonas rhynchophora', ['(Conrad)', 1939], [],
		species, 'Cryptomonas stigmatica', ['Wislouch', 1924], [],
		species, 'Cryptomonas suberosa', ['Butcher', 1967], [],
		species, 'Cryptomonas lilloensis', ['Conrad and Kufferath', 1954], [],
		species, 'Cryptomonas chrysoidea', ['Butcher', 1967], [],
		species, 'Cryptomonas irregularis', ['Butcher', 1967], [],
		species, 'Cryptomonas erosa', ['Ehrenberg', 1832], [],
		species, 'Cryptomonas baltica', ['(Karsten)', 1898], [],
		species, 'Cryptomonas diplastida', ['Butcher', 1967], [],
		species, 'Cryptomonas pseudobaltica', ['Butcher', 1967], [],
		species, 'Cryptomonas maculata', ['Butcher', 1967], [],
		species, 'Cryptomonas marssonnii', ['Skuja', 1948], [],
		species, 'Cryptomonas abbreviata', ['Butcher', 1967], [],
		species, 'Cryptomonas appendiculata', ['Butcher', 1967], []
	      ],
	      subgenus, 'Caerulomonas', ['Butcher', 1967],
	      [ species, 'Cryptomonas magnifica', ['Butcher', 1967], [],
		species, 'Cryptomonas synechiea', ['Skuja', 1939], [],
		species, 'Cryptomonas cyanomagna', ['Butcher', 1967], []
	      ]
	    ],
	    genus, 'Chilomonas', ['Ehrenberg', 1831],
	    [ species, 'Chilomonas paramecium', ['Ehrenberg', 1831], []
	    ],
	    genus, 'Leucocryptos', ['Butcher', 1967],
	    [ species, 'Leucocryptos marina', ['(Braarud)', 1935], []
	    ]
	  ]
	], ['Butcher', 1967]).


% Hill (1991a)

classification( ['Hill', '1991a'],
	[ genus, 'Campylomonas', ['Hill', 1991], 
	  [ species, 'Campylomonas reflexa', ['(Skuja)', 1939], []
	  ],
	  genus, 'Teleaulax', ['Hill', 1991],
	  [ species, 'Teleaulax acuta', ['(Butcher)', 1952], [],
	    species, 'Teleaulax merimbula', ['Hill', 1991], []
	  ],
	  genus, 'Geminigera', ['Hill', 1991],
	  [ species, 'Geminigera cryophila', ['(Taylor and Lee)', 1971], []
 	  ],
	  genus, 'Storeatula', ['Hill', 1991],
	  [ species, 'Storeatula major', ['Hill', 1991], []
	  ],
	  genus, 'Rhodomonas', _,
	  [ species, 'Rhodomonas stigmatica', ['(Wislouch)', 1924], []
	  ]
	],
	['Zoo. Record', 1992]).

% Hill (1991b)

classification( ['Hill', '1991b'],
	[ genus, 'Komma', ['Hill', 1991],
	  [ species, 'Komma caudata', ['(Geitler)', 1924], []
	  ],
	  genus, 'Chroomonas', _, 
	  [ species, 'Chroomonas americana', ['(Davis)', 1894], []
	  ],
	  genus, 'Falcomonas', ['Hill', 1991],
	  [ species, 'Falcomonas daucoides', ['(Conrad and Kufferath)', 1954],[]
	  ]
	],
	['Zoo. Record', 1992]).

% Hill (1991c)

classification( ['Hill', '1991c'],
	[ family, 'Goniomonadidae', ['Hill', 1991],
	  [ genus, 'Goniomonas', ['Stein', 1878], []
	  ]
	],
	['Zoo. Record', 1992]).

% Hill and Wetherbee (1989)

classification( ['Hill and Wetherbee', 1989],
	[ genus, 'Rhodomonas', ['Karsten', 1898],
	  [ species, 'Rhodomonas atrorosea', ['(Butcher)', 1967], [],
	    species, 'Rhodomonas falcata', ['(Butcher)', 1967], [],
	    species, 'Rhodomonas atrorosea', ['(Butcher)', 1967], [],
	    species, 'Rhodomonas duplex', ['Hill and Wetherbee', 1989], []
	  ]
	],
	['Zoo. Record', 1990]).

% Hill and Wetherbee (1990)
classification( ['Hill and Wetherbee', 1990],
	[ genus, 'Guillardia', ['Hill and Wetherbee', 1990],
	  [ species, 'Guillardia theta', ['Hill and Wetherbee', 1990], []
	  ],
	  family, 'Cryptomonadaceae', _,
	  [ genus, 'Proteomonas', ['Hill and Wetherbee', 1990],
	    [ species, 'Proteomonas sulcata', ['Hill and Wetherbee', 1990], []
	    ]
	  ]
	],
	['Zoo. Record', 1991]).

% Novarino (1991)

classification( ['Novarino', 1991],
	[ genus, 'Proteomonas', _,
	  [ species, 'Proteomonas pseudobaltica', ['Butcher', 1967],
	    [ variety, 'Proteomonas pseudobaltica leonardiana', 
	      ['Novarino', 1991], []
	    ]
	  ],
	  genus, 'Pyrenomonas', _,
	  [ species, 'Pyrenomonas sauna', _,
	    [ variety, 'Pyrenomonas sauna curvata', ['Novorino', 1991], []
	    ]
	  ],
	  genus, 'Rhinomonas', _,
	  [ species, 'Rhinomonas reticulata', _,
	    [ variety, 'Rhinomonas reticulata atrorosea',
	      ['(Butcher in Hill and Wetherbee)', 1989], [],
	      variety, 'Rhinomonas reticulata compresses', ['Novarino', 1991],[]
	    ]
	  ]
	],
	['Novarino', 1991]).

% Ettl (1965)
classification( ['Ettl', 1965],
	[ genus, 'Cryptomonas', _,
	  [ species, 'Cryptomonas pseudolobata', ['Ettl', 1965], [],
	    species, 'Cryptomonas skujae', ['Ettl', 1965], []
	  ]
	],
	['Zoo. Record', 1967]).

% Larsen and Patterson (1990)
classification( ['Larsen and Patterson', 1990],
	[ genus, 'Goniomonas', _,
	  [ species, 'Goniomonas amphinema', ['Larsen and Patterson', 1990], [],
	    species, 'Goniomonas pacifica', ['Larsen and Patterson', 1990], []
	  ],
	  genus, 'Platychilomonas', ['Larsen and Patterson', 1990],
	  [ species, 'Platychilomonas psammobia', 
	    ['Larsen and Patterson', 1990], []
	  ]
	],
	['Zoo. Record', 1991]).

% Vors (1992)
classification( ['Vors', 1992],
	[ family, 'Kathablepharidae', ['Vors', 1992],
	  [ genus, 'Kathablepharis', ['Skuja', 1939],
	    [ species, 'Kathablepharis hyalurus', _, [],
	      species, 'Kathablepharis ovalis', _, []
	    ],
	    genus, 'Leucocryptos', ['Butcher', 1967],
	    [ species, 'Leucocryptos remigera', ['Vors', 1992], []
	    ],
	    genus, 'Platychilomonas', _, []
	  ]
	],
	['Zoo. Record', 1993]).


 */
}
