/*
 * ConnectionSettingDialog.java: 
 *
 * Copyright (c) 2002 Ryo FUJIMOTO
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: ConnectionSettingDialog.java,v 1.4 2002/10/10 19:47:52 nozomi Exp $
 * $Log: ConnectionSettingDialog.java,v $
 * Revision 1.4  2002/10/10 19:47:52  nozomi
 * add DiGIR button
 *
 * Revision 1.3  2002/09/24 01:28:35  nozomi
 * use JDK1.2 methods if available
 *
 * Revision 1.2  2002/07/16 07:08:44  ryo
 * modify connection setting panel
 *
 * Revision 1.1  2002/07/12 16:56:18  ryo
 * initial import into CVS, add connection setting logic
 *
 */

package org.nomencurator.editor;

import jp.kyasu.awt.Button;
import jp.kyasu.awt.Choice;
import jp.kyasu.awt.Dialog;
import jp.kyasu.awt.Panel;
import jp.kyasu.awt.SplitPanel;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
//import java.awt.Choice;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;

import org.nomencurator.editor.model.ConnectionEditModel;

public class ConnectionSettingDialog
extends Dialog
implements ActionListener, ItemListener {

	/** <CODE>Choice</CODE> of connection type */
	protected Choice connectionSettingTypeChooser;

	/** <CODE>Label</CODE> string for type of connection */
	protected static String connectionSettingTypeSelectorTitle = "connection type:";

	/** */
	protected AbstractConnectionSettingPanel[] connectionSettingPanel;

	/** */
	protected AbstractConnectionSettingPanel selectedConnectionSettingPanel;

	/** */
	protected Panel mainPanel;

	/** default <CODE>Dialog</CODE> title string */
	protected static String defaultDialogTitle = "connection setting dialog";

	/** ok button */
	protected Button okButton;

	/** cancel button */
	protected Button cancelButton;

	/** <CODE>Label</CODE> string for ok button */
	protected static String okButtonTitle = "Ok";

	/** <CODE>Label</CODE> string for cancel button */
	protected static String cancelButtonTitle = "Cancel";

	/** */
	protected boolean isOK = false;

	/**
	 * Constructor.
	 */
	public ConnectionSettingDialog(Frame frame) {
		this(frame, defaultDialogTitle, true);
	}

	/**
	 * Constructor.
	 */
	public ConnectionSettingDialog(Frame frame, ConnectionEditModel model) {
		this(frame, defaultDialogTitle, true);
		setModel(model);
	}
	
	/**
	 * Constructor.
	 */
	public ConnectionSettingDialog(Frame frame, String title, boolean modal) {
		super(frame, title, modal);
		initialize();
	}

	/**
	 * Initialize this dialog
	 */
	protected void initialize() {
		enableEvents(AWTEvent.WINDOW_EVENT_MASK);
		// create chooser panel
		Panel chooserPanel = new Panel();
		connectionSettingTypeChooser = new Choice();
		String[] ctype = ConnectionEditModel.getConnectionTypeStrings();
		for (int i=0; i<ctype.length; i++)
			connectionSettingTypeChooser.addItem(ctype[i]);
		connectionSettingTypeChooser.addItemListener(this);
		chooserPanel.add(connectionSettingTypeSelectorTitle, connectionSettingTypeChooser);
		// create connection setting panel
		connectionSettingPanel = new AbstractConnectionSettingPanel[ConnectionEditModel.TYPE_MAX];
		connectionSettingPanel[ConnectionEditModel.TYPE_JDBC] = new JdbcConnectionSettingPanel(null);
		connectionSettingPanel[ConnectionEditModel.TYPE_HTTP] = new HttpConnectionSettingPanel(null);
		connectionSettingPanel[ConnectionEditModel.TYPE_LOCAL] = new LocalConnectionSettingPanel(null);
		connectionSettingPanel[ConnectionEditModel.TYPE_DIGIR] = new HttpConnectionSettingPanel(null);
		selectedConnectionSettingPanel = connectionSettingPanel[0];
		// create button panel
		Panel buttonPanel = new Panel();
		okButton = new Button(okButtonTitle);
		cancelButton = new Button(cancelButtonTitle);
		okButton.addActionListener(this);
		cancelButton.addActionListener(this);
		buttonPanel.add(okButton);
		buttonPanel.add(cancelButton);
		// add to main panel
		mainPanel = new Panel();
		mainPanel.setLayout(new BorderLayout());
	    mainPanel.add(chooserPanel, BorderLayout.NORTH);
	    mainPanel.add(selectedConnectionSettingPanel, BorderLayout.CENTER);
	    mainPanel.add(buttonPanel, BorderLayout.SOUTH);
	    add(mainPanel);
		pack();
	}

	/**
	 * Set model.
	 * @param c model
	 */
	public void setModel(ConnectionEditModel model) {
		int type = model.getType();
		if (type == -1)
			type = ConnectionEditModel.TYPE_JDBC;
		connectionSettingTypeChooser.select(type);
		changePanel(model);
	}

	/**
	 * Get model.
	 * @return model
	 */
	public ConnectionEditModel getModel() {
		ConnectionEditModel c = null;
		if (isOK) {
			c = selectedConnectionSettingPanel.getModel();
			c.setType(connectionSettingTypeChooser.getSelectedIndex());
		}
		return c;
	}

	/**
	 * Invoked when an action occurs.
	 * @see java.awt.event.ActionListener
	 */
	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == cancelButton) {
			isOK = false;
		} else if (e.getSource() == okButton) {
			isOK = true;
		}
		this.dispose();
	}

	/**
	 * 
	 */
	public boolean isOK() {
		return isOK;
	}

	/**
	 * Set selected data when window closing button is pressed.
	 * @param WindowEvent e
	 */
	protected void processWindowEvent(WindowEvent e) {
		super.processWindowEvent(e);
		if (e.getID() == WindowEvent.WINDOW_CLOSING) {
			this.dispose();
		}
	}

	/**
	 * 
	 */
	public void itemStateChanged(ItemEvent e) {
		ConnectionEditModel model = selectedConnectionSettingPanel.getModel();
		changePanel(model);
	}
	
	/**
	 * Change panel
	 * @param model model
	 */
	protected void changePanel(ConnectionEditModel model) {
		mainPanel.invalidate();
		Graphics g = selectedConnectionSettingPanel.getGraphics();
		Dimension d = selectedConnectionSettingPanel.getSize();
		g.setColor(getBackground());
		g.fillRect(0, 0, d.width, d.height);
		g.setColor(getForeground());
		mainPanel.remove(selectedConnectionSettingPanel);
		int i = connectionSettingTypeChooser.getSelectedIndex();
		selectedConnectionSettingPanel = connectionSettingPanel[i];
		mainPanel.add(selectedConnectionSettingPanel, BorderLayout.CENTER);
		selectedConnectionSettingPanel.setModel(model);
		selectedConnectionSettingPanel.repaint();
		mainPanel.validate();
	}

	public static void main(String[] args) {
		Frame frame = new Frame();
		ConnectionSettingDialog dialog = new ConnectionSettingDialog(frame);
		dialog.show();
	}

}
