/*
 * AnnotationDialog.java: 
 *
 * Copyright (c) 2001, 2002 t.okada
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: CopyrightDialog.java,v 1.1 2002/09/02 13:29:13 t.okada Exp $
 * $Log: CopyrightDialog.java,v $
 * Revision 1.1  2002/09/02 13:29:13  t.okada
 * add copyright dialog
 *
  *
 */

package org.nomencurator.editor;

import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.io.BufferedReader;
import java.io.InputStreamReader;

import jp.kyasu.awt.Button;
import jp.kyasu.awt.Dialog;
import jp.kyasu.awt.Panel;

/**
 * "Annotation" Master dialog for adding to the master
 *
 * @version 21 Aug 2002
 * @author 	t.okada
 * @author 	Nozomi `James' Ytow
 */
public class CopyrightDialog
extends Dialog
implements ActionListener {

	private Frame _ownerFrame;
	private Button _okButton;
	private TextArea textArea;
	private GridBagLayout _gridBagLayout = new GridBagLayout();
	private GridBagConstraints c = new GridBagConstraints();
	private boolean _isOK = false;

	static public final String L_OK = "Ok";
	static public final String L_COPYRIGHT = "Copyright";

	private String copyright = new String();
	
	/**
	 * Constructor.
	 */
	public CopyrightDialog(Frame frame) {
		this(frame, L_COPYRIGHT, true);
	}
	
	/**
	 * Constructor.
	 */
	public CopyrightDialog(Frame frame, String title, boolean modal) {
		super(frame, title, modal);
		
		try {
			URL url = TaxoNote.class.getResource("/Copyrights/Copyrights.txt");

			BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
			String line;
			while ((line=reader.readLine()) != null) {
				copyright += line + "\n";
			}
		}
		catch (Exception ex) {
			ex.printStackTrace(System.err);
		}
		
		_ownerFrame = frame;
		_init();
	}

	/**
	 * Initialize this panel
	 */
	private void _init() {
		GridBagLayout gridbag = new GridBagLayout();
		GridBagConstraints constraints = new GridBagConstraints();
		setLayout(gridbag);

		constraints.weighty = 1;
		constraints.fill = GridBagConstraints.BOTH;
		
		setTitle(L_COPYRIGHT);
	
		textArea = new TextArea(copyright, 15, 65);
		textArea.setEditable(false);

		constraints.insets = new Insets(10,10,0,10);
		constraints.gridwidth = GridBagConstraints.REMAINDER;
		gridbag.setConstraints(textArea, constraints);
		add(textArea);

		Panel buttonPanel = new Panel();
		_okButton = new Button(L_OK);
		_okButton.addActionListener(this);
		
		buttonPanel.add(_okButton);
		
		constraints.gridwidth = GridBagConstraints.REMAINDER;
		gridbag.setConstraints(buttonPanel, constraints);
		add(buttonPanel);

		pack();
	}

	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == _okButton) {
			_isOK = true;
		}
		this.dispose();
	}

	/**
	 * 
	 */
	public boolean isOK() {
		return _isOK;
	}

}
