/*
 * EditAdaptor.java:  controlling TextComponents
 * for TaxoNote, based on Nomencurator data model
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: EditAdaptor.java,v 1.2 2002/10/08 00:35:38 nozomi Exp $
 * $Log: EditAdaptor.java,v $
 * Revision 1.2  2002/10/08 00:35:38  nozomi
 * add HTML relating buttons
 *
 * Revision 1.1  2002/10/07 14:33:54  nozomi
 * EditAdatpor customised for TaxoNote
 *
 */

package org.nomencurator.editor;

import java.awt.Component;

import jp.kyasu.awt.ToolBar;

/**
 * An <CODE>jp.kyasu.editor.EditAdaptor</CODE> customised for <CODE>TaxoNote</CODE>
 *
 * @version 08 Oct 2002
 * @author 	Nozomi `James' Ytow
 */
public class EditAdaptor
    extends jp.kyasu.editor.EditAdaptor
{
    public EditAdaptor()
    {
	super(TEXT_EDITOR);
    }

    /**
     * Creates a <CODE>ToolBar</CODE> to be used by this <CODE>Editor</CODE>.
     * The <CODE>ToolBar</CODE> is a graphical representaion of internal state of
     * the <CODE>TextComponent</CODE> under edition.  Subclasses of this class
     * may override this method.
     *
     * @return ToolBar newly created.
     */
    protected ToolBar createToolBar(int dummy)
    {
	return new ToolBar(new Component[][][]{{
	    createFileComponents(this, this),
	    createPrintComponents(this),
	    createEditComponents(),
	    createFindComponents(false),
	    createFontComponents(),
	    createFontDecorationComponents(),
	    createFontSizeComponents(),
	    createScriptComponents(),
	    createCharTableComponents(),
	    createAlignmentComponents(),
	    createListComponents(),
	    //createInsertComponents()
	    createHTMLInsertComponents()
	}});
    }
}
