/*
 * EditedBookEditPanel.java:  an article editor to be used
 * as superclass of PublicationEditor Panel
 * for TaxoNote based on Nomencurator data model
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: EditedBookEditPanel.java,v 1.1 2002/02/18 23:06:51 nozomi Exp $
 * $Log: EditedBookEditPanel.java,v $
 * Revision 1.1  2002/02/18 23:06:51  nozomi
 * initial import to CVS
 *
 * Revision 1.1  2002/02/17 21:08:55  nozomi
 * initial import to CVS
 *
 */

package org.nomencurator.editor;

import java.awt.GridBagConstraints;

import java.util.Vector;

import jp.kyasu.awt.Label;
import jp.kyasu.awt.TextField;

import jp.kyasu.editor.DocumentEditor;

import jp.kyasu.graphics.TextStyle;
import jp.kyasu.graphics.VTitledPaneBorder;

import org.nomencurator.Publication;

import org.nomencurator.editor.NamedObjectEditPanel;

import org.nomencurator.editor.model.ObjectEditModel;
import org.nomencurator.editor.model.PublicationEditModel;
import org.nomencurator.editor.model.TableModel;

/**
 * <code>Panel</code> to represent a <code>PublicationEditModel</code>
 *
 * @see org.nomencurator.editor.model.PublicationEditModel
 * @see org.nomencurator.Publication
 *
 * @version 	18 Feb 2002
 * @author 	Nozomi `James' Ytow
 */
public class EditedBookEditPanel
    extends BookEditPanel
{
    /**
     * Title of <code>contentsField</code>
     */
    protected static String tableOfContentsFieldTitle = "Chapters";

    /**
     * Creates <code>PublicationEditPanel</code> with specified
     * <code>model</code>, <code>editable</code>, <code>authorEditors</code>
     * <code>appearanceEditors</code>
     */
    public EditedBookEditPanel(PublicationEditModel model)
    {
	super(model, true, false, null, null);
    }

    /**
     * Creates <code>PublicationEditPanel</code> with specified
     * <code>model</code>, <code>editable</code>, <code>authorEditors</code>
     * <code>appearanceEditors</code>
     */
    public EditedBookEditPanel(AbstractPublicationEditPanel panel)
    {
	super(panel.getPublicationEditModel(),
	      panel.isEditable(),
	      panel.isSummaryVisible(),
	      null, null);
    }

    /**
     * Creates <code>PublicationEditPanel</code> with specified
     * <code>model</code>, <code>editable</code>, <code>authorEditors</code>
     * <code>appearanceEditors</code>
     */
    public EditedBookEditPanel(PublicationEditModel model,
			    boolean editable,
			    boolean showSummary,
			    Vector authorEditors,
			    Vector appearanceEditors)
    {
	super(model, editable, showSummary, authorEditors, appearanceEditors);
    }

    /**
     * Creates <code>Component</code>s representing citation information 
     */
    protected void createCitationComponents()
    {
	super.createCitationComponents();
	createTableOfContents();
    }

    /**
     * Creates <code>Component</code>s representing table of contents
     */
    protected void createTableOfContents()
    {
	TableModel tableOfContentsModel = model.getTableOfContentsModel();
	tableOfContents = new TableList(tableOfContentsModel,
					3,
					tableOfContentsModel.getTitle());
    }

    /**
     * Layouts <code>Component</code>s representing contents title of the publication
     */
    protected void layoutContentsField()
    {
	super.layoutContentsField();
	layoutTableOfContents();
    }

    /**
     * Layouts <code>Component</code>s representing table of contents
     */
    protected void layoutTableOfContents()
    {
	citationPanel.add(new Label(tableOfContentsFieldTitle), tableOfContents, GridBagConstraints.HORIZONTAL);
    }

}







