/*
 * EditorSelectAdaptor.java:  an adaptor class support choice of ediros
 * for TaxoNote based on Nomencurator data model
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: EditorSelectAdaptor.java,v 1.1 2002/01/29 09:57:31 nozomi Exp $
 * $Log: EditorSelectAdaptor.java,v $
 * Revision 1.1  2002/01/29 09:57:31  nozomi
 * initial import into CVS
 *
 */

package org.nomencurator.editor;

import java.util.Vector;

import jp.kyasu.awt.List;
import jp.kyasu.awt.TableList;

import jp.kyasu.awt.text.TextListController;

/**
 * An adaptor implementation of <code>EditorSelector</code> interface.
 * @see org.nomencurator.editor.EditorSelector
 *
 * @version 	28 Jan 2002
 * @author 	Nozomi `James' Ytow
 */
public class EditorSelectAdaptor
    implements EditorSelector
{
    /**
     * <code>TextListController</code> to be watched by this object
     */
    protected TextListController listController;

    /**
     * <code>Vector</code> of editors to be selected
     */
    protected Vector editors;

    /**
     * Constructs an <code>EditorSelectAdaptor</code>
     * using <code>list</code> as its reprentation
     */
    public EditorSelectAdaptor(List list)
    {
	this(list.getController());
    }

    /**
     * Constructs an <code>EditorSelectAdaptor</code>
     * using <code>list</code> as its reprentation
     */
    public EditorSelectAdaptor(TableList list)
    {
	this(list.getController());
    }

    /**
     * Constructs an <code>EditorSelectAdaptor</code>
     * using <code>controller</code> as its reprentation
     */
    public EditorSelectAdaptor(TextListController controller)
    {
	setListController(controller);
	editors = new Vector();
    }

    /**
     * Sets <code>list</code> as representation of this selector
     */
    public void setListController(TextListController controller)
    {
	if(listController == controller)
	    return;

	listController = controller;
    }

    /**
     * Adds <code>editor</code> at end of editor list
     *
     * @param editor <code>NamedObjectEditor</code> to be added
     */
    public void addEditor(NamedObjectEditor editor)
    {
	addEditor(-1, editor);
    }

    /**
     * Inserts <code>editor</code> at <code>index</code> of editor list.
     *
     * @param index  where <code>editor</code> to be added
     * @param editor <code>NamedObjectEditor</code> to be added
     */
    public void addEditor(int index, NamedObjectEditor editor)
    {
	editors.insertElementAt(editor, index);
	listController.addItem(editor.getSummaryTextArray(), index);
    }

    /**
     * Release <code>editor</code> from this adaptor's control
     */
    public void removeEditor(NamedObjectEditor editor)
    {
	int index = editors.indexOf(editor);
	if(index < -1)
	    return;
	editors.removeElementAt(index);
	listController.remove(index);
    }
}
