/*
 *
 * GridBagContainer.java:  an interface to arrange Components in a Container
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: GridBagContainer.java,v 1.1 2002/01/29 10:00:36 nozomi Exp $
 *	$Log: GridBagContainer.java,v $
 *	Revision 1.1  2002/01/29 10:00:36  nozomi
 *	initial import into CVS
 *	
 *	
 *
 */

package org.nomencurator.editor;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import jp.kyasu.awt.Label;

/**
 * Interface for a <code>Container</code> arranging
 * <code>Component</code> with specified <code>Label</code>
 * using <code>GridBagLayout</code>.
 *
 * @see java.awt.GridBagConstraints
 * @see java.awt.GridBagLayout
 *
 * @version 	16 Jan 2002
 * @author 	Nozomi `James' Ytow
 */
public interface GridBagContainer
{
    /**
     * Sets <code>manager</code> as <code>LayoutManager</code>
     * to be used 
     *
     * @param manager <code>GridBagLayout</code> to be used
     */
    public void setGridBagLayout(GridBagLayout manager);

    /**
     * Gets the <code>GridBagLayout</code> in use
     *
     * @return GridBagLayout in use
     */
    public GridBagLayout getGridBagLayout();

    /**
     * Sets <code>constraints</code> as <code>GridBagConstraints</code>
     * to be used
     *
     * @param constratins <code>GridBagConstraints</code> to be used
     */
    public void setConstraints(GridBagConstraints constraints);

    /**
     * Gets the <code>GridBagConstraints</code> in use
     *
     * @return GridBagConstraints in use
     */
    public GridBagConstraints getConstraints();

    /**
     * Sets width and height of <code>Insets</code> used
     * when layout <code>Components</code> to be <code>value</code>
     *
     * @param value withd and height of <code>Insets</code>
     */
    public void setInsetsValue(int value);

    /**
     * Gets width and height of <code>Insets</code> to be used
     *
     * @return int width and height of <code>Insets</code>
     */
    public int getInsetsValue();

    /**
     * Adds <code>component</code> to a <code>Container</code>
     * implementing this interface with <code>label</code>
     *
     * @param label <code>Label</code> to be added to a <code>Container</code>
     * @param component <code>Component</code> to be added to a <code>Container</code>
     */
    public void add(Label label, Component component);

    /**
     * Adds <code>component</code> to a <code>Container</code>
     * implementing this interface with <code>label</code>
     *
     * @param label <code>Label</code> to be added to a <code>Container</code>
     * @param component <code>Component</code> to be added to a <code>Container</code>
     * @param fill filling paramter of <code>GridBagConstraints</code>
     */
    public void add(Label label, Component component, int fill);

    /**
     * Adds <code>Component</code>s in <code>component</code> array to a <code>Container</code>
     * implementing this interface with <code>label</code>
     *
     * @param label <code>Label</code> to be added to a <code>Container</code>
     * @param components an array of <code>Component</code>s to be added to a <code>Container</code>
     */
    public void add(Label label, Component[] components);

    /*
    public static final int TOP    = 0;
    public static final int LEFT   = 1;
    public static final int RIGHT  = 2;
    public static final int BOTTOM = 3;

    public static Insets getInsets(int side);
    */
    /*
    protected static int topInsetsValue        = 12;
    protected static int leftInsetsValue       = 12;
    protected static int bottomInsetsValue     = 11;
    protected static int rightInsetsValue      = 12;

    protected static int halfTopInsetsValue    = 6;
    protected static int halfLeftInsetsValue   = 6;
    protected static int halfBottomInsetsValue = 5;
    protected static int halfRightInsetsValue  = 6;

    protected static Insets topInsets = new Insets(topInsetsValue, 0, 0, 0);
    protected static Insets leftInsets = new Insets(0, leftInsetsValue, 0, 0);
    protected static Insets bottomInsets = new Insets(0, 0, bottomInsetsValue, 0);
    protected static Insets rightInsets = new Insets(0, 0, 0, rightInsetsValue);
    protected static Insets lrInsets = new Insets(0, leftInsetsValue, 0, rightInsetsValue);
    protected static Insets topRightInsets = new Insets(topInsetsValue, 0, 0, rightInsetsValue);
    protected static Insets hTRInsets = new Insets(halfTopInsetsValue, 0, 0, rightInsetsValue);


    protected static Insets rightHalfInsets = new Insets(0, 0, 0, halfRightInsetsValue);
    protected static Insets leftmostHalfInsets = new Insets(0, leftInsetsValue, 0, halfRightInsetsValue);    
    protected static Insets vInGroupInsets = new Insets(0, 0, halfBottomInsetsValue, 0);
    protected static Insets hInGroupInsets = new Insets(0, 0, 0, halfRightInsetsValue);
    */
}

