/*
 * HigherNameUsageSearchDialog.java: 
 *
 * Copyright (c) 2002 Ryo FUJIMOTO
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: HigherNameUsageSearchDialog.java,v 1.2 2002/06/05 06:32:14 ryo Exp $
 * $Log: HigherNameUsageSearchDialog.java,v $
 * Revision 1.2  2002/06/05 06:32:14  ryo
 * Set selected data when the window closing button is pressed
 *
 * Revision 1.1  2002/05/16 13:21:09  t.okada
 * add HigherNameUsageSearchDialog class
 *
 */

package org.nomencurator.editor;

//import jp.kyasu.awt.Frame;
import jp.kyasu.awt.Dialog;
import jp.kyasu.awt.BorderedPanel;
import jp.kyasu.awt.Button;
import jp.kyasu.awt.SplitPanel;
import jp.kyasu.graphics.VTitledPaneBorder;
import jp.kyasu.awt.Panel;

import jp.kyasu.awt.Label;
import jp.kyasu.awt.TextField;
import jp.kyasu.awt.TableList;
import jp.kyasu.awt.DefaultTextListModel;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;

import org.nomencurator.editor.model.NameUsageListModel;
import org.nomencurator.editor.model.NameUsageEditModel;

public class HigherNameUsageSearchDialog extends Dialog implements ActionListener {

	protected Frame frame;
	static protected final String L_TITLE = "NameUsage Search";
	static protected final String L_OK = "OK";
	static protected final String L_CANCEL = "Cancel";
	protected Button okButton;
	protected Button cancelButton;
	protected SearchView searchView;
	protected BorderedPanel borderedPanel;
	protected Panel buttonPanel;
	protected SplitPanel splitPanel;

    protected TableList table;
	protected NameUsageListModel nameList;
	protected NameUsageEditModel selectedModel = null;
	protected boolean _isOK = false;

	/**
	 * Constractor
	 * @param Frame frame
	 */
	public HigherNameUsageSearchDialog(Frame frame) {
		this(frame, L_TITLE);
	}

	/**
	 * Constractor
	 * @param Frame frame
	 * @param String title
	 */
	public HigherNameUsageSearchDialog(Frame frame, String title) {
		super(frame, title);
		this.frame = frame;
		init();
	}
	
	/**
	 * Constractor.
	 * @param frame the owner of the dialog
	 * @param title the title of the dialog
	 * @param modal if true, dialog blocks input to other app windows when shown
	 */
	public HigherNameUsageSearchDialog(Frame frame, String title, boolean modal) {
		super(frame, title, modal);
		this.frame = frame;
		init();
	}

	/**
	 * Add NameUsageEditModel
	 * @param NameUsageEditModel
	 * 
	 */
	public void addModel(NameUsageEditModel nameUsageEditModel) {
		nameList.addModel(nameUsageEditModel);
	}

	/**
	 * Get Selected NameUsageEditModel
	 */
	public NameUsageEditModel getSelectedModel() {
		return selectedModel;
	}
	
	/**
	 * 
	 */
	public boolean isOK() {
		return _isOK;
	}

	/**
	 * Initialize this dialog
	 */
	protected void init() {
		enableEvents(AWTEvent.WINDOW_EVENT_MASK);

		borderedPanel = new BorderedPanel(new VTitledPaneBorder(L_TITLE));
		if(nameList == null) {
			nameList = new NameUsageListModel();
		}
		table = new TableList(nameList, 5, nameList.getTitle());
		borderedPanel.add(table);
		
		buttonPanel = new Panel();
		okButton = new Button(L_OK);
		buttonPanel.add(okButton);
		okButton.addActionListener(this);
		cancelButton = new Button(L_CANCEL);
		buttonPanel.add(cancelButton);
		cancelButton.addActionListener(this);

		splitPanel = new SplitPanel(SplitPanel.VERTICAL, 3);
		add(splitPanel, BorderLayout.CENTER);
		splitPanel.add(borderedPanel);
		splitPanel.add(buttonPanel);

		setSize(400, 200);
		pack();
	}
	
	
	/**
	 * @param ActionEvent e
	 */
	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == cancelButton) {
			_isOK = false;
			this.dispose();
		} else if (e.getSource() == okButton) {
			selectedModel = (NameUsageEditModel)nameList.getModel(table.getSelectedIndex());
			_isOK = true;
			this.dispose();
		}
	}

	/**
	 * Set selected data when window closing button is pressed.
	 * @param WindowEvent e
	 */
	protected void processWindowEvent(WindowEvent e) {
		super.processWindowEvent(e);
		if (e.getID() == WindowEvent.WINDOW_CLOSING) {
			selectedModel = (NameUsageEditModel)nameList.getModel(table.getSelectedIndex());
			if (selectedModel != null) {
				_isOK = true;
			} else {
				_isOK = false;
			}
			this.dispose();
		}
	}

	public static void main(String[] args) {
		Frame frame = new Frame();
		HigherNameUsageSearchDialog dialog = new HigherNameUsageSearchDialog(frame);
		dialog.show();
	}
	
}