/*
 * HttpConnectionSettingPanel.java : 
 *
 * Copyright (c) 2002 Ryo FUJIMOTO
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: HttpConnectionSettingPanel.java,v 1.3 2002/07/16 07:12:49 ryo Exp $
 * $Log: HttpConnectionSettingPanel.java,v $
 * Revision 1.3  2002/07/16 07:12:49  ryo
 * CRLF conversion
 *
 * Revision 1.2  2002/07/16 07:09:04  ryo
 * change argument type of constructor from AbstractConnection to ConnectionEditModel
 *
 * Revision 1.1  2002/07/12 16:56:18  ryo
 * initial import into CVS, add connection setting logic
 *
 */

package org.nomencurator.editor;

import org.nomencurator.editor.model.ConnectionEditModel;

public class HttpConnectionSettingPanel
	extends AbstractConnectionSettingPanel {

	/**
	 * Constructor.
	 */
	public HttpConnectionSettingPanel(ConnectionEditModel c) {
		super(c);
	}

	/**
	 * Layouts <code>Component</code>s representing the connection information
	 * @see org.nomencurator.editor.AbstractConnectionSettingPanel#layoutSettingComponents()
	 */
	protected void layoutSettingComponents() {
		layoutNameTextField();
		layoutUrlTextField();
		layoutValidCheckbox();
		layoutWritableCheckbox();
	}

}
